/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.omemo.internal;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

public class CachedDeviceList
implements Serializable {
    private static final long serialVersionUID = 3153579238321261203L;
    private final Set<Integer> activeDevices = new HashSet<Integer>();
    private final Set<Integer> inactiveDevices = new HashSet<Integer>();

    public Set<Integer> getActiveDevices() {
        return this.activeDevices;
    }

    public Set<Integer> getInactiveDevices() {
        return this.inactiveDevices;
    }

    public Set<Integer> getAllDevices() {
        HashSet<Integer> all = new HashSet<Integer>();
        all.addAll(this.activeDevices);
        all.addAll(this.inactiveDevices);
        return all;
    }

    public void merge(Set<Integer> deviceListUpdate) {
        this.inactiveDevices.addAll(this.activeDevices);
        this.activeDevices.clear();
        this.activeDevices.addAll(deviceListUpdate);
        this.inactiveDevices.removeAll(this.activeDevices);
    }

    public void addDevice(int deviceId) {
        this.activeDevices.add(deviceId);
    }

    public boolean contains(int deviceId) {
        return this.activeDevices.contains(deviceId) || this.inactiveDevices.contains(deviceId);
    }

    public String toString() {
        String out = "active: [";
        for (int id : this.activeDevices) {
            out = out + id + " ";
        }
        out = out + "] inacitve: [";
        for (int id : this.inactiveDevices) {
            out = out + id + " ";
        }
        out = out + "]";
        return out;
    }
}

