/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.omemo.provider;

import java.util.ArrayList;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smack.util.stringencoder.Base64;
import org.jivesoftware.smackx.omemo.element.OmemoElement;
import org.jivesoftware.smackx.omemo.element.OmemoVAxolotlElement;
import org.xmlpull.v1.XmlPullParser;

public class OmemoVAxolotlProvider
extends ExtensionElementProvider<OmemoVAxolotlElement> {
    public OmemoVAxolotlElement parse(XmlPullParser parser, int initialDepth) throws Exception {
        boolean inEncrypted = true;
        int sid = -1;
        ArrayList<OmemoElement.OmemoHeader.Key> keys = new ArrayList<OmemoElement.OmemoHeader.Key>();
        byte[] iv = null;
        byte[] payload = null;
        block16: while (inEncrypted) {
            int tag = parser.next();
            String name = parser.getName();
            switch (tag) {
                case 2: {
                    switch (name) {
                        case "header": {
                            for (int i = 0; i < parser.getAttributeCount(); ++i) {
                                if (!parser.getAttributeName(i).equals("sid")) continue;
                                sid = Integer.parseInt(parser.getAttributeValue(i));
                            }
                            continue block16;
                        }
                        case "key": {
                            boolean prekey = false;
                            int rid = -1;
                            for (int i = 0; i < parser.getAttributeCount(); ++i) {
                                if (parser.getAttributeName(i).equals("prekey")) {
                                    prekey = Boolean.parseBoolean(parser.getAttributeValue(i));
                                    continue;
                                }
                                if (!parser.getAttributeName(i).equals("rid")) continue;
                                rid = Integer.parseInt(parser.getAttributeValue(i));
                            }
                            keys.add(new OmemoElement.OmemoHeader.Key(Base64.decode((String)parser.nextText()), rid, prekey));
                            break;
                        }
                        case "iv": {
                            iv = Base64.decode((String)parser.nextText());
                            break;
                        }
                        case "payload": {
                            payload = Base64.decode((String)parser.nextText());
                        }
                    }
                    continue block16;
                }
                case 3: {
                    if (!name.equals("encrypted")) break;
                    inEncrypted = false;
                }
            }
        }
        OmemoElement.OmemoHeader header = new OmemoElement.OmemoHeader(sid, keys, iv);
        return new OmemoVAxolotlElement(header, payload);
    }
}

