/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.omemo;

import java.util.Date;
import java.util.HashSet;
import junit.framework.TestCase;
import org.jivesoftware.smack.test.util.SmackTestSuite;
import org.jivesoftware.smackx.omemo.OmemoConfiguration;
import org.jivesoftware.smackx.omemo.OmemoService;
import org.jivesoftware.smackx.omemo.internal.OmemoDevice;
import org.junit.Test;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.stringprep.XmppStringprepException;

public class OmemoServiceTest
extends SmackTestSuite {
    private static final long ONE_HOUR = 3600000L;
    private static final int IGNORE_STALE = OmemoConfiguration.getIgnoreStaleDevicesAfterHours();
    private static final int DELETE_STALE = OmemoConfiguration.getDeleteStaleDevicesAfterHours();

    @Test(expected=IllegalStateException.class)
    public void getInstanceFailsWhenNullTest() {
        OmemoService.getInstance();
    }

    @Test
    public void isServiceRegisteredTest() {
        TestCase.assertFalse((boolean)OmemoService.isServiceRegistered());
    }

    @Test
    public void isStaleDeviceTest() throws XmppStringprepException {
        OmemoDevice user = new OmemoDevice(JidCreate.bareFrom((String)"alice@wonderland.lit"), 123);
        OmemoDevice other = new OmemoDevice(JidCreate.bareFrom((String)"bob@builder.tv"), 444);
        Date now = new Date();
        Date ignoreMe = new Date(now.getTime() - (long)(IGNORE_STALE + 1) * 3600000L);
        Date deleteMe = new Date(now.getTime() - (long)(DELETE_STALE + 1) * 3600000L);
        Date imFine = new Date(now.getTime() - 3600000L);
        TestCase.assertFalse((boolean)OmemoService.isStale((OmemoDevice)user, (OmemoDevice)other, (Date)imFine, (int)IGNORE_STALE));
        TestCase.assertTrue((boolean)OmemoService.isStale((OmemoDevice)user, (OmemoDevice)other, (Date)ignoreMe, (int)IGNORE_STALE));
        TestCase.assertTrue((boolean)OmemoService.isStale((OmemoDevice)user, (OmemoDevice)other, (Date)deleteMe, (int)DELETE_STALE));
        TestCase.assertFalse((boolean)OmemoService.isStale((OmemoDevice)user, (OmemoDevice)user, (Date)deleteMe, (int)DELETE_STALE));
        TestCase.assertFalse((boolean)OmemoService.isStale((OmemoDevice)user, (OmemoDevice)other, null, (int)DELETE_STALE));
    }

    @Test
    public void removeOurDeviceTest() throws XmppStringprepException {
        OmemoDevice a = new OmemoDevice(JidCreate.bareFrom((String)"a@b.c"), 123);
        OmemoDevice b = new OmemoDevice(JidCreate.bareFrom((String)"a@b.c"), 124);
        HashSet<OmemoDevice> devices = new HashSet<OmemoDevice>();
        devices.add(a);
        devices.add(b);
        TestCase.assertTrue((boolean)devices.contains(a));
        TestCase.assertTrue((boolean)devices.contains(b));
        OmemoService.removeOurDevice((OmemoDevice)a, devices);
        TestCase.assertFalse((boolean)devices.contains(a));
        TestCase.assertTrue((boolean)devices.contains(b));
    }
}

