/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.omemo;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import junit.framework.TestCase;
import org.jivesoftware.smack.test.util.SmackTestSuite;
import org.jivesoftware.smack.test.util.TestUtils;
import org.jivesoftware.smack.util.stringencoder.Base64;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smackx.omemo.element.OmemoBundleElement_VAxolotl;
import org.jivesoftware.smackx.omemo.provider.OmemoBundleVAxolotlProvider;
import org.junit.Assert;
import org.junit.Test;

public class OmemoBundleVAxolotlElementTest
extends SmackTestSuite {
    @Test
    public void serializationTest() throws Exception {
        int signedPreKeyId = 420;
        String signedPreKeyB64 = Base64.encodeToString((byte[])"SignedPreKey".getBytes(StandardCharsets.UTF_8));
        String signedPreKeySigB64 = Base64.encodeToString((byte[])"SignedPreKeySignature".getBytes(StandardCharsets.UTF_8));
        String identityKeyB64 = Base64.encodeToString((byte[])"IdentityKey".getBytes(StandardCharsets.UTF_8));
        int preKeyId1 = 220;
        int preKeyId2 = 284;
        String preKey1B64 = Base64.encodeToString((byte[])"FirstPreKey".getBytes(StandardCharsets.UTF_8));
        String preKey2B64 = Base64.encodeToString((byte[])"SecondPreKey".getBytes(StandardCharsets.UTF_8));
        HashMap<Integer, String> preKeysB64 = new HashMap<Integer, String>();
        preKeysB64.put(preKeyId1, preKey1B64);
        preKeysB64.put(preKeyId2, preKey2B64);
        OmemoBundleElement_VAxolotl bundle = new OmemoBundleElement_VAxolotl(signedPreKeyId, signedPreKeyB64, signedPreKeySigB64, identityKeyB64, preKeysB64);
        TestCase.assertEquals((String)"ElementName must match.", (String)"bundle", (String)bundle.getElementName());
        TestCase.assertEquals((String)"Namespace must match.", (String)"eu.siacs.conversations.axolotl", (String)bundle.getNamespace());
        String expected = "<bundle xmlns='eu.siacs.conversations.axolotl'><signedPreKeyPublic signedPreKeyId='420'>" + signedPreKeyB64 + "</signedPreKeyPublic><signedPreKeySignature>" + signedPreKeySigB64 + "</signedPreKeySignature><identityKey>" + identityKeyB64 + "</identityKey><prekeys><preKeyPublic preKeyId='220'>" + preKey1B64 + "</preKeyPublic><preKeyPublic preKeyId='284'>" + preKey2B64 + "</preKeyPublic></prekeys></bundle>";
        String actual = bundle.toXML().toString();
        TestCase.assertEquals((String)"Bundles XML must match.", (String)expected, (String)actual);
        byte[] signedPreKey = "SignedPreKey".getBytes(StandardCharsets.UTF_8);
        byte[] signedPreKeySig = "SignedPreKeySignature".getBytes(StandardCharsets.UTF_8);
        byte[] identityKey = "IdentityKey".getBytes(StandardCharsets.UTF_8);
        byte[] firstPreKey = "FirstPreKey".getBytes(StandardCharsets.UTF_8);
        byte[] secondPreKey = "SecondPreKey".getBytes(StandardCharsets.UTF_8);
        OmemoBundleElement_VAxolotl parsed = (OmemoBundleElement_VAxolotl)new OmemoBundleVAxolotlProvider().parse(TestUtils.getParser((String)actual));
        Assert.assertTrue((String)"B64-decoded signedPreKey must match.", (boolean)Arrays.equals(signedPreKey, parsed.getSignedPreKey()));
        TestCase.assertEquals((String)"SignedPreKeyId must match", (int)signedPreKeyId, (int)parsed.getSignedPreKeyId());
        Assert.assertTrue((String)"B64-decoded signedPreKey signature must match.", (boolean)Arrays.equals(signedPreKeySig, parsed.getSignedPreKeySignature()));
        Assert.assertTrue((String)"B64-decoded identityKey must match.", (boolean)Arrays.equals(identityKey, parsed.getIdentityKey()));
        Assert.assertTrue((String)"B64-decoded first preKey must match.", (boolean)Arrays.equals(firstPreKey, parsed.getPreKey(220)));
        Assert.assertTrue((String)"B64-decoded second preKey must match.", (boolean)Arrays.equals(secondPreKey, parsed.getPreKey(284)));
        TestCase.assertEquals((String)"toString outputs must match.", (String)bundle.toString(), (String)parsed.toString());
    }

    @Test(expected=IllegalArgumentException.class)
    public void emptyPreKeysShouldFailTest() throws Exception {
        String s = "<bundle xmlns='eu.siacs.conversations.axolotl'><signedPreKeyPublic signedPreKeyId='1'>BU4bJ18+rqbSnBblZU8pR/s+impyhoL9AJssJIE59fZb</signedPreKeyPublic><signedPreKeySignature>MaQtv7ySqHpPr0gkVtMp4KmWC61Hnfs5a7/cKEhrX8n12evGdkg4fNf3Q/ufgmJu5dnup9pkTA1pj00dTbtXjw==</signedPreKeySignature><identityKey>BWO0QOem1YXIJuT61cxXpG/mKlvISDwZxQJHW2/7eVki</identityKey><prekeys></prekeys></bundle>";
        XmlPullParser parser = TestUtils.getParser((String)s);
        new OmemoBundleVAxolotlProvider().parse(parser);
    }

    @Test(expected=IllegalArgumentException.class)
    public void missingPreKeysShouldAlsoFailTest() throws Exception {
        String s = "<bundle xmlns='eu.siacs.conversations.axolotl'><signedPreKeyPublic signedPreKeyId='1'>BU4bJ18+rqbSnBblZU8pR/s+impyhoL9AJssJIE59fZb</signedPreKeyPublic><signedPreKeySignature>MaQtv7ySqHpPr0gkVtMp4KmWC61Hnfs5a7/cKEhrX8n12evGdkg4fNf3Q/ufgmJu5dnup9pkTA1pj00dTbtXjw==</signedPreKeySignature><identityKey>BWO0QOem1YXIJuT61cxXpG/mKlvISDwZxQJHW2/7eVki</identityKey></bundle>";
        XmlPullParser parser = TestUtils.getParser((String)s);
        new OmemoBundleVAxolotlProvider().parse(parser);
    }
}

