/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.omemo;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.util.CloseableUtil;
import org.jivesoftware.smack.util.stringencoder.BareJidEncoder;
import org.jivesoftware.smackx.omemo.OmemoStore;
import org.jivesoftware.smackx.omemo.exceptions.CorruptedOmemoKeyException;
import org.jivesoftware.smackx.omemo.internal.OmemoCachedDeviceList;
import org.jivesoftware.smackx.omemo.internal.OmemoDevice;
import org.jxmpp.jid.BareJid;

public abstract class FileBasedOmemoStore<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess, T_Addr, T_ECPub, T_Bundle, T_Ciph>
extends OmemoStore<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess, T_Addr, T_ECPub, T_Bundle, T_Ciph> {
    private final FileHierarchy hierarchy;
    private static final Logger LOGGER = Logger.getLogger(FileBasedOmemoStore.class.getName());
    private static BareJidEncoder bareJidEncoder = new BareJidEncoder.UrlSafeEncoder();

    public FileBasedOmemoStore(File basePath) {
        if (basePath == null) {
            throw new IllegalStateException("No FileBasedOmemoStoreDefaultPath set in OmemoConfiguration.");
        }
        this.hierarchy = new FileHierarchy(basePath);
    }

    @Override
    public T_IdKeyPair loadOmemoIdentityKeyPair(OmemoDevice userDevice) throws CorruptedOmemoKeyException {
        File identityKeyPairPath = this.hierarchy.getIdentityKeyPairPath(userDevice);
        return this.keyUtil().identityKeyPairFromBytes(FileBasedOmemoStore.readBytes(identityKeyPairPath));
    }

    @Override
    public void storeOmemoIdentityKeyPair(OmemoDevice userDevice, T_IdKeyPair identityKeyPair) {
        File identityKeyPairPath = this.hierarchy.getIdentityKeyPairPath(userDevice);
        FileBasedOmemoStore.writeBytes(identityKeyPairPath, this.keyUtil().identityKeyPairToBytes(identityKeyPair));
    }

    @Override
    public void removeOmemoIdentityKeyPair(OmemoDevice userDevice) {
        File identityKeyPairPath = this.hierarchy.getIdentityKeyPairPath(userDevice);
        if (!identityKeyPairPath.delete()) {
            LOGGER.log(Level.WARNING, "Could not delete OMEMO IdentityKeyPair " + identityKeyPairPath.getAbsolutePath());
        }
    }

    @Override
    public T_IdKey loadOmemoIdentityKey(OmemoDevice userDevice, OmemoDevice contactsDevice) throws CorruptedOmemoKeyException {
        File identityKeyPath = this.hierarchy.getContactsIdentityKeyPath(userDevice, contactsDevice);
        byte[] bytes = FileBasedOmemoStore.readBytes(identityKeyPath);
        return bytes != null ? (T_IdKey)this.keyUtil().identityKeyFromBytes(bytes) : null;
    }

    @Override
    public void storeOmemoIdentityKey(OmemoDevice userDevice, OmemoDevice contactsDevice, T_IdKey t_idKey) {
        File identityKeyPath = this.hierarchy.getContactsIdentityKeyPath(userDevice, contactsDevice);
        FileBasedOmemoStore.writeBytes(identityKeyPath, this.keyUtil().identityKeyToBytes(t_idKey));
    }

    @Override
    public void removeOmemoIdentityKey(OmemoDevice userDevice, OmemoDevice contactsDevice) {
        File identityKeyPath = this.hierarchy.getContactsIdentityKeyPath(userDevice, contactsDevice);
        if (!identityKeyPath.delete()) {
            LOGGER.log(Level.WARNING, "Could not delete OMEMO identityKey " + identityKeyPath.getAbsolutePath());
        }
    }

    @Override
    public SortedSet<Integer> localDeviceIdsOf(BareJid localUser) {
        TreeSet<Integer> deviceIds = new TreeSet<Integer>();
        File userDir = this.hierarchy.getUserDirectory(localUser);
        File[] list = userDir.listFiles();
        for (File d : list != null ? list : new File[]{}) {
            if (!d.isDirectory()) continue;
            try {
                deviceIds.add(Integer.parseInt(d.getName()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return deviceIds;
    }

    @Override
    public void setDateOfLastReceivedMessage(OmemoDevice userDevice, OmemoDevice contactsDevice, Date date) {
        File lastMessageReceived = this.hierarchy.getLastMessageReceivedDatePath(userDevice, contactsDevice);
        FileBasedOmemoStore.writeLong(lastMessageReceived, date.getTime());
    }

    @Override
    public Date getDateOfLastReceivedMessage(OmemoDevice userDevice, OmemoDevice contactsDevice) {
        File lastMessageReceived = this.hierarchy.getLastMessageReceivedDatePath(userDevice, contactsDevice);
        Long date = FileBasedOmemoStore.readLong(lastMessageReceived);
        return date != null ? new Date(date) : null;
    }

    @Override
    public void setDateOfLastDeviceIdPublication(OmemoDevice userDevice, OmemoDevice contactsDevice, Date date) {
        File lastDeviceIdPublished = this.hierarchy.getLastDeviceIdPublicationDatePath(userDevice, contactsDevice);
        FileBasedOmemoStore.writeLong(lastDeviceIdPublished, date.getTime());
    }

    @Override
    public Date getDateOfLastDeviceIdPublication(OmemoDevice userDevice, OmemoDevice contactsDevice) {
        File lastDeviceIdPublished = this.hierarchy.getLastDeviceIdPublicationDatePath(userDevice, contactsDevice);
        Long date = FileBasedOmemoStore.readLong(lastDeviceIdPublished);
        return date != null ? new Date(date) : null;
    }

    @Override
    public void setDateOfLastSignedPreKeyRenewal(OmemoDevice userDevice, Date date) {
        File lastSignedPreKeyRenewal = this.hierarchy.getLastSignedPreKeyRenewal(userDevice);
        FileBasedOmemoStore.writeLong(lastSignedPreKeyRenewal, date.getTime());
    }

    @Override
    public Date getDateOfLastSignedPreKeyRenewal(OmemoDevice userDevice) {
        File lastSignedPreKeyRenewal = this.hierarchy.getLastSignedPreKeyRenewal(userDevice);
        Long date = FileBasedOmemoStore.readLong(lastSignedPreKeyRenewal);
        return date != null ? new Date(date) : null;
    }

    @Override
    public T_PreKey loadOmemoPreKey(OmemoDevice userDevice, int preKeyId) {
        File preKeyPath = this.hierarchy.getPreKeyPath(userDevice, preKeyId);
        byte[] bytes = FileBasedOmemoStore.readBytes(preKeyPath);
        if (bytes != null) {
            try {
                return this.keyUtil().preKeyFromBytes(bytes);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Could not deserialize preKey from bytes.", e);
            }
        }
        return null;
    }

    @Override
    public void storeOmemoPreKey(OmemoDevice userDevice, int preKeyId, T_PreKey t_preKey) {
        File preKeyPath = this.hierarchy.getPreKeyPath(userDevice, preKeyId);
        FileBasedOmemoStore.writeBytes(preKeyPath, this.keyUtil().preKeyToBytes(t_preKey));
    }

    @Override
    public void removeOmemoPreKey(OmemoDevice userDevice, int preKeyId) {
        File preKeyPath = this.hierarchy.getPreKeyPath(userDevice, preKeyId);
        if (!preKeyPath.delete()) {
            LOGGER.log(Level.WARNING, "Deleting OMEMO preKey " + preKeyPath.getAbsolutePath() + " failed.");
        }
    }

    @Override
    public TreeMap<Integer, T_PreKey> loadOmemoPreKeys(OmemoDevice userDevice) {
        File preKeyDirectory = this.hierarchy.getPreKeysDirectory(userDevice);
        TreeMap preKeys = new TreeMap();
        if (preKeyDirectory == null) {
            return preKeys;
        }
        File[] keys = preKeyDirectory.listFiles();
        for (File f : keys != null ? keys : new File[]{}) {
            byte[] bytes = FileBasedOmemoStore.readBytes(f);
            if (bytes == null) continue;
            try {
                Object p = this.keyUtil().preKeyFromBytes(bytes);
                preKeys.put(Integer.parseInt(f.getName()), p);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Could not deserialize preKey from bytes.", e);
            }
        }
        return preKeys;
    }

    @Override
    public T_SigPreKey loadOmemoSignedPreKey(OmemoDevice userDevice, int signedPreKeyId) {
        File signedPreKeyPath = new File(this.hierarchy.getSignedPreKeysDirectory(userDevice), Integer.toString(signedPreKeyId));
        byte[] bytes = FileBasedOmemoStore.readBytes(signedPreKeyPath);
        if (bytes != null) {
            try {
                return this.keyUtil().signedPreKeyFromBytes(bytes);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Could not deserialize signed preKey from bytes.", e);
            }
        }
        return null;
    }

    @Override
    public TreeMap<Integer, T_SigPreKey> loadOmemoSignedPreKeys(OmemoDevice userDevice) {
        File signedPreKeysDirectory = this.hierarchy.getSignedPreKeysDirectory(userDevice);
        TreeMap signedPreKeys = new TreeMap();
        if (signedPreKeysDirectory == null) {
            return signedPreKeys;
        }
        File[] keys = signedPreKeysDirectory.listFiles();
        for (File f : keys != null ? keys : new File[]{}) {
            byte[] bytes = FileBasedOmemoStore.readBytes(f);
            if (bytes == null) continue;
            try {
                Object p = this.keyUtil().signedPreKeyFromBytes(bytes);
                signedPreKeys.put(Integer.parseInt(f.getName()), p);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Could not deserialize signed preKey.", e);
            }
        }
        return signedPreKeys;
    }

    @Override
    public void storeOmemoSignedPreKey(OmemoDevice userDevice, int signedPreKeyId, T_SigPreKey signedPreKey) {
        File signedPreKeyPath = new File(this.hierarchy.getSignedPreKeysDirectory(userDevice), Integer.toString(signedPreKeyId));
        FileBasedOmemoStore.writeBytes(signedPreKeyPath, this.keyUtil().signedPreKeyToBytes(signedPreKey));
    }

    @Override
    public void removeOmemoSignedPreKey(OmemoDevice userDevice, int signedPreKeyId) {
        File signedPreKeyPath = new File(this.hierarchy.getSignedPreKeysDirectory(userDevice), Integer.toString(signedPreKeyId));
        if (!signedPreKeyPath.delete()) {
            LOGGER.log(Level.WARNING, "Deleting signed OMEMO preKey " + signedPreKeyPath.getAbsolutePath() + " failed.");
        }
    }

    @Override
    public T_Sess loadRawSession(OmemoDevice userDevice, OmemoDevice contactsDevice) {
        File sessionPath = this.hierarchy.getContactsSessionPath(userDevice, contactsDevice);
        byte[] bytes = FileBasedOmemoStore.readBytes(sessionPath);
        if (bytes != null) {
            try {
                return this.keyUtil().rawSessionFromBytes(bytes);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Could not deserialize raw session.", e);
            }
        }
        return null;
    }

    @Override
    public HashMap<Integer, T_Sess> loadAllRawSessionsOf(OmemoDevice userDevice, BareJid contact) {
        File contactsDirectory = this.hierarchy.getContactsDir(userDevice, contact);
        HashMap sessions = new HashMap();
        String[] devices = contactsDirectory.list();
        for (String deviceId : devices != null ? devices : new String[]{}) {
            int id;
            try {
                id = Integer.parseInt(deviceId);
            }
            catch (NumberFormatException e) {
                continue;
            }
            OmemoDevice device = new OmemoDevice(contact, id);
            File session = this.hierarchy.getContactsSessionPath(userDevice, device);
            byte[] bytes = FileBasedOmemoStore.readBytes(session);
            if (bytes == null) continue;
            try {
                Object s = this.keyUtil().rawSessionFromBytes(bytes);
                sessions.put(id, s);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Could not deserialize raw session.", e);
            }
        }
        return sessions;
    }

    @Override
    public void storeRawSession(OmemoDevice userDevice, OmemoDevice contactsDevice, T_Sess session) {
        File sessionPath = this.hierarchy.getContactsSessionPath(userDevice, contactsDevice);
        FileBasedOmemoStore.writeBytes(sessionPath, this.keyUtil().rawSessionToBytes(session));
    }

    @Override
    public void removeRawSession(OmemoDevice userDevice, OmemoDevice contactsDevice) {
        File sessionPath = this.hierarchy.getContactsSessionPath(userDevice, contactsDevice);
        if (!sessionPath.delete()) {
            LOGGER.log(Level.WARNING, "Deleting raw OMEMO session " + sessionPath.getAbsolutePath() + " failed.");
        }
    }

    @Override
    public void removeAllRawSessionsOf(OmemoDevice userDevice, BareJid contact) {
        File contactsDirectory = this.hierarchy.getContactsDir(userDevice, contact);
        String[] devices = contactsDirectory.list();
        for (String deviceId : devices != null ? devices : new String[]{}) {
            int id = Integer.parseInt(deviceId);
            OmemoDevice device = new OmemoDevice(contact, id);
            File session = this.hierarchy.getContactsSessionPath(userDevice, device);
            if (session.delete()) continue;
            LOGGER.log(Level.WARNING, "Deleting raw OMEMO session " + session.getAbsolutePath() + "failed.");
        }
    }

    @Override
    public boolean containsRawSession(OmemoDevice userDevice, OmemoDevice contactsDevice) {
        File session = this.hierarchy.getContactsSessionPath(userDevice, contactsDevice);
        return session.exists();
    }

    @Override
    public void storeOmemoMessageCounter(OmemoDevice userDevice, OmemoDevice contactsDevice, int counter) {
        File messageCounterFile = this.hierarchy.getDevicesMessageCounterPath(userDevice, contactsDevice);
        FileBasedOmemoStore.writeIntegers(messageCounterFile, Collections.singleton(counter));
    }

    @Override
    public int loadOmemoMessageCounter(OmemoDevice userDevice, OmemoDevice contactsDevice) {
        File messageCounterFile = this.hierarchy.getDevicesMessageCounterPath(userDevice, contactsDevice);
        Set<Integer> integers = FileBasedOmemoStore.readIntegers(messageCounterFile);
        if (integers == null || integers.isEmpty()) {
            return 0;
        }
        return integers.iterator().next();
    }

    @Override
    public OmemoCachedDeviceList loadCachedDeviceList(OmemoDevice userDevice, BareJid contact) {
        File inactiveDevicesPath;
        Set<Integer> inactive;
        OmemoCachedDeviceList cachedDeviceList = new OmemoCachedDeviceList();
        if (contact == null) {
            throw new IllegalArgumentException("Contact can not be null.");
        }
        File activeDevicesPath = this.hierarchy.getContactsActiveDevicesPath(userDevice, contact);
        Set<Integer> active = FileBasedOmemoStore.readIntegers(activeDevicesPath);
        if (active != null) {
            cachedDeviceList.getActiveDevices().addAll(active);
        }
        if ((inactive = FileBasedOmemoStore.readIntegers(inactiveDevicesPath = this.hierarchy.getContactsInactiveDevicesPath(userDevice, contact))) != null) {
            cachedDeviceList.getInactiveDevices().addAll(inactive);
        }
        return cachedDeviceList;
    }

    @Override
    public void storeCachedDeviceList(OmemoDevice userDevice, BareJid contact, OmemoCachedDeviceList contactsDeviceList) {
        if (contact == null) {
            return;
        }
        File activeDevices = this.hierarchy.getContactsActiveDevicesPath(userDevice, contact);
        FileBasedOmemoStore.writeIntegers(activeDevices, contactsDeviceList.getActiveDevices());
        File inactiveDevices = this.hierarchy.getContactsInactiveDevicesPath(userDevice, contact);
        FileBasedOmemoStore.writeIntegers(inactiveDevices, contactsDeviceList.getInactiveDevices());
    }

    @Override
    public void purgeOwnDeviceKeys(OmemoDevice userDevice) {
        File deviceDirectory = this.hierarchy.getUserDeviceDirectory(userDevice);
        FileBasedOmemoStore.deleteDirectory(deviceDirectory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeLong(File target, long i) {
        if (target == null) {
            LOGGER.log(Level.WARNING, "Could not write long to null-path.");
            return;
        }
        try {
            FileHierarchy.createFile(target);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Could not create file.", e);
            return;
        }
        DataOutputStream out = null;
        try {
            out = new DataOutputStream(new FileOutputStream(target));
            out.writeLong(i);
        }
        catch (IOException e) {
            try {
                LOGGER.log(Level.SEVERE, "Could not write longs to file.", e);
            }
            catch (Throwable throwable) {
                CloseableUtil.maybeClose(out, (Logger)LOGGER);
                throw throwable;
            }
            CloseableUtil.maybeClose((Closeable)out, (Logger)LOGGER);
        }
        CloseableUtil.maybeClose((Closeable)out, (Logger)LOGGER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static Long readLong(File target) {
        Long l;
        if (target == null) {
            LOGGER.log(Level.WARNING, "Could not read long from null-path.");
            return null;
        }
        DataInputStream in = null;
        try {
            in = new DataInputStream(new FileInputStream(target));
            l = in.readLong();
        }
        catch (FileNotFoundException e) {
            l = null;
            CloseableUtil.maybeClose((Closeable)in, (Logger)LOGGER);
        }
        catch (IOException e2) {
            LOGGER.log(Level.SEVERE, "Could not read long from file.", e2);
            Long l2 = null;
            {
                catch (Throwable throwable) {
                    CloseableUtil.maybeClose(in, (Logger)LOGGER);
                    throw throwable;
                }
            }
            CloseableUtil.maybeClose((Closeable)in, (Logger)LOGGER);
            return l2;
        }
        CloseableUtil.maybeClose((Closeable)in, (Logger)LOGGER);
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeBytes(File target, byte[] bytes) {
        if (target == null) {
            LOGGER.log(Level.WARNING, "Could not write bytes to null-path.");
            return;
        }
        try {
            FileHierarchy.createFile(target);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Could not create file.", e);
            return;
        }
        DataOutputStream out = null;
        try {
            out = new DataOutputStream(new FileOutputStream(target));
            out.write(bytes);
        }
        catch (IOException e) {
            try {
                LOGGER.log(Level.SEVERE, "Could not write bytes to file.", e);
            }
            catch (Throwable throwable) {
                CloseableUtil.maybeClose(out, (Logger)LOGGER);
                throw throwable;
            }
            CloseableUtil.maybeClose((Closeable)out, (Logger)LOGGER);
        }
        CloseableUtil.maybeClose((Closeable)out, (Logger)LOGGER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static byte[] readBytes(File target) {
        if (target == null) {
            LOGGER.log(Level.WARNING, "Could not read bytes from null-path.");
            return null;
        }
        byte[] b = null;
        DataInputStream in = null;
        try {
            in = new DataInputStream(new FileInputStream(target));
            b = new byte[(int)target.length()];
            in.read(b);
        }
        catch (FileNotFoundException e) {
            b = null;
            CloseableUtil.maybeClose((Closeable)in, (Logger)LOGGER);
        }
        catch (IOException e2) {
            LOGGER.log(Level.SEVERE, "Could not read bytes from file.", e2);
            {
                catch (Throwable throwable) {
                    CloseableUtil.maybeClose(in, (Logger)LOGGER);
                    throw throwable;
                }
            }
            CloseableUtil.maybeClose((Closeable)in, (Logger)LOGGER);
        }
        CloseableUtil.maybeClose((Closeable)in, (Logger)LOGGER);
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeIntegers(File target, Set<Integer> integers) {
        if (target == null) {
            LOGGER.log(Level.WARNING, "Could not write integers to null-path.");
            return;
        }
        DataOutputStream out = null;
        try {
            out = new DataOutputStream(new FileOutputStream(target));
            for (int i : integers) {
                out.writeInt(i);
            }
        }
        catch (IOException e) {
            try {
                LOGGER.log(Level.SEVERE, "Could not write integers to file.", e);
            }
            catch (Throwable throwable) {
                CloseableUtil.maybeClose(out, (Logger)LOGGER);
                throw throwable;
            }
            CloseableUtil.maybeClose((Closeable)out, (Logger)LOGGER);
        }
        CloseableUtil.maybeClose((Closeable)out, (Logger)LOGGER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static Set<Integer> readIntegers(File target) {
        if (target == null) {
            LOGGER.log(Level.WARNING, "Could not read integers from null-path.");
            return null;
        }
        HashSet<Integer> integers = new HashSet<Integer>();
        DataInputStream in = null;
        try {
            in = new DataInputStream(new FileInputStream(target));
            try {
                while (true) {
                    integers.add(in.readInt());
                }
            }
            catch (EOFException eOFException) {
                CloseableUtil.maybeClose((Closeable)in, (Logger)LOGGER);
            }
        }
        catch (FileNotFoundException e) {
            integers = null;
            CloseableUtil.maybeClose((Closeable)in, (Logger)LOGGER);
        }
        catch (IOException e2) {
            LOGGER.log(Level.SEVERE, "Could not read integers.", e2);
            {
                catch (Throwable throwable) {
                    CloseableUtil.maybeClose(in, (Logger)LOGGER);
                    throw throwable;
                }
            }
            CloseableUtil.maybeClose((Closeable)in, (Logger)LOGGER);
        }
        return integers;
    }

    public static void deleteDirectory(File root) {
        Stack<File> stack = new Stack<File>();
        stack.push(root);
        while (!stack.isEmpty()) {
            if (((File)stack.lastElement()).isDirectory()) {
                File[] currList = ((File)stack.lastElement()).listFiles();
                if (currList != null && currList.length > 0) {
                    for (File curr : currList) {
                        stack.push(curr);
                    }
                    continue;
                }
                ((File)stack.pop()).delete();
                continue;
            }
            ((File)stack.pop()).delete();
        }
    }

    public static void useLegacyBareJidEncoding() {
        bareJidEncoder = new BareJidEncoder.LegacyEncoder();
    }

    public static class FileHierarchy {
        static final String STORE = "OMEMO_Store";
        static final String CONTACTS = "contacts";
        static final String IDENTITY_KEY = "identityKey";
        static final String IDENTITY_KEY_PAIR = "identityKeyPair";
        static final String PRE_KEYS = "preKeys";
        static final String LAST_MESSAGE_RECEVIED_DATE = "lastMessageReceivedDate";
        static final String LAST_DEVICEID_PUBLICATION_DATE = "lastDeviceIdPublicationDate";
        static final String SIGNED_PRE_KEYS = "signedPreKeys";
        static final String LAST_SIGNED_PRE_KEY_RENEWAL = "lastSignedPreKeyRenewal";
        static final String SESSION = "session";
        static final String DEVICE_LIST_ACTIVE = "activeDevices";
        static final String DEVICE_LIST_INAVTIVE = "inactiveDevices";
        static final String MESSAGE_COUNTER = "messageCounter";
        File basePath;

        FileHierarchy(File basePath) {
            this.basePath = basePath;
            basePath.mkdirs();
        }

        File getStoreDirectory() {
            return FileHierarchy.createDirectory(this.basePath, STORE);
        }

        File getUserDirectory(OmemoDevice userDevice) {
            return this.getUserDirectory(userDevice.getJid());
        }

        File getUserDirectory(BareJid bareJid) {
            return FileHierarchy.createDirectory(this.getStoreDirectory(), bareJidEncoder.encode((Object)bareJid));
        }

        File getUserDeviceDirectory(OmemoDevice userDevice) {
            return FileHierarchy.createDirectory(this.getUserDirectory(userDevice.getJid()), Integer.toString(userDevice.getDeviceId()));
        }

        File getContactsDir(OmemoDevice userDevice) {
            return FileHierarchy.createDirectory(this.getUserDeviceDirectory(userDevice), CONTACTS);
        }

        File getContactsDir(OmemoDevice userDevice, BareJid contact) {
            return FileHierarchy.createDirectory(this.getContactsDir(userDevice), bareJidEncoder.encode((Object)contact));
        }

        File getContactsDir(OmemoDevice userDevice, OmemoDevice contactsDevice) {
            return FileHierarchy.createDirectory(this.getContactsDir(userDevice, contactsDevice.getJid()), Integer.toString(contactsDevice.getDeviceId()));
        }

        File getIdentityKeyPairPath(OmemoDevice userDevice) {
            return new File(this.getUserDeviceDirectory(userDevice), IDENTITY_KEY_PAIR);
        }

        File getPreKeysDirectory(OmemoDevice userDevice) {
            return FileHierarchy.createDirectory(this.getUserDeviceDirectory(userDevice), PRE_KEYS);
        }

        File getPreKeyPath(OmemoDevice userDevice, int preKeyId) {
            return new File(this.getPreKeysDirectory(userDevice), Integer.toString(preKeyId));
        }

        File getLastMessageReceivedDatePath(OmemoDevice userDevice, OmemoDevice device) {
            return new File(this.getContactsDir(userDevice, device), LAST_MESSAGE_RECEVIED_DATE);
        }

        File getLastDeviceIdPublicationDatePath(OmemoDevice userDevice, OmemoDevice device) {
            return new File(this.getContactsDir(userDevice, device), LAST_DEVICEID_PUBLICATION_DATE);
        }

        File getSignedPreKeysDirectory(OmemoDevice userDevice) {
            return FileHierarchy.createDirectory(this.getUserDeviceDirectory(userDevice), SIGNED_PRE_KEYS);
        }

        File getLastSignedPreKeyRenewal(OmemoDevice userDevice) {
            return new File(this.getUserDeviceDirectory(userDevice), LAST_SIGNED_PRE_KEY_RENEWAL);
        }

        File getContactsIdentityKeyPath(OmemoDevice userDevice, OmemoDevice contactsDevice) {
            return new File(this.getContactsDir(userDevice, contactsDevice), IDENTITY_KEY);
        }

        File getContactsSessionPath(OmemoDevice userDevice, OmemoDevice contactsDevice) {
            return new File(this.getContactsDir(userDevice, contactsDevice), SESSION);
        }

        File getContactsActiveDevicesPath(OmemoDevice userDevice, BareJid contact) {
            return new File(this.getContactsDir(userDevice, contact), DEVICE_LIST_ACTIVE);
        }

        File getContactsInactiveDevicesPath(OmemoDevice userDevice, BareJid contact) {
            return new File(this.getContactsDir(userDevice, contact), DEVICE_LIST_INAVTIVE);
        }

        File getDevicesMessageCounterPath(OmemoDevice userDevice, OmemoDevice otherDevice) {
            return new File(this.getContactsDir(userDevice, otherDevice), MESSAGE_COUNTER);
        }

        private static File createFile(File f) throws IOException {
            File p = f.getParentFile();
            FileHierarchy.createDirectory(p);
            f.createNewFile();
            return f;
        }

        private static File createDirectory(File dir, String subdir) {
            File f = new File(dir, subdir);
            return FileHierarchy.createDirectory(f);
        }

        private static File createDirectory(File f) {
            if (f.exists() && f.isDirectory()) {
                return f;
            }
            f.mkdirs();
            return f;
        }
    }
}

