/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.omemo.element;

import java.util.ArrayList;
import java.util.List;
import org.jivesoftware.smack.packet.Element;
import org.jivesoftware.smack.packet.NamedElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smack.util.stringencoder.Base64;
import org.jivesoftware.smackx.omemo.element.OmemoKeyElement;

public abstract class OmemoHeaderElement
implements NamedElement {
    public static final String NAME_HEADER = "header";
    public static final String ATTR_SID = "sid";
    public static final String ATTR_IV = "iv";
    private final int sid;
    private final List<OmemoKeyElement> keys;
    private final byte[] iv;

    public OmemoHeaderElement(int sid, List<OmemoKeyElement> keys, byte[] iv) {
        this.sid = sid;
        this.keys = keys;
        this.iv = iv;
    }

    public int getSid() {
        return this.sid;
    }

    public ArrayList<OmemoKeyElement> getKeys() {
        return new ArrayList<OmemoKeyElement>(this.keys);
    }

    public byte[] getIv() {
        return this.iv != null ? (byte[])this.iv.clone() : null;
    }

    public String getElementName() {
        return NAME_HEADER;
    }

    public CharSequence toXML(XmlEnvironment enclosingNamespace) {
        XmlStringBuilder sb = new XmlStringBuilder((NamedElement)this);
        sb.attribute(ATTR_SID, this.getSid()).rightAngleBracket();
        for (OmemoKeyElement k : this.getKeys()) {
            sb.element((Element)k);
        }
        sb.openElement(ATTR_IV).append((CharSequence)Base64.encodeToString((byte[])this.getIv())).closeElement(ATTR_IV);
        return sb.closeElement((NamedElement)this);
    }
}

