/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.omemo.element;

import org.jivesoftware.smack.packet.NamedElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smack.util.stringencoder.Base64;

public class OmemoKeyElement
implements NamedElement {
    public static final String NAME_KEY = "key";
    public static final String ATTR_RID = "rid";
    public static final String ATTR_PREKEY = "prekey";
    private final byte[] data;
    private final int id;
    private final boolean preKey;

    public OmemoKeyElement(byte[] data, int id) {
        this.data = data;
        this.id = id;
        this.preKey = false;
    }

    public OmemoKeyElement(byte[] data, int id, boolean preKey) {
        this.data = data;
        this.id = id;
        this.preKey = preKey;
    }

    public int getId() {
        return this.id;
    }

    public byte[] getData() {
        return this.data;
    }

    public boolean isPreKey() {
        return this.preKey;
    }

    public String toString() {
        return Integer.toString(this.id);
    }

    public String getElementName() {
        return NAME_KEY;
    }

    public CharSequence toXML(XmlEnvironment enclosingNamespace) {
        XmlStringBuilder sb = new XmlStringBuilder((NamedElement)this);
        if (this.isPreKey()) {
            sb.attribute(ATTR_PREKEY, true);
        }
        sb.attribute(ATTR_RID, this.getId());
        sb.rightAngleBracket();
        sb.append((CharSequence)Base64.encodeToString((byte[])this.getData()));
        sb.closeElement((NamedElement)this);
        return sb;
    }
}

