/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.omemo.internal;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

public class OmemoCachedDeviceList
implements Serializable {
    private static final long serialVersionUID = 3153579238321261203L;
    private final Set<Integer> activeDevices = new HashSet<Integer>();
    private final Set<Integer> inactiveDevices = new HashSet<Integer>();

    public OmemoCachedDeviceList() {
    }

    public OmemoCachedDeviceList(Set<Integer> activeDevices, Set<Integer> inactiveDevices) {
        this();
        this.activeDevices.addAll(activeDevices);
        this.inactiveDevices.addAll(inactiveDevices);
    }

    public OmemoCachedDeviceList(OmemoCachedDeviceList original) {
        this(original.getActiveDevices(), original.getInactiveDevices());
    }

    public Set<Integer> getActiveDevices() {
        return this.activeDevices;
    }

    public Set<Integer> getInactiveDevices() {
        return this.inactiveDevices;
    }

    public Set<Integer> getAllDevices() {
        HashSet<Integer> all = new HashSet<Integer>();
        all.addAll(this.activeDevices);
        all.addAll(this.inactiveDevices);
        return all;
    }

    public void merge(Set<Integer> deviceListUpdate) {
        this.inactiveDevices.addAll(this.activeDevices);
        this.activeDevices.clear();
        this.activeDevices.addAll(deviceListUpdate);
        this.inactiveDevices.removeAll(this.activeDevices);
    }

    public void addDevice(int deviceId) {
        this.activeDevices.add(deviceId);
        this.inactiveDevices.remove(deviceId);
    }

    public void addInactiveDevice(int deviceId) {
        this.activeDevices.remove(deviceId);
        this.inactiveDevices.add(deviceId);
    }

    public boolean contains(int deviceId) {
        return this.activeDevices.contains(deviceId) || this.inactiveDevices.contains(deviceId);
    }

    public boolean isActive(int deviceId) {
        return this.getActiveDevices().contains(deviceId);
    }

    public String toString() {
        String out = "active: [";
        for (int id : this.activeDevices) {
            out = out + id + " ";
        }
        out = out + "] inacitve: [";
        for (int id : this.inactiveDevices) {
            out = out + id + " ";
        }
        out = out + "]";
        return out;
    }
}

