/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.omemo;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.jivesoftware.smack.test.util.SmackTestSuite;
import org.jivesoftware.smack.test.util.TestUtils;
import org.jivesoftware.smack.util.stringencoder.Base64;
import org.jivesoftware.smackx.omemo.element.OmemoElement_VAxolotl;
import org.jivesoftware.smackx.omemo.element.OmemoHeaderElement_VAxolotl;
import org.jivesoftware.smackx.omemo.element.OmemoKeyElement;
import org.jivesoftware.smackx.omemo.provider.OmemoVAxolotlProvider;
import org.jivesoftware.smackx.omemo.util.OmemoMessageBuilder;
import org.junit.Assert;
import org.junit.Test;

public class OmemoVAxolotlElementTest
extends SmackTestSuite {
    @Test
    public void serializationTest() throws Exception {
        byte[] payload = "This is payload.".getBytes(StandardCharsets.UTF_8);
        int keyId1 = 8;
        int keyId2 = 33333;
        byte[] keyData1 = "KEYDATA".getBytes(StandardCharsets.UTF_8);
        byte[] keyData2 = "DATAKEY".getBytes(StandardCharsets.UTF_8);
        int sid = 12131415;
        byte[] iv = OmemoMessageBuilder.generateIv();
        ArrayList<OmemoKeyElement> keys = new ArrayList<OmemoKeyElement>();
        keys.add(new OmemoKeyElement(keyData1, keyId1));
        keys.add(new OmemoKeyElement(keyData2, keyId2, true));
        OmemoHeaderElement_VAxolotl header = new OmemoHeaderElement_VAxolotl(sid, keys, iv);
        OmemoElement_VAxolotl element = new OmemoElement_VAxolotl(header, payload);
        String expected = "<encrypted xmlns='eu.siacs.conversations.axolotl'><header sid='12131415'><key rid='8'>" + Base64.encodeToString((byte[])keyData1) + "</key><key prekey='true' rid='33333'>" + Base64.encodeToString((byte[])keyData2) + "</key><iv>" + Base64.encodeToString((byte[])iv) + "</iv></header><payload>" + Base64.encodeToString((byte[])payload) + "</payload></encrypted>";
        String actual = element.toXML().toString();
        Assert.assertEquals((String)"Serialized xml of OmemoElement must match.", (Object)expected, (Object)actual);
        OmemoElement_VAxolotl parsed = (OmemoElement_VAxolotl)new OmemoVAxolotlProvider().parse(TestUtils.getParser((String)actual));
        Assert.assertEquals((String)"Parsed OmemoElement must equal the original.", (Object)element.toXML().toString(), (Object)parsed.toXML().toString());
    }
}

