/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.omemo;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import org.jivesoftware.smackx.omemo.OmemoManager;
import org.jivesoftware.smackx.omemo.OmemoStore;
import org.jivesoftware.smackx.omemo.element.OmemoElement;
import org.jivesoftware.smackx.omemo.element.OmemoKeyElement;
import org.jivesoftware.smackx.omemo.exceptions.CorruptedOmemoKeyException;
import org.jivesoftware.smackx.omemo.exceptions.CryptoFailedException;
import org.jivesoftware.smackx.omemo.exceptions.MultipleCryptoFailedException;
import org.jivesoftware.smackx.omemo.exceptions.NoRawSessionException;
import org.jivesoftware.smackx.omemo.exceptions.UntrustedOmemoIdentityException;
import org.jivesoftware.smackx.omemo.internal.CipherAndAuthTag;
import org.jivesoftware.smackx.omemo.internal.CiphertextTuple;
import org.jivesoftware.smackx.omemo.internal.OmemoDevice;

public abstract class OmemoRatchet<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess, T_Addr, T_ECPub, T_Bundle, T_Ciph> {
    private static final Logger LOGGER = Logger.getLogger(OmemoRatchet.class.getName());
    protected final OmemoManager omemoManager;
    protected final OmemoStore<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess, T_Addr, T_ECPub, T_Bundle, T_Ciph> store;

    public OmemoRatchet(OmemoManager omemoManager, OmemoStore<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess, T_Addr, T_ECPub, T_Bundle, T_Ciph> store) {
        this.omemoManager = omemoManager;
        this.store = store;
    }

    public abstract byte[] doubleRatchetDecrypt(OmemoDevice var1, byte[] var2) throws CorruptedOmemoKeyException, NoRawSessionException, CryptoFailedException, UntrustedOmemoIdentityException, IOException;

    public abstract CiphertextTuple doubleRatchetEncrypt(OmemoDevice var1, byte[] var2);

    CipherAndAuthTag retrieveMessageKeyAndAuthTag(OmemoDevice sender, OmemoElement element) throws CryptoFailedException, NoRawSessionException, IOException {
        int keyId = this.omemoManager.getDeviceId();
        byte[] unpackedKey = null;
        ArrayList<CryptoFailedException> decryptExceptions = new ArrayList<CryptoFailedException>();
        ArrayList<OmemoKeyElement> keys = element.getHeader().getKeys();
        boolean preKey = false;
        for (OmemoKeyElement k : keys) {
            if (k.getId() != keyId) continue;
            try {
                unpackedKey = this.doubleRatchetDecrypt(sender, k.getData());
                preKey = k.isPreKey();
                break;
            }
            catch (CryptoFailedException e) {
                decryptExceptions.add(e);
            }
            catch (CorruptedOmemoKeyException e) {
                decryptExceptions.add(new CryptoFailedException(e));
            }
            catch (UntrustedOmemoIdentityException e) {
                LOGGER.log(Level.WARNING, "Received message from " + sender + " contained unknown identityKey. Ignore message.", e);
            }
        }
        if (unpackedKey == null) {
            if (!decryptExceptions.isEmpty()) {
                throw MultipleCryptoFailedException.from(decryptExceptions);
            }
            throw new CryptoFailedException("Transported key could not be decrypted, since no suitable message key was provided. Provides keys: " + keys);
        }
        byte[] messageKey = new byte[16];
        byte[] authTag = null;
        if (unpackedKey.length == 32) {
            authTag = new byte[16];
            System.arraycopy(unpackedKey, 0, messageKey, 0, 16);
            System.arraycopy(unpackedKey, 16, authTag, 0, 16);
        } else if (element.isKeyTransportElement() && unpackedKey.length == 16) {
            messageKey = unpackedKey;
        } else {
            throw new CryptoFailedException("MessageKey has wrong length: " + unpackedKey.length + ". Probably legacy auth tag format.");
        }
        return new CipherAndAuthTag(messageKey, element.getHeader().getIv(), authTag, preKey);
    }

    static String decryptMessageElement(OmemoElement element, CipherAndAuthTag cipherAndAuthTag) throws CryptoFailedException {
        if (!element.isMessageElement()) {
            throw new IllegalArgumentException("decryptMessageElement cannot decrypt OmemoElement which is no MessageElement!");
        }
        if (cipherAndAuthTag.getAuthTag() == null || cipherAndAuthTag.getAuthTag().length != 16) {
            throw new CryptoFailedException("AuthenticationTag is null or has wrong length: " + (cipherAndAuthTag.getAuthTag() == null ? "null" : Integer.valueOf(cipherAndAuthTag.getAuthTag().length)));
        }
        byte[] encryptedBody = OmemoRatchet.payloadAndAuthTag(element, cipherAndAuthTag.getAuthTag());
        try {
            String plaintext = new String(cipherAndAuthTag.getCipher().doFinal(encryptedBody), StandardCharsets.UTF_8);
            return plaintext;
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new CryptoFailedException("decryptMessageElement could not decipher message body: " + e.getMessage());
        }
    }

    static byte[] payloadAndAuthTag(OmemoElement element, byte[] authTag) {
        if (!element.isMessageElement()) {
            throw new IllegalArgumentException("OmemoElement has no payload.");
        }
        byte[] payload = new byte[element.getPayload().length + authTag.length];
        System.arraycopy(element.getPayload(), 0, payload, 0, element.getPayload().length);
        System.arraycopy(authTag, 0, payload, element.getPayload().length, authTag.length);
        return payload;
    }
}

