/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.omemo;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.jivesoftware.smackx.omemo.exceptions.CannotEstablishOmemoSessionException;
import org.jivesoftware.smackx.omemo.exceptions.CryptoFailedException;
import org.jivesoftware.smackx.omemo.exceptions.MultipleCryptoFailedException;
import org.jivesoftware.smackx.omemo.exceptions.UndecidedOmemoIdentityException;
import org.jivesoftware.smackx.omemo.internal.OmemoDevice;
import org.junit.Assert;
import org.junit.Test;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.stringprep.XmppStringprepException;

public class OmemoExceptionsTest {
    @Test
    public void undecidedOmemoIdentityExceptionTest() throws XmppStringprepException {
        OmemoDevice alice = new OmemoDevice(JidCreate.bareFrom((String)"alice@server.tld"), 1234);
        OmemoDevice bob = new OmemoDevice(JidCreate.bareFrom((String)"bob@server.tld"), 5678);
        OmemoDevice mallory = new OmemoDevice(JidCreate.bareFrom((String)"mallory@server.tld"), 9876);
        UndecidedOmemoIdentityException u = new UndecidedOmemoIdentityException(alice);
        Assert.assertTrue((boolean)u.getUndecidedDevices().contains(alice));
        Assert.assertTrue((u.getUndecidedDevices().size() == 1 ? 1 : 0) != 0);
        UndecidedOmemoIdentityException v = new UndecidedOmemoIdentityException(bob);
        v.getUndecidedDevices().add(mallory);
        Assert.assertTrue((v.getUndecidedDevices().size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)v.getUndecidedDevices().contains(bob));
        Assert.assertTrue((boolean)v.getUndecidedDevices().contains(mallory));
        u.getUndecidedDevices().add(bob);
        u.join(v);
        Assert.assertTrue((u.getUndecidedDevices().size() == 3 ? 1 : 0) != 0);
    }

    @Test
    public void cannotEstablishOmemoSessionExceptionTest() throws XmppStringprepException {
        OmemoDevice alice1 = new OmemoDevice(JidCreate.bareFrom((String)"alice@server.tld"), 1234);
        OmemoDevice alice2 = new OmemoDevice(JidCreate.bareFrom((String)"alice@server.tld"), 2345);
        OmemoDevice bob = new OmemoDevice(JidCreate.bareFrom((String)"bob@server.tld"), 5678);
        CannotEstablishOmemoSessionException c = new CannotEstablishOmemoSessionException(alice1, null);
        Assert.assertEquals((long)1L, (long)c.getFailures().size());
        Assert.assertTrue((boolean)c.getFailures().containsKey(alice1.getJid()));
        c.addSuccess(alice2);
        Assert.assertFalse((boolean)c.requiresThrowing());
        c.addFailures(new CannotEstablishOmemoSessionException(bob, null));
        Assert.assertTrue((boolean)c.requiresThrowing());
        Assert.assertEquals((long)1L, (long)c.getSuccesses().size());
        Assert.assertEquals((long)2L, (long)c.getFailures().size());
        c.getSuccesses().remove(alice2.getJid());
        c.addFailures(new CannotEstablishOmemoSessionException(alice2, null));
        Assert.assertEquals((long)2L, (long)c.getFailures().size());
    }

    @Test
    public void multipleCryptoFailedExceptionTest() {
        CryptoFailedException e1 = new CryptoFailedException("Fail");
        CryptoFailedException e2 = new CryptoFailedException("EpicFail");
        ArrayList<CryptoFailedException> l = new ArrayList<CryptoFailedException>();
        l.add(e1);
        l.add(e2);
        MultipleCryptoFailedException m = MultipleCryptoFailedException.from(l);
        Assert.assertEquals((long)2L, (long)m.getCryptoFailedExceptions().size());
        Assert.assertTrue((boolean)m.getCryptoFailedExceptions().contains(e1));
        Assert.assertTrue((boolean)m.getCryptoFailedExceptions().contains(e2));
        ArrayList el = new ArrayList();
        try {
            MultipleCryptoFailedException m2 = MultipleCryptoFailedException.from(el);
            TestCase.fail((String)("MultipleCryptoFailedException must not allow empty list, but returned: " + m2));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

