/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.omemo.util;

import java.util.Arrays;
import java.util.Random;
import org.jivesoftware.smack.test.util.SmackTestSuite;
import org.jivesoftware.smackx.omemo.util.OmemoMessageBuilder;
import org.junit.Assert;
import org.junit.Test;

public class OmemoMessageBuilderTest
extends SmackTestSuite {
    private static final byte[] messageKey = new byte[16];
    private static final byte[] cipherTextWithAuthTag = new byte[51];

    public OmemoMessageBuilderTest() {
        Random random = new Random();
        random.nextBytes(messageKey);
        random.nextBytes(cipherTextWithAuthTag);
    }

    @Test
    public void testMoveAuthTag() {
        byte[] authTag = new byte[16];
        System.arraycopy(cipherTextWithAuthTag, 35, authTag, 0, 16);
        byte[] messageKeyWithAuthTag = new byte[32];
        byte[] cipherTextWithoutAuthTag = new byte[35];
        OmemoMessageBuilder.moveAuthTag((byte[])messageKey, (byte[])cipherTextWithAuthTag, (byte[])messageKeyWithAuthTag, (byte[])cipherTextWithoutAuthTag);
        byte[] checkCipherText = new byte[35];
        System.arraycopy(cipherTextWithAuthTag, 0, checkCipherText, 0, 35);
        Assert.assertTrue((boolean)Arrays.equals(checkCipherText, cipherTextWithoutAuthTag));
        byte[] checkMessageKey = new byte[16];
        System.arraycopy(messageKeyWithAuthTag, 0, checkMessageKey, 0, 16);
        Assert.assertTrue((boolean)Arrays.equals(checkMessageKey, messageKey));
        byte[] checkAuthTag = new byte[16];
        System.arraycopy(messageKeyWithAuthTag, 16, checkAuthTag, 0, 16);
        Assert.assertTrue((boolean)Arrays.equals(checkAuthTag, authTag));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCheckIllegalMessageKeyWithAuthTagLength() {
        byte[] illegalMessageKey = new byte[31];
        byte[] cipherTextWithoutAuthTag = new byte[35];
        OmemoMessageBuilder.moveAuthTag((byte[])messageKey, (byte[])cipherTextWithAuthTag, (byte[])illegalMessageKey, (byte[])cipherTextWithoutAuthTag);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCheckIllegalCipherTextWithoutAuthTagLength() {
        byte[] messageKeyWithAuthTag = new byte[32];
        byte[] illegalCipherTextWithoutAuthTag = new byte[39];
        OmemoMessageBuilder.moveAuthTag((byte[])messageKey, (byte[])cipherTextWithAuthTag, (byte[])messageKeyWithAuthTag, (byte[])illegalCipherTextWithoutAuthTag);
    }
}

