/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.omemo;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.MessageBuilder;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.XmlElement;
import org.jivesoftware.smack.util.Async;
import org.jivesoftware.smackx.carbons.CarbonManager;
import org.jivesoftware.smackx.carbons.packet.CarbonExtension;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.hints.element.StoreHint;
import org.jivesoftware.smackx.mam.MamManager;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.jivesoftware.smackx.muc.MultiUserChatManager;
import org.jivesoftware.smackx.muc.RoomInfo;
import org.jivesoftware.smackx.omemo.OmemoMessage;
import org.jivesoftware.smackx.omemo.OmemoService;
import org.jivesoftware.smackx.omemo.element.OmemoBundleElement_VAxolotl;
import org.jivesoftware.smackx.omemo.element.OmemoDeviceListElement;
import org.jivesoftware.smackx.omemo.element.OmemoDeviceListElement_VAxolotl;
import org.jivesoftware.smackx.omemo.element.OmemoElement;
import org.jivesoftware.smackx.omemo.exceptions.CannotEstablishOmemoSessionException;
import org.jivesoftware.smackx.omemo.exceptions.CorruptedOmemoKeyException;
import org.jivesoftware.smackx.omemo.exceptions.CryptoFailedException;
import org.jivesoftware.smackx.omemo.exceptions.NoOmemoSupportException;
import org.jivesoftware.smackx.omemo.exceptions.NoRawSessionException;
import org.jivesoftware.smackx.omemo.exceptions.UndecidedOmemoIdentityException;
import org.jivesoftware.smackx.omemo.internal.OmemoCachedDeviceList;
import org.jivesoftware.smackx.omemo.internal.OmemoDevice;
import org.jivesoftware.smackx.omemo.listener.OmemoMessageListener;
import org.jivesoftware.smackx.omemo.listener.OmemoMucMessageListener;
import org.jivesoftware.smackx.omemo.trust.OmemoFingerprint;
import org.jivesoftware.smackx.omemo.trust.OmemoTrustCallback;
import org.jivesoftware.smackx.omemo.trust.TrustState;
import org.jivesoftware.smackx.omemo.util.MessageOrOmemoMessage;
import org.jivesoftware.smackx.omemo.util.OmemoConstants;
import org.jivesoftware.smackx.pep.PepEventListener;
import org.jivesoftware.smackx.pep.PepManager;
import org.jivesoftware.smackx.pubsub.PubSubException;
import org.jivesoftware.smackx.pubsub.PubSubManager;
import org.jxmpp.jid.BareJid;
import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.EntityFullJid;
import org.jxmpp.jid.Jid;

public final class OmemoManager
extends Manager {
    private static final Logger LOGGER = Logger.getLogger(OmemoManager.class.getName());
    private static final Integer UNKNOWN_DEVICE_ID = -1;
    private static final WeakHashMap<XMPPConnection, TreeMap<Integer, OmemoManager>> INSTANCES = new WeakHashMap();
    private final OmemoService<?, ?, ?, ?, ?, ?, ?, ?, ?> service;
    private final HashSet<OmemoMessageListener> omemoMessageListeners = new HashSet();
    private final HashSet<OmemoMucMessageListener> omemoMucMessageListeners = new HashSet();
    private final PepManager pepManager;
    private OmemoTrustCallback trustCallback;
    private BareJid ownJid;
    private Integer deviceId;
    private final PepEventListener<OmemoDeviceListElement> pepOmemoDeviceListEventListener = (from, receivedDeviceList, id, message) -> {
        OmemoCachedDeviceList deviceList;
        try {
            this.getOmemoService().getOmemoStoreBackend().mergeCachedDeviceList(this.getOwnDevice(), (BareJid)from, (OmemoDeviceListElement)receivedDeviceList);
            if (!from.asBareJid().equals((CharSequence)this.getOwnJid())) {
                return;
            }
            deviceList = this.getOmemoService().cleanUpDeviceList(this.getOwnDevice());
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "IOException while processing OMEMO PEP device updates. Message: " + message, e);
            return;
        }
        final OmemoDeviceListElement_VAxolotl newDeviceList = new OmemoDeviceListElement_VAxolotl(deviceList);
        if (!newDeviceList.copyDeviceIds().equals(receivedDeviceList.copyDeviceIds())) {
            LOGGER.log(Level.FINE, "Republish deviceList due to changes: Received: " + Arrays.toString(receivedDeviceList.copyDeviceIds().toArray()) + " Published: " + Arrays.toString(newDeviceList.copyDeviceIds().toArray()));
            Async.go((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        OmemoService.publishDeviceList(OmemoManager.this.connection(), newDeviceList);
                    }
                    catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException.XMPPErrorException | PubSubException.NotALeafNodeException e) {
                        LOGGER.log(Level.WARNING, "Could not publish our deviceList upon an received update.", e);
                    }
                }
            });
        }
    };

    private OmemoManager(XMPPConnection connection, Integer deviceId) {
        super(connection);
        this.service = OmemoService.getInstance();
        this.pepManager = PepManager.getInstanceFor((XMPPConnection)connection);
        this.deviceId = deviceId;
        if (connection.isAuthenticated()) {
            OmemoManager.initBareJidAndDeviceId(this);
        } else {
            connection.addConnectionListener(new ConnectionListener(){

                public void authenticated(XMPPConnection connection, boolean resumed) {
                    OmemoManager.initBareJidAndDeviceId(OmemoManager.this);
                }
            });
        }
        this.service.registerRatchetForManager(this);
        this.resumeStanzaAndPEPListeners();
    }

    public static synchronized OmemoManager getInstanceFor(XMPPConnection connection, Integer deviceId) {
        OmemoManager manager;
        if (deviceId == null || deviceId < 1) {
            throw new IllegalArgumentException("DeviceId MUST NOT be null and MUST be greater than 0.");
        }
        TreeMap<Integer, OmemoManager> managersOfConnection = INSTANCES.get(connection);
        if (managersOfConnection == null) {
            managersOfConnection = new TreeMap();
            INSTANCES.put(connection, managersOfConnection);
        }
        if ((manager = managersOfConnection.get(deviceId)) == null) {
            manager = new OmemoManager(connection, deviceId);
            managersOfConnection.put(deviceId, manager);
        }
        return manager;
    }

    public static synchronized OmemoManager getInstanceFor(XMPPConnection connection) {
        OmemoManager manager;
        TreeMap<Integer, OmemoManager> managers = INSTANCES.get(connection);
        if (managers == null) {
            managers = new TreeMap();
            INSTANCES.put(connection, managers);
        }
        if (managers.size() == 0) {
            manager = new OmemoManager(connection, UNKNOWN_DEVICE_ID);
            managers.put(UNKNOWN_DEVICE_ID, manager);
        } else {
            manager = managers.get(managers.firstKey());
        }
        return manager;
    }

    public void setTrustCallback(OmemoTrustCallback callback) {
        if (this.trustCallback != null) {
            throw new IllegalStateException("TrustCallback can only be set once.");
        }
        this.trustCallback = callback;
    }

    OmemoTrustCallback getTrustCallback() {
        return this.trustCallback;
    }

    public synchronized void initialize() throws SmackException.NotLoggedInException, CorruptedOmemoKeyException, InterruptedException, SmackException.NoResponseException, SmackException.NotConnectedException, XMPPException.XMPPErrorException, PubSubException.NotALeafNodeException, IOException {
        if (!this.connection().isAuthenticated()) {
            throw new SmackException.NotLoggedInException();
        }
        if (this.getTrustCallback() == null) {
            throw new IllegalStateException("No TrustCallback set.");
        }
        this.getOmemoService().init(new LoggedInOmemoManager(this));
    }

    public void initializeAsync(final InitializationFinishedCallback finishedCallback) {
        Async.go((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    OmemoManager.this.initialize();
                    finishedCallback.initializationFinished(OmemoManager.this);
                }
                catch (Exception e) {
                    finishedCallback.initializationFailed(e);
                }
            }
        });
    }

    public Set<OmemoDevice> getDevicesOf(BareJid contact) throws IOException {
        OmemoCachedDeviceList list = this.getOmemoService().getOmemoStoreBackend().loadCachedDeviceList(this.getOwnDevice(), contact);
        HashSet<OmemoDevice> devices = new HashSet<OmemoDevice>();
        for (int deviceId : list.getActiveDevices()) {
            devices.add(new OmemoDevice(contact, deviceId));
        }
        return devices;
    }

    public OmemoMessage.Sent encrypt(BareJid recipient, String message) throws CryptoFailedException, UndecidedOmemoIdentityException, InterruptedException, SmackException.NotConnectedException, SmackException.NoResponseException, SmackException.NotLoggedInException, IOException {
        HashSet<BareJid> recipients = new HashSet<BareJid>();
        recipients.add(recipient);
        return this.encrypt(recipients, message);
    }

    public synchronized OmemoMessage.Sent encrypt(Set<BareJid> recipients, String message) throws CryptoFailedException, UndecidedOmemoIdentityException, InterruptedException, SmackException.NotConnectedException, SmackException.NoResponseException, SmackException.NotLoggedInException, IOException {
        LoggedInOmemoManager guard = new LoggedInOmemoManager(this);
        Set<OmemoDevice> devices = this.getDevicesOf(this.getOwnJid());
        for (BareJid recipient : recipients) {
            devices.addAll(this.getDevicesOf(recipient));
        }
        return this.service.createOmemoMessage(guard, devices, message);
    }

    public synchronized OmemoMessage.Sent encrypt(MultiUserChat muc, String message) throws UndecidedOmemoIdentityException, CryptoFailedException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, SmackException.NoResponseException, NoOmemoSupportException, SmackException.NotLoggedInException, IOException {
        if (!this.multiUserChatSupportsOmemo(muc)) {
            throw new NoOmemoSupportException();
        }
        HashSet<BareJid> recipients = new HashSet<BareJid>();
        for (EntityFullJid e : muc.getOccupants()) {
            recipients.add(muc.getOccupant(e).getJid().asBareJid());
        }
        return this.encrypt(recipients, message);
    }

    public OmemoMessage.Received decrypt(BareJid sender, OmemoElement omemoElement) throws SmackException.NotLoggedInException, CorruptedOmemoKeyException, NoRawSessionException, CryptoFailedException, IOException {
        LoggedInOmemoManager managerGuard = new LoggedInOmemoManager(this);
        return this.getOmemoService().decryptMessage(managerGuard, sender, omemoElement);
    }

    public List<MessageOrOmemoMessage> decryptMamQueryResult(MamManager.MamQuery mamQuery) throws SmackException.NotLoggedInException, IOException {
        return new ArrayList<MessageOrOmemoMessage>(this.getOmemoService().decryptMamQueryResult(new LoggedInOmemoManager(this), mamQuery));
    }

    public void trustOmemoIdentity(OmemoDevice device, OmemoFingerprint fingerprint) {
        if (this.trustCallback == null) {
            throw new IllegalStateException("No TrustCallback set.");
        }
        this.trustCallback.setTrust(device, fingerprint, TrustState.trusted);
    }

    public void distrustOmemoIdentity(OmemoDevice device, OmemoFingerprint fingerprint) {
        if (this.trustCallback == null) {
            throw new IllegalStateException("No TrustCallback set.");
        }
        this.trustCallback.setTrust(device, fingerprint, TrustState.untrusted);
    }

    public boolean isTrustedOmemoIdentity(OmemoDevice device, OmemoFingerprint fingerprint) {
        if (this.trustCallback == null) {
            throw new IllegalStateException("No TrustCallback set.");
        }
        return this.trustCallback.getTrust(device, fingerprint) == TrustState.trusted;
    }

    public boolean isDecidedOmemoIdentity(OmemoDevice device, OmemoFingerprint fingerprint) {
        if (this.trustCallback == null) {
            throw new IllegalStateException("No TrustCallback set.");
        }
        return this.trustCallback.getTrust(device, fingerprint) != TrustState.undecided;
    }

    public synchronized void sendRatchetUpdateMessage(OmemoDevice recipient) throws SmackException.NotLoggedInException, CorruptedOmemoKeyException, InterruptedException, SmackException.NoResponseException, NoSuchAlgorithmException, SmackException.NotConnectedException, CryptoFailedException, CannotEstablishOmemoSessionException, IOException {
        XMPPConnection connection = this.connection();
        MessageBuilder message = (MessageBuilder)connection.getStanzaFactory().buildMessageStanza().to((Jid)recipient.getJid());
        OmemoElement element = this.getOmemoService().createRatchetUpdateElement(new LoggedInOmemoManager(this), recipient);
        message.addExtension((XmlElement)element);
        StoreHint.set((MessageBuilder)message);
        connection.sendStanza((Stanza)message.build());
    }

    public synchronized boolean contactSupportsOmemo(BareJid contact) throws InterruptedException, PubSubException.NotALeafNodeException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, SmackException.NoResponseException, IOException {
        OmemoCachedDeviceList deviceList = this.getOmemoService().refreshDeviceList(this.connection(), this.getOwnDevice(), contact);
        return !deviceList.getActiveDevices().isEmpty();
    }

    public boolean multiUserChatSupportsOmemo(MultiUserChat multiUserChat) throws XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, SmackException.NoResponseException {
        EntityBareJid jid = multiUserChat.getRoom();
        RoomInfo roomInfo = MultiUserChatManager.getInstanceFor((XMPPConnection)this.connection()).getRoomInfo(jid);
        return roomInfo.isNonanonymous() && roomInfo.isMembersOnly();
    }

    public static boolean serverSupportsOmemo(XMPPConnection connection, DomainBareJid server) throws XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, SmackException.NoResponseException {
        return ServiceDiscoveryManager.getInstanceFor((XMPPConnection)connection).discoverInfo((Jid)server).containsFeature((CharSequence)"http://jabber.org/protocol/pubsub");
    }

    public synchronized OmemoFingerprint getOwnFingerprint() throws SmackException.NotLoggedInException, CorruptedOmemoKeyException, IOException {
        if (this.getOwnJid() == null) {
            throw new SmackException.NotLoggedInException();
        }
        return this.getOmemoService().getOmemoStoreBackend().getFingerprint(this.getOwnDevice());
    }

    public synchronized OmemoFingerprint getFingerprint(OmemoDevice device) throws CannotEstablishOmemoSessionException, SmackException.NotLoggedInException, CorruptedOmemoKeyException, SmackException.NotConnectedException, InterruptedException, SmackException.NoResponseException, IOException {
        if (this.getOwnJid() == null) {
            throw new SmackException.NotLoggedInException();
        }
        if (device.equals(this.getOwnDevice())) {
            return this.getOwnFingerprint();
        }
        return this.getOmemoService().getOmemoStoreBackend().getFingerprintAndMaybeBuildSession(new LoggedInOmemoManager(this), device);
    }

    public synchronized Map<OmemoDevice, OmemoFingerprint> getActiveFingerprints(BareJid contact) throws SmackException.NotLoggedInException, CorruptedOmemoKeyException, CannotEstablishOmemoSessionException, SmackException.NotConnectedException, InterruptedException, SmackException.NoResponseException, IOException {
        if (this.getOwnJid() == null) {
            throw new SmackException.NotLoggedInException();
        }
        HashMap<OmemoDevice, OmemoFingerprint> fingerprints = new HashMap<OmemoDevice, OmemoFingerprint>();
        OmemoCachedDeviceList deviceList = this.getOmemoService().getOmemoStoreBackend().loadCachedDeviceList(this.getOwnDevice(), contact);
        for (int id : deviceList.getActiveDevices()) {
            OmemoDevice device = new OmemoDevice(contact, id);
            OmemoFingerprint fingerprint = this.getFingerprint(device);
            if (fingerprint == null) continue;
            fingerprints.put(device, fingerprint);
        }
        return fingerprints;
    }

    public void addOmemoMessageListener(OmemoMessageListener listener) {
        this.omemoMessageListeners.add(listener);
    }

    public void removeOmemoMessageListener(OmemoMessageListener listener) {
        this.omemoMessageListeners.remove(listener);
    }

    public void addOmemoMucMessageListener(OmemoMucMessageListener listener) {
        this.omemoMucMessageListeners.add(listener);
    }

    public void removeOmemoMucMessageListener(OmemoMucMessageListener listener) {
        this.omemoMucMessageListeners.remove(listener);
    }

    public synchronized void requestDeviceListUpdateFor(BareJid contact) throws InterruptedException, PubSubException.NotALeafNodeException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, SmackException.NoResponseException, IOException {
        this.getOmemoService().refreshDeviceList(this.connection(), this.getOwnDevice(), contact);
    }

    public void purgeDeviceList() throws SmackException.NotLoggedInException, InterruptedException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, SmackException.NoResponseException, IOException, PubSubException.NotALeafNodeException {
        this.getOmemoService().purgeDeviceList(new LoggedInOmemoManager(this));
    }

    public List<Exception> purgeEverything() throws SmackException.NotConnectedException, InterruptedException, IOException {
        ArrayList<Exception> exceptions = new ArrayList<Exception>(5);
        PubSubManager pm = PubSubManager.getInstanceFor((XMPPConnection)this.getConnection(), (BareJid)this.getOwnJid());
        try {
            this.requestDeviceListUpdateFor(this.getOwnJid());
        }
        catch (SmackException.NoResponseException | XMPPException.XMPPErrorException | PubSubException.NotALeafNodeException e) {
            exceptions.add((Exception)e);
        }
        OmemoCachedDeviceList deviceList = OmemoService.getInstance().getOmemoStoreBackend().loadCachedDeviceList(this.getOwnDevice(), this.getOwnJid());
        for (int id : deviceList.getAllDevices()) {
            try {
                pm.getLeafNode(OmemoConstants.PEP_NODE_BUNDLE_FROM_DEVICE_ID(id)).deleteAllItems();
            }
            catch (SmackException.NoResponseException | XMPPException.XMPPErrorException | PubSubException.NotALeafNodeException | PubSubException.NotAPubSubNodeException e) {
                exceptions.add((Exception)e);
            }
            try {
                pm.deleteNode(OmemoConstants.PEP_NODE_BUNDLE_FROM_DEVICE_ID(id));
            }
            catch (SmackException.NoResponseException | XMPPException.XMPPErrorException e) {
                exceptions.add((Exception)e);
            }
        }
        try {
            pm.getLeafNode("eu.siacs.conversations.axolotl.devicelist").deleteAllItems();
        }
        catch (SmackException.NoResponseException | XMPPException.XMPPErrorException | PubSubException.NotALeafNodeException | PubSubException.NotAPubSubNodeException e) {
            exceptions.add((Exception)e);
        }
        try {
            pm.deleteNode("eu.siacs.conversations.axolotl.devicelist");
        }
        catch (SmackException.NoResponseException | XMPPException.XMPPErrorException e) {
            exceptions.add((Exception)e);
        }
        return exceptions;
    }

    public synchronized void rotateSignedPreKey() throws CorruptedOmemoKeyException, SmackException.NotLoggedInException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, SmackException.NoResponseException, IOException, PubSubException.NotALeafNodeException {
        if (!this.connection().isAuthenticated()) {
            throw new SmackException.NotLoggedInException();
        }
        this.getOmemoService().getOmemoStoreBackend().changeSignedPreKey(this.getOwnDevice());
        OmemoBundleElement_VAxolotl bundle = this.getOmemoService().getOmemoStoreBackend().packOmemoBundle(this.getOwnDevice());
        OmemoService.publishBundle(this.connection(), this.getOwnDevice(), bundle);
    }

    static boolean stanzaContainsOmemoElement(Stanza stanza) {
        return stanza.hasExtension("encrypted", "eu.siacs.conversations.axolotl");
    }

    private void throwIfNoServiceSet() {
        if (this.service == null) {
            throw new IllegalStateException("No OmemoService set in OmemoManager.");
        }
    }

    public static int randomDeviceId() {
        return new Random().nextInt(0x7FFFFFFE) + 1;
    }

    public BareJid getOwnJid() {
        if (this.ownJid == null && this.connection().isAuthenticated()) {
            this.ownJid = this.connection().getUser().asBareJid();
        }
        return this.ownJid;
    }

    public synchronized Integer getDeviceId() {
        return this.deviceId;
    }

    public synchronized OmemoDevice getOwnDevice() {
        BareJid jid = this.getOwnJid();
        if (jid == null) {
            return null;
        }
        return new OmemoDevice(jid, this.getDeviceId());
    }

    synchronized void setDeviceId(int nDeviceId) {
        INSTANCES.get(this.connection()).remove(this.getDeviceId());
        INSTANCES.get(this.connection()).put(nDeviceId, this);
        this.deviceId = nDeviceId;
    }

    void notifyOmemoMessageReceived(Stanza stanza, OmemoMessage.Received decryptedMessage) {
        for (OmemoMessageListener l : this.omemoMessageListeners) {
            l.onOmemoMessageReceived(stanza, decryptedMessage);
        }
    }

    void notifyOmemoMucMessageReceived(MultiUserChat muc, Stanza stanza, OmemoMessage.Received decryptedMessage) {
        for (OmemoMucMessageListener l : this.omemoMucMessageListeners) {
            l.onOmemoMucMessageReceived(muc, stanza, decryptedMessage);
        }
    }

    void notifyOmemoCarbonCopyReceived(CarbonExtension.Direction direction, Message carbonCopy, Message wrappingMessage, OmemoMessage.Received decryptedCarbonCopy) {
        for (OmemoMessageListener l : this.omemoMessageListeners) {
            l.onOmemoCarbonCopyReceived(direction, carbonCopy, wrappingMessage, decryptedCarbonCopy);
        }
    }

    public void resumeStanzaAndPEPListeners() {
        CarbonManager carbonManager = CarbonManager.getInstanceFor((XMPPConnection)this.connection());
        this.connection().removeAsyncStanzaListener(this::internalOmemoMessageStanzaListener);
        carbonManager.removeCarbonCopyReceivedListener(this::internalOmemoCarbonCopyListener);
        this.pepManager.addPepEventListener("eu.siacs.conversations.axolotl.devicelist", OmemoDeviceListElement.class, this.pepOmemoDeviceListEventListener);
        this.connection().addAsyncStanzaListener(this::internalOmemoMessageStanzaListener, OmemoManager::isOmemoMessage);
        carbonManager.addCarbonCopyReceivedListener(this::internalOmemoCarbonCopyListener);
    }

    public void stopStanzaAndPEPListeners() {
        this.pepManager.removePepEventListener(this.pepOmemoDeviceListEventListener);
        this.connection().removeAsyncStanzaListener(this::internalOmemoMessageStanzaListener);
        CarbonManager.getInstanceFor((XMPPConnection)this.connection()).removeCarbonCopyReceivedListener(this::internalOmemoCarbonCopyListener);
    }

    public void rebuildSessionWith(OmemoDevice contactsDevice) throws InterruptedException, SmackException.NoResponseException, CorruptedOmemoKeyException, SmackException.NotConnectedException, CannotEstablishOmemoSessionException, SmackException.NotLoggedInException {
        if (!this.connection().isAuthenticated()) {
            throw new SmackException.NotLoggedInException();
        }
        this.getOmemoService().buildFreshSessionWithDevice(this.connection(), this.getOwnDevice(), contactsDevice);
    }

    XMPPConnection getConnection() {
        return this.connection();
    }

    OmemoService<?, ?, ?, ?, ?, ?, ?, ?, ?> getOmemoService() {
        this.throwIfNoServiceSet();
        return this.service;
    }

    private void internalOmemoMessageStanzaListener(final Stanza packet) {
        Async.go((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    OmemoManager.this.getOmemoService().onOmemoMessageStanzaReceived(packet, new LoggedInOmemoManager(OmemoManager.this));
                }
                catch (IOException | SmackException.NotLoggedInException e) {
                    LOGGER.log(Level.SEVERE, "Exception while processing OMEMO stanza", e);
                }
            }
        });
    }

    private void internalOmemoCarbonCopyListener(final CarbonExtension.Direction direction, final Message carbonCopy, final Message wrappingMessage) {
        Async.go((Runnable)new Runnable(){

            @Override
            public void run() {
                if (OmemoManager.isOmemoMessage((Stanza)carbonCopy)) {
                    try {
                        OmemoManager.this.getOmemoService().onOmemoCarbonCopyReceived(direction, carbonCopy, wrappingMessage, new LoggedInOmemoManager(OmemoManager.this));
                    }
                    catch (IOException | SmackException.NotLoggedInException e) {
                        LOGGER.log(Level.SEVERE, "Exception while processing OMEMO stanza", e);
                    }
                }
            }
        });
    }

    private static boolean isOmemoMessage(Stanza stanza) {
        return stanza instanceof Message && OmemoManager.stanzaContainsOmemoElement(stanza);
    }

    private static void initBareJidAndDeviceId(OmemoManager manager) {
        if (!manager.getConnection().isAuthenticated()) {
            throw new IllegalStateException("Connection MUST be authenticated.");
        }
        if (manager.ownJid == null) {
            manager.ownJid = manager.getConnection().getUser().asBareJid();
        }
        if (UNKNOWN_DEVICE_ID.equals(manager.deviceId)) {
            SortedSet<Integer> storedDeviceIds = manager.getOmemoService().getOmemoStoreBackend().localDeviceIdsOf(manager.ownJid);
            if (storedDeviceIds.size() > 0) {
                manager.setDeviceId(storedDeviceIds.first());
            } else {
                manager.setDeviceId(OmemoManager.randomDeviceId());
            }
        }
    }

    public static class LoggedInOmemoManager {
        private final OmemoManager manager;

        public LoggedInOmemoManager(OmemoManager manager) throws SmackException.NotLoggedInException {
            if (manager == null) {
                throw new IllegalArgumentException("OmemoManager cannot be null.");
            }
            if (manager.getOwnJid() == null) {
                if (manager.getConnection().isAuthenticated()) {
                    manager.ownJid = manager.getConnection().getUser().asBareJid();
                } else {
                    throw new SmackException.NotLoggedInException();
                }
            }
            this.manager = manager;
        }

        public OmemoManager get() {
            return this.manager;
        }
    }

    public static interface InitializationFinishedCallback {
        public void initializationFinished(OmemoManager var1);

        public void initializationFailed(Exception var1);
    }
}

