/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.omemo;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import junit.framework.TestCase;
import org.jivesoftware.smackx.omemo.FileBasedOmemoStore;
import org.jivesoftware.smackx.omemo.OmemoStore;
import org.jivesoftware.smackx.omemo.exceptions.CorruptedOmemoKeyException;
import org.jivesoftware.smackx.omemo.internal.OmemoCachedDeviceList;
import org.jivesoftware.smackx.omemo.internal.OmemoDevice;
import org.jivesoftware.smackx.omemo.trust.OmemoFingerprint;
import org.junit.AfterClass;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.stringprep.XmppStringprepException;

public abstract class OmemoStoreTest<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess, T_Addr, T_ECPub, T_Bundle, T_Ciph> {
    protected final OmemoStore<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess, T_Addr, T_ECPub, T_Bundle, T_Ciph> store;
    private final OmemoDevice alice;
    private final OmemoDevice bob;
    private static final TemporaryFolder tmp = OmemoStoreTest.initStaticTemp();

    OmemoStoreTest(OmemoStore<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess, T_Addr, T_ECPub, T_Bundle, T_Ciph> store) throws XmppStringprepException {
        this.store = store;
        this.alice = new OmemoDevice(JidCreate.bareFrom((String)"alice@wonderland.lit"), 123);
        this.bob = new OmemoDevice(JidCreate.bareFrom((String)"bob@builder.tv"), 987);
    }

    @Test
    public void keyUtilNotNull() {
        TestCase.assertNotNull((Object)this.store.keyUtil());
    }

    @Test
    public void generateOmemoIdentityKeyPairDoesNotReturnNull() {
        TestCase.assertNotNull((Object)this.store.generateOmemoIdentityKeyPair());
    }

    @Test
    public void identityKeyFromIdentityKeyPairIsNotNull() {
        Object pair = this.store.generateOmemoIdentityKeyPair();
        TestCase.assertNotNull((Object)this.store.keyUtil().identityKeyFromPair(pair));
    }

    @Test
    public void storeLoadRemoveOmemoIdentityKeyPair() throws IOException, CorruptedOmemoKeyException {
        Object before = this.store.generateOmemoIdentityKeyPair();
        TestCase.assertNull((Object)this.store.loadOmemoIdentityKeyPair(this.alice));
        this.store.storeOmemoIdentityKeyPair(this.alice, before);
        Object after = this.store.loadOmemoIdentityKeyPair(this.alice);
        TestCase.assertNotNull((Object)after);
        TestCase.assertEquals((Object)this.store.keyUtil().getFingerprintOfIdentityKeyPair(before), (Object)this.store.keyUtil().getFingerprintOfIdentityKeyPair(after));
        TestCase.assertTrue((boolean)Arrays.equals(this.store.keyUtil().identityKeyPairToBytes(before), this.store.keyUtil().identityKeyPairToBytes(after)));
        TestCase.assertNull((String)"Must return null for non-existing key pairs.", (Object)this.store.loadOmemoIdentityKeyPair(this.bob));
        this.store.removeOmemoIdentityKeyPair(this.alice);
        TestCase.assertNull((Object)this.store.loadOmemoIdentityKeyPair(this.alice));
    }

    @Test
    public void storeLoadRemoveOmemoIdentityKey() throws IOException, CorruptedOmemoKeyException {
        Object keyA1 = this.store.keyUtil().identityKeyFromPair(this.store.generateOmemoIdentityKeyPair());
        Object keyB1 = this.store.keyUtil().identityKeyFromPair(this.store.generateOmemoIdentityKeyPair());
        byte[] bytesA1 = this.store.keyUtil().identityKeyToBytes(keyA1);
        byte[] bytesB = this.store.keyUtil().identityKeyToBytes(keyB1);
        TestCase.assertNotNull((String)"Serialized identityKey cannot be null.", (Object)bytesA1);
        TestCase.assertNotNull((String)"Serialized identityKey cannot be null.", (Object)bytesB);
        TestCase.assertNotSame((String)"Serialized identityKey must be of length > 0.", (Object)0, (Object)bytesA1.length);
        TestCase.assertNotSame((String)"Serialized identityKey must be of length > 0.", (Object)0, (Object)bytesB.length);
        TestCase.assertFalse((String)"Generated IdentityKeys must not be equal (ULTRA unlikely).", (boolean)Arrays.equals(bytesA1, bytesB));
        TestCase.assertNull((String)"Must return null, the store could not have this key by now.", (Object)this.store.loadOmemoIdentityKey(this.alice, this.bob));
        this.store.storeOmemoIdentityKey(this.alice, this.bob, keyA1);
        Object keyA2 = this.store.loadOmemoIdentityKey(this.alice, this.bob);
        TestCase.assertNotNull((Object)keyA2);
        byte[] bytesA2 = this.store.keyUtil().identityKeyToBytes(keyA2);
        TestCase.assertTrue((String)"Serialized loaded key must equal serialized stored one.", (boolean)Arrays.equals(bytesA1, bytesA2));
        TestCase.assertNull((String)"Non-existing keys must be returned as null.", (Object)this.store.loadOmemoIdentityKey(this.bob, this.alice));
        this.store.removeOmemoIdentityKey(this.alice, this.bob);
        TestCase.assertNull((Object)this.store.loadOmemoIdentityKey(this.alice, this.bob));
    }

    @Test
    public void generateOmemoPreKeys() {
        TreeMap keys = this.store.generateOmemoPreKeys(31, 49);
        TestCase.assertNotNull((String)"Generated data structure must not be null.", (Object)keys);
        byte[] lastKey = null;
        for (int i = 31; i <= 79; ++i) {
            TestCase.assertEquals((String)"Key ids must be ascending order, starting at 31.", (Object)i, keys.firstKey());
            TestCase.assertNotNull((String)"Every id must match to a key.", keys.get(keys.firstKey()));
            byte[] bytes = this.store.keyUtil().preKeyToBytes(keys.get(keys.firstKey()));
            TestCase.assertNotNull((String)"Serialized preKey must not be null.", (Object)bytes);
            TestCase.assertNotSame((String)"Serialized preKey must not be of length 0.", (Object)0, (Object)bytes.length);
            if (lastKey != null) {
                TestCase.assertFalse((String)"PreKeys MUST NOT be equal.", (boolean)Arrays.equals(lastKey, bytes));
            }
            lastKey = bytes;
            keys.remove(keys.firstKey());
        }
        TestCase.assertEquals((String)"After deleting 49 keys, there must be no keys left.", (int)0, (int)keys.size());
    }

    @Test
    public void storeLoadRemoveOmemoPreKeys() throws IOException, InterruptedException {
        TreeMap before = this.store.generateOmemoPreKeys(1, 10);
        TestCase.assertEquals((String)"The store must have no prekeys before this test.", (int)0, (int)this.store.loadOmemoPreKeys(this.alice).size());
        this.store.storeOmemoPreKeys(this.alice, (Map)before);
        TreeMap after = this.store.loadOmemoPreKeys(this.alice);
        TestCase.assertNotNull((String)"Loaded preKeys must not be null.", (Object)after);
        TestCase.assertEquals((String)"Loaded preKey count must equal stored count.", (int)before.size(), (int)after.size());
        TestCase.assertNull((String)"Non-existing preKey must be returned as null.", (Object)this.store.loadOmemoPreKey(this.alice, 10000));
        int last = after.size();
        for (int i = 1; i <= last; ++i) {
            Object bKey = before.get(i);
            Object aKey = after.get(i);
            TestCase.assertTrue((String)"Loaded keys must equal stored ones.", (boolean)Arrays.equals(this.store.keyUtil().preKeyToBytes(bKey), this.store.keyUtil().preKeyToBytes(aKey)));
            Object rKey = this.store.loadOmemoPreKey(this.alice, i);
            TestCase.assertNotNull((String)"Randomly accessed preKeys must not be null.", (Object)rKey);
            TestCase.assertTrue((String)"Randomly accessed preKeys must equal the stored ones.", (boolean)Arrays.equals(this.store.keyUtil().preKeyToBytes(aKey), this.store.keyUtil().preKeyToBytes(rKey)));
            this.store.removeOmemoPreKey(this.alice, i);
            TestCase.assertNull((String)"PreKey must be null after deletion.", (Object)this.store.loadOmemoPreKey(this.alice, i));
        }
        TreeMap postDeletion = this.store.loadOmemoPreKeys(this.alice);
        TestCase.assertSame((String)"PreKey count must equal 0 after deletion of all keys.", (Object)0, (Object)postDeletion.size());
    }

    @Test
    public void storeLoadRemoveOmemoSignedPreKeys() throws IOException, CorruptedOmemoKeyException {
        TreeMap before = this.store.loadOmemoSignedPreKeys(this.alice);
        TestCase.assertEquals((String)"At this stage, there must be no signed prekeys in the store.", (int)0, (int)before.size());
        Object idp = this.store.generateOmemoIdentityKeyPair();
        Object spk = this.store.generateOmemoSignedPreKey(idp, 125);
        TestCase.assertNotNull((String)"SignedPreKey must not be null.", (Object)spk);
        TestCase.assertEquals((String)"ID of signedPreKey must match.", (int)125, (int)this.store.keyUtil().signedPreKeyIdFromKey(spk));
        byte[] bytes = this.store.keyUtil().signedPreKeyToBytes(spk);
        TestCase.assertNotNull((String)"Serialized signedPreKey must not be null", (Object)bytes);
        TestCase.assertNotSame((String)"Serialized signedPreKey must not be of length 0.", (Object)0, (Object)bytes.length);
        this.store.storeOmemoSignedPreKey(this.alice, 125, spk);
        TreeMap after = this.store.loadOmemoSignedPreKeys(this.alice);
        TestCase.assertEquals((String)"We must have exactly 1 signedPreKey now.", (int)1, (int)after.size());
        Object spk2 = after.get(after.firstKey());
        TestCase.assertEquals((String)"Id of the stored signedPreKey must match the one we stored.", (int)125, (int)this.store.keyUtil().signedPreKeyIdFromKey(spk2));
        TestCase.assertTrue((String)"Serialization of stored and loaded signed preKey must equal.", (boolean)Arrays.equals(this.store.keyUtil().signedPreKeyToBytes(spk), this.store.keyUtil().signedPreKeyToBytes(spk2)));
        Object rspk = this.store.loadOmemoSignedPreKey(this.alice, 125);
        TestCase.assertTrue((String)"Serialization of stored and randomly accessed signed preKey must equal.", (boolean)Arrays.equals(this.store.keyUtil().signedPreKeyToBytes(spk), this.store.keyUtil().signedPreKeyToBytes(rspk)));
        TestCase.assertNull((String)"Non-existing signedPreKey must be returned as null.", (Object)this.store.loadOmemoSignedPreKey(this.alice, 10000));
        this.store.removeOmemoSignedPreKey(this.alice, 125);
        TestCase.assertNull((String)"Deleted key must be returned as null.", (Object)this.store.loadOmemoSignedPreKey(this.alice, 125));
        TestCase.assertEquals((int)0, (int)this.store.loadOmemoSignedPreKeys(this.alice).size());
    }

    @Test
    public void loadStoreDateOfLastSignedPreKeyRenewal() throws IOException {
        TestCase.assertNull((String)"The date of last signed preKey renewal must be null at this stage.", (Object)this.store.getDateOfLastSignedPreKeyRenewal(this.alice));
        Date before = new Date();
        this.store.setDateOfLastSignedPreKeyRenewal(this.alice, before);
        Date after = this.store.getDateOfLastSignedPreKeyRenewal(this.alice);
        TestCase.assertEquals((String)"Dates must equal.", (Object)after, (Object)before);
    }

    @Test
    public void loadStoreDateOfLastMessageReceived() throws IOException {
        TestCase.assertNull((String)"The date of last message received must be null at this stage.", (Object)this.store.getDateOfLastReceivedMessage(this.alice, this.bob));
        Date before = new Date();
        this.store.setDateOfLastReceivedMessage(this.alice, this.bob, before);
        Date after = this.store.getDateOfLastReceivedMessage(this.alice, this.bob);
        TestCase.assertEquals((String)"Dates must equal.", (Object)after, (Object)before);
    }

    @Test
    public void loadStoreCachedDeviceList() throws IOException {
        Integer[] active = new Integer[]{1, 5, 999, 10};
        Integer[] inactive = new Integer[]{6, 7, 8};
        OmemoCachedDeviceList before = new OmemoCachedDeviceList(new HashSet<Integer>(Arrays.asList(active)), new HashSet<Integer>(Arrays.asList(inactive)));
        TestCase.assertNotNull((String)"Loading a non-existent cached deviceList must return an empty list.", (Object)this.store.loadCachedDeviceList(this.alice, this.bob.getJid()));
        this.store.storeCachedDeviceList(this.alice, this.bob.getJid(), before);
        OmemoCachedDeviceList after = this.store.loadCachedDeviceList(this.alice, this.bob.getJid());
        TestCase.assertTrue((String)"Loaded deviceList must not be empty", (after.getAllDevices().size() != 0 ? 1 : 0) != 0);
        TestCase.assertEquals((String)"Number of entries in active devices must match.", (int)active.length, (int)after.getActiveDevices().size());
        TestCase.assertEquals((String)"Number of entries in inactive devices must match.", (int)inactive.length, (int)after.getInactiveDevices().size());
        TestCase.assertEquals((String)"Number of total entries must match.", (int)(active.length + inactive.length), (int)after.getAllDevices().size());
        for (Integer a : active) {
            TestCase.assertTrue((boolean)after.getActiveDevices().contains(a));
            TestCase.assertTrue((boolean)after.getAllDevices().contains(a));
        }
        for (Integer i : inactive) {
            TestCase.assertTrue((boolean)after.getInactiveDevices().contains(i));
            TestCase.assertTrue((boolean)after.getAllDevices().contains(i));
        }
        this.store.storeCachedDeviceList(this.alice, this.bob.getJid(), new OmemoCachedDeviceList());
        TestCase.assertEquals((String)"DeviceList must be empty after overwriting it with empty list.", (int)0, (int)this.store.loadCachedDeviceList(this.alice, this.bob.getJid()).getAllDevices().size());
    }

    @Test
    public void loadAllRawSessionsReturnsEmptyMapTest() throws IOException {
        Map sessions = this.store.loadAllRawSessionsOf(this.alice, this.bob.getJid());
        TestCase.assertNotNull((Object)sessions);
        TestCase.assertEquals((int)0, (int)sessions.size());
    }

    @Test
    public void loadNonExistentRawSessionReturnsNullTest() throws IOException {
        Object session = this.store.loadRawSession(this.alice, this.bob);
        TestCase.assertNull((Object)session);
    }

    @Test
    public void loadStoreMessageCounterTest() throws IOException {
        TestCase.assertEquals((int)0, (int)this.store.loadOmemoMessageCounter(this.alice, this.bob));
        this.store.storeOmemoMessageCounter(this.alice, this.bob, 20);
        TestCase.assertEquals((int)20, (int)this.store.loadOmemoMessageCounter(this.alice, this.bob));
    }

    @Test
    public void getFingerprint() throws IOException, CorruptedOmemoKeyException {
        TestCase.assertNull((String)"Method must return null for a non-existent fingerprint.", (Object)this.store.getFingerprint(this.alice));
        this.store.storeOmemoIdentityKeyPair(this.alice, this.store.generateOmemoIdentityKeyPair());
        OmemoFingerprint fingerprint = this.store.getFingerprint(this.alice);
        TestCase.assertNotNull((String)"fingerprint must not be null", (Object)fingerprint);
        TestCase.assertEquals((String)"Fingerprint must be of length 64", (int)64, (int)fingerprint.length());
        this.store.removeOmemoIdentityKeyPair(this.alice);
    }

    static TemporaryFolder initStaticTemp() {
        try {
            return new TemporaryFolder(){
                {
                    this.before();
                }
            };
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    @AfterClass
    public static void cleanup() throws Exception {
        FileBasedOmemoStore.deleteDirectory((File)tmp.getRoot());
    }
}

