/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.omemo;

import java.security.NoSuchAlgorithmException;
import junit.framework.TestCase;
import org.jivesoftware.smack.test.util.SmackTestSuite;
import org.jivesoftware.smackx.omemo.exceptions.CryptoFailedException;
import org.jivesoftware.smackx.omemo.internal.CipherAndAuthTag;
import org.jivesoftware.smackx.omemo.internal.CiphertextTuple;
import org.jivesoftware.smackx.omemo.util.OmemoMessageBuilder;
import org.junit.Assert;
import org.junit.Test;

public class WrapperObjectsTest
extends SmackTestSuite {
    @Test
    public void ciphertextTupleTest() {
        byte[] c = OmemoMessageBuilder.generateIv();
        CiphertextTuple c1 = new CiphertextTuple(c, 1);
        TestCase.assertTrue((boolean)c1.isPreKeyMessage());
        Assert.assertArrayEquals((byte[])c, (byte[])c1.getCiphertext());
        TestCase.assertEquals((int)1, (int)c1.getMessageType());
        CiphertextTuple c2 = new CiphertextTuple(c, 0);
        Assert.assertFalse((boolean)c2.isPreKeyMessage());
        TestCase.assertEquals((int)0, (int)c2.getMessageType());
    }

    @Test
    public void cipherAndAuthTagTest() throws NoSuchAlgorithmException, CryptoFailedException {
        byte[] key = OmemoMessageBuilder.generateKey((String)"AES", (int)128);
        byte[] iv = OmemoMessageBuilder.generateIv();
        byte[] authTag = OmemoMessageBuilder.generateIv();
        CipherAndAuthTag cat = new CipherAndAuthTag(key, iv, authTag, true);
        Assert.assertArrayEquals((byte[])key, (byte[])cat.getKey());
        Assert.assertArrayEquals((byte[])iv, (byte[])cat.getIv());
        Assert.assertArrayEquals((byte[])authTag, (byte[])cat.getAuthTag());
        TestCase.assertTrue((boolean)cat.wasPreKeyEncrypted());
    }
}

