/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.omemo.element;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.NamedElement;
import org.jivesoftware.smack.packet.XmlElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smackx.omemo.internal.OmemoCachedDeviceList;

public abstract class OmemoDeviceListElement
implements ExtensionElement {
    public static final String DEVICE = "device";
    public static final String ID = "id";
    public static final String LIST = "list";
    private final Set<Integer> deviceIds;

    public OmemoDeviceListElement(Set<Integer> deviceIds) {
        deviceIds = (Set)Objects.requireNonNull(deviceIds);
        this.deviceIds = Collections.unmodifiableSet(deviceIds);
    }

    public OmemoDeviceListElement(OmemoCachedDeviceList cachedList) {
        this.deviceIds = Collections.unmodifiableSet(cachedList.getActiveDevices());
    }

    public Set<Integer> getDeviceIds() {
        return this.deviceIds;
    }

    public Set<Integer> copyDeviceIds() {
        return new HashSet<Integer>(this.deviceIds);
    }

    public String getElementName() {
        return LIST;
    }

    public final XmlStringBuilder toXML(XmlEnvironment enclosingNamespace) {
        XmlStringBuilder sb = new XmlStringBuilder((XmlElement)this).rightAngleBracket();
        for (Integer id : this.deviceIds) {
            sb.halfOpenElement(DEVICE).attribute(ID, id.intValue()).closeEmptyElement();
        }
        sb.closeElement((NamedElement)this);
        return sb;
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder("OmemoDeviceListElement[");
        Iterator<Integer> iterator = this.deviceIds.iterator();
        for (int i : this.deviceIds) {
            sb.append(i);
            if (!iterator.hasNext()) continue;
            sb.append(',');
        }
        return sb.append(']').toString();
    }
}

