/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.omemo;

import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.jivesoftware.smackx.omemo.OmemoStore;
import org.jivesoftware.smackx.omemo.exceptions.CorruptedOmemoKeyException;
import org.jivesoftware.smackx.omemo.internal.OmemoCachedDeviceList;
import org.jivesoftware.smackx.omemo.internal.OmemoDevice;
import org.jivesoftware.smackx.omemo.util.OmemoKeyUtil;
import org.jxmpp.jid.BareJid;

public class CachingOmemoStore<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess, T_Addr, T_ECPub, T_Bundle, T_Ciph>
extends OmemoStore<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess, T_Addr, T_ECPub, T_Bundle, T_Ciph> {
    private final HashMap<OmemoDevice, KeyCache<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess>> caches = new HashMap();
    private final OmemoStore<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess, T_Addr, T_ECPub, T_Bundle, T_Ciph> persistent;
    private final OmemoKeyUtil<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess, T_ECPub, T_Bundle> keyUtil;

    public CachingOmemoStore(OmemoKeyUtil<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess, T_ECPub, T_Bundle> keyUtil) {
        if (keyUtil == null) {
            throw new IllegalArgumentException("KeyUtil MUST NOT be null!");
        }
        this.keyUtil = keyUtil;
        this.persistent = null;
    }

    public CachingOmemoStore(OmemoStore<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess, T_Addr, T_ECPub, T_Bundle, T_Ciph> wrappedStore) {
        if (wrappedStore == null) {
            throw new NullPointerException("Wrapped OmemoStore MUST NOT be null!");
        }
        this.keyUtil = null;
        this.persistent = wrappedStore;
    }

    @Override
    public SortedSet<Integer> localDeviceIdsOf(BareJid localUser) {
        if (this.persistent != null) {
            return this.persistent.localDeviceIdsOf(localUser);
        }
        TreeSet<Integer> deviceIds = new TreeSet<Integer>();
        for (OmemoDevice device : this.caches.keySet()) {
            if (!device.getJid().equals((CharSequence)localUser)) continue;
            deviceIds.add(device.getDeviceId());
        }
        return deviceIds;
    }

    @Override
    public T_IdKeyPair loadOmemoIdentityKeyPair(OmemoDevice userDevice) throws CorruptedOmemoKeyException, IOException {
        Object pair = this.getCache((OmemoDevice)userDevice).identityKeyPair;
        if (pair == null && this.persistent != null && (pair = this.persistent.loadOmemoIdentityKeyPair(userDevice)) != null) {
            this.getCache((OmemoDevice)userDevice).identityKeyPair = pair;
        }
        return pair;
    }

    @Override
    public void storeOmemoIdentityKeyPair(OmemoDevice userDevice, T_IdKeyPair identityKeyPair) throws IOException {
        this.getCache((OmemoDevice)userDevice).identityKeyPair = identityKeyPair;
        if (this.persistent != null) {
            this.persistent.storeOmemoIdentityKeyPair(userDevice, identityKeyPair);
        }
    }

    @Override
    public void removeOmemoIdentityKeyPair(OmemoDevice userDevice) {
        this.getCache((OmemoDevice)userDevice).identityKeyPair = null;
        if (this.persistent != null) {
            this.persistent.removeOmemoIdentityKeyPair(userDevice);
        }
    }

    @Override
    public T_IdKey loadOmemoIdentityKey(OmemoDevice userDevice, OmemoDevice contactsDevice) throws CorruptedOmemoKeyException, IOException {
        Object idKey = this.getCache((OmemoDevice)userDevice).identityKeys.get(contactsDevice);
        if (idKey == null && this.persistent != null && (idKey = this.persistent.loadOmemoIdentityKey(userDevice, contactsDevice)) != null) {
            this.getCache((OmemoDevice)userDevice).identityKeys.put(contactsDevice, idKey);
        }
        return idKey;
    }

    @Override
    public void storeOmemoIdentityKey(OmemoDevice userDevice, OmemoDevice device, T_IdKey t_idKey) throws IOException {
        this.getCache((OmemoDevice)userDevice).identityKeys.put(device, t_idKey);
        if (this.persistent != null) {
            this.persistent.storeOmemoIdentityKey(userDevice, device, t_idKey);
        }
    }

    @Override
    public void removeOmemoIdentityKey(OmemoDevice userDevice, OmemoDevice contactsDevice) {
        this.getCache((OmemoDevice)userDevice).identityKeys.remove(contactsDevice);
        if (this.persistent != null) {
            this.persistent.removeOmemoIdentityKey(userDevice, contactsDevice);
        }
    }

    @Override
    public void storeOmemoMessageCounter(OmemoDevice userDevice, OmemoDevice contactsDevice, int counter) throws IOException {
        this.getCache((OmemoDevice)userDevice).messageCounters.put(contactsDevice, counter);
        if (this.persistent != null) {
            this.persistent.storeOmemoMessageCounter(userDevice, contactsDevice, counter);
        }
    }

    @Override
    public int loadOmemoMessageCounter(OmemoDevice userDevice, OmemoDevice contactsDevice) throws IOException {
        Integer counter = this.getCache((OmemoDevice)userDevice).messageCounters.get(contactsDevice);
        if (counter == null && this.persistent != null) {
            counter = this.persistent.loadOmemoMessageCounter(userDevice, contactsDevice);
        }
        if (counter == null) {
            counter = 0;
        }
        this.getCache((OmemoDevice)userDevice).messageCounters.put(contactsDevice, counter);
        return counter;
    }

    @Override
    public void setDateOfLastReceivedMessage(OmemoDevice userDevice, OmemoDevice from, Date date) throws IOException {
        this.getCache((OmemoDevice)userDevice).lastMessagesDates.put(from, date);
        if (this.persistent != null) {
            this.persistent.setDateOfLastReceivedMessage(userDevice, from, date);
        }
    }

    @Override
    public Date getDateOfLastReceivedMessage(OmemoDevice userDevice, OmemoDevice from) throws IOException {
        Date last = this.getCache((OmemoDevice)userDevice).lastMessagesDates.get(from);
        if (last == null && this.persistent != null && (last = this.persistent.getDateOfLastReceivedMessage(userDevice, from)) != null) {
            this.getCache((OmemoDevice)userDevice).lastMessagesDates.put(from, last);
        }
        return last;
    }

    @Override
    public void setDateOfLastDeviceIdPublication(OmemoDevice userDevice, OmemoDevice contactsDevice, Date date) throws IOException {
        this.getCache((OmemoDevice)userDevice).lastDeviceIdPublicationDates.put(contactsDevice, date);
        if (this.persistent != null) {
            this.persistent.setDateOfLastReceivedMessage(userDevice, contactsDevice, date);
        }
    }

    @Override
    public Date getDateOfLastDeviceIdPublication(OmemoDevice userDevice, OmemoDevice contactsDevice) throws IOException {
        Date last = this.getCache((OmemoDevice)userDevice).lastDeviceIdPublicationDates.get(contactsDevice);
        if (last == null && this.persistent != null && (last = this.persistent.getDateOfLastDeviceIdPublication(userDevice, contactsDevice)) != null) {
            this.getCache((OmemoDevice)userDevice).lastDeviceIdPublicationDates.put(contactsDevice, last);
        }
        return last;
    }

    @Override
    public void setDateOfLastSignedPreKeyRenewal(OmemoDevice userDevice, Date date) throws IOException {
        this.getCache((OmemoDevice)userDevice).lastRenewalDate = date;
        if (this.persistent != null) {
            this.persistent.setDateOfLastSignedPreKeyRenewal(userDevice, date);
        }
    }

    @Override
    public Date getDateOfLastSignedPreKeyRenewal(OmemoDevice userDevice) throws IOException {
        Date lastRenewal = this.getCache((OmemoDevice)userDevice).lastRenewalDate;
        if (lastRenewal == null && this.persistent != null && (lastRenewal = this.persistent.getDateOfLastSignedPreKeyRenewal(userDevice)) != null) {
            this.getCache((OmemoDevice)userDevice).lastRenewalDate = lastRenewal;
        }
        return lastRenewal;
    }

    @Override
    public T_PreKey loadOmemoPreKey(OmemoDevice userDevice, int preKeyId) throws IOException {
        Object preKey = this.getCache((OmemoDevice)userDevice).preKeys.get(preKeyId);
        if (preKey == null && this.persistent != null && (preKey = this.persistent.loadOmemoPreKey(userDevice, preKeyId)) != null) {
            this.getCache((OmemoDevice)userDevice).preKeys.put(preKeyId, preKey);
        }
        return preKey;
    }

    @Override
    public void storeOmemoPreKey(OmemoDevice userDevice, int preKeyId, T_PreKey t_preKey) throws IOException {
        this.getCache((OmemoDevice)userDevice).preKeys.put(preKeyId, t_preKey);
        if (this.persistent != null) {
            this.persistent.storeOmemoPreKey(userDevice, preKeyId, t_preKey);
        }
    }

    @Override
    public void removeOmemoPreKey(OmemoDevice userDevice, int preKeyId) {
        this.getCache((OmemoDevice)userDevice).preKeys.remove(preKeyId);
        if (this.persistent != null) {
            this.persistent.removeOmemoPreKey(userDevice, preKeyId);
        }
    }

    @Override
    public TreeMap<Integer, T_PreKey> loadOmemoPreKeys(OmemoDevice userDevice) throws IOException {
        TreeMap preKeys = this.getCache((OmemoDevice)userDevice).preKeys;
        if (preKeys.isEmpty() && this.persistent != null) {
            preKeys.putAll(this.persistent.loadOmemoPreKeys(userDevice));
        }
        return new TreeMap(preKeys);
    }

    @Override
    public T_SigPreKey loadOmemoSignedPreKey(OmemoDevice userDevice, int signedPreKeyId) throws IOException {
        Object sigPreKey = this.getCache((OmemoDevice)userDevice).signedPreKeys.get(signedPreKeyId);
        if (sigPreKey == null && this.persistent != null && (sigPreKey = this.persistent.loadOmemoSignedPreKey(userDevice, signedPreKeyId)) != null) {
            this.getCache((OmemoDevice)userDevice).signedPreKeys.put(signedPreKeyId, sigPreKey);
        }
        return sigPreKey;
    }

    @Override
    public TreeMap<Integer, T_SigPreKey> loadOmemoSignedPreKeys(OmemoDevice userDevice) throws IOException {
        TreeMap sigPreKeys = this.getCache((OmemoDevice)userDevice).signedPreKeys;
        if (sigPreKeys.isEmpty() && this.persistent != null) {
            sigPreKeys.putAll(this.persistent.loadOmemoSignedPreKeys(userDevice));
        }
        return new TreeMap(sigPreKeys);
    }

    @Override
    public void storeOmemoSignedPreKey(OmemoDevice userDevice, int signedPreKeyId, T_SigPreKey signedPreKey) throws IOException {
        this.getCache((OmemoDevice)userDevice).signedPreKeys.put(signedPreKeyId, signedPreKey);
        if (this.persistent != null) {
            this.persistent.storeOmemoSignedPreKey(userDevice, signedPreKeyId, signedPreKey);
        }
    }

    @Override
    public void removeOmemoSignedPreKey(OmemoDevice userDevice, int signedPreKeyId) {
        this.getCache((OmemoDevice)userDevice).signedPreKeys.remove(signedPreKeyId);
        if (this.persistent != null) {
            this.persistent.removeOmemoSignedPreKey(userDevice, signedPreKeyId);
        }
    }

    @Override
    public T_Sess loadRawSession(OmemoDevice userDevice, OmemoDevice contactsDevice) throws IOException {
        Object session;
        HashMap<Integer, Object> contactSessions = this.getCache((OmemoDevice)userDevice).sessions.get(contactsDevice.getJid());
        if (contactSessions == null) {
            contactSessions = new HashMap();
            this.getCache((OmemoDevice)userDevice).sessions.put(contactsDevice.getJid(), contactSessions);
        }
        if ((session = contactSessions.get(contactsDevice.getDeviceId())) == null && this.persistent != null && (session = this.persistent.loadRawSession(userDevice, contactsDevice)) != null) {
            contactSessions.put(contactsDevice.getDeviceId(), session);
        }
        return session;
    }

    @Override
    public Map<Integer, T_Sess> loadAllRawSessionsOf(OmemoDevice userDevice, BareJid contact) throws IOException {
        HashMap<Integer, Object> sessions = this.getCache((OmemoDevice)userDevice).sessions.get(contact);
        if (sessions == null) {
            sessions = new HashMap();
            this.getCache((OmemoDevice)userDevice).sessions.put(contact, sessions);
        }
        if (sessions.isEmpty() && this.persistent != null) {
            sessions.putAll(this.persistent.loadAllRawSessionsOf(userDevice, contact));
        }
        return new HashMap(sessions);
    }

    @Override
    public void storeRawSession(OmemoDevice userDevice, OmemoDevice contactsDevicece, T_Sess session) throws IOException {
        HashMap<Integer, Object> sessions = this.getCache((OmemoDevice)userDevice).sessions.get(contactsDevicece.getJid());
        if (sessions == null) {
            sessions = new HashMap();
            this.getCache((OmemoDevice)userDevice).sessions.put(contactsDevicece.getJid(), sessions);
        }
        sessions.put(contactsDevicece.getDeviceId(), session);
        if (this.persistent != null) {
            this.persistent.storeRawSession(userDevice, contactsDevicece, session);
        }
    }

    @Override
    public void removeRawSession(OmemoDevice userDevice, OmemoDevice contactsDevice) {
        HashMap sessions = this.getCache((OmemoDevice)userDevice).sessions.get(contactsDevice.getJid());
        if (sessions != null) {
            sessions.remove(contactsDevice.getDeviceId());
        }
        if (this.persistent != null) {
            this.persistent.removeRawSession(userDevice, contactsDevice);
        }
    }

    @Override
    public void removeAllRawSessionsOf(OmemoDevice userDevice, BareJid contact) {
        this.getCache((OmemoDevice)userDevice).sessions.remove(contact);
        if (this.persistent != null) {
            this.persistent.removeAllRawSessionsOf(userDevice, contact);
        }
    }

    @Override
    public boolean containsRawSession(OmemoDevice userDevice, OmemoDevice contactsDevice) {
        HashMap sessions = this.getCache((OmemoDevice)userDevice).sessions.get(contactsDevice.getJid());
        return sessions != null && sessions.get(contactsDevice.getDeviceId()) != null || this.persistent != null && this.persistent.containsRawSession(userDevice, contactsDevice);
    }

    @Override
    public OmemoCachedDeviceList loadCachedDeviceList(OmemoDevice userDevice, BareJid contact) throws IOException {
        OmemoCachedDeviceList list = this.getCache((OmemoDevice)userDevice).deviceLists.get(contact);
        if (list == null && this.persistent != null && (list = this.persistent.loadCachedDeviceList(userDevice, contact)) != null) {
            this.getCache((OmemoDevice)userDevice).deviceLists.put(contact, list);
        }
        return list == null ? new OmemoCachedDeviceList() : new OmemoCachedDeviceList(list);
    }

    @Override
    public void storeCachedDeviceList(OmemoDevice userDevice, BareJid contact, OmemoCachedDeviceList deviceList) throws IOException {
        this.getCache((OmemoDevice)userDevice).deviceLists.put(contact, new OmemoCachedDeviceList(deviceList));
        if (this.persistent != null) {
            this.persistent.storeCachedDeviceList(userDevice, contact, deviceList);
        }
    }

    @Override
    public void purgeOwnDeviceKeys(OmemoDevice userDevice) {
        this.caches.remove(userDevice);
        if (this.persistent != null) {
            this.persistent.purgeOwnDeviceKeys(userDevice);
        }
    }

    @Override
    public OmemoKeyUtil<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess, T_ECPub, T_Bundle> keyUtil() {
        if (this.persistent != null) {
            return this.persistent.keyUtil();
        }
        return this.keyUtil;
    }

    private KeyCache<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess> getCache(OmemoDevice device) {
        KeyCache<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess> cache = this.caches.get(device);
        if (cache == null) {
            cache = new KeyCache();
            this.caches.put(device, cache);
        }
        return cache;
    }

    private static final class KeyCache<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess> {
        private T_IdKeyPair identityKeyPair;
        private final TreeMap<Integer, T_PreKey> preKeys = new TreeMap();
        private final TreeMap<Integer, T_SigPreKey> signedPreKeys = new TreeMap();
        private final HashMap<BareJid, HashMap<Integer, T_Sess>> sessions = new HashMap();
        private final HashMap<OmemoDevice, T_IdKey> identityKeys = new HashMap();
        private final HashMap<OmemoDevice, Date> lastMessagesDates = new HashMap();
        private final HashMap<OmemoDevice, Date> lastDeviceIdPublicationDates = new HashMap();
        private final HashMap<BareJid, OmemoCachedDeviceList> deviceLists = new HashMap();
        private Date lastRenewalDate = null;
        private final HashMap<OmemoDevice, Integer> messageCounters = new HashMap();

        private KeyCache() {
        }
    }
}

