/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.omemo.element;

import java.util.HashMap;
import java.util.Map;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.NamedElement;
import org.jivesoftware.smack.packet.XmlElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smack.util.stringencoder.Base64;

public abstract class OmemoBundleElement
implements ExtensionElement {
    public static final String BUNDLE = "bundle";
    public static final String SIGNED_PRE_KEY_PUB = "signedPreKeyPublic";
    public static final String SIGNED_PRE_KEY_ID = "signedPreKeyId";
    public static final String SIGNED_PRE_KEY_SIG = "signedPreKeySignature";
    public static final String IDENTITY_KEY = "identityKey";
    public static final String PRE_KEYS = "prekeys";
    public static final String PRE_KEY_PUB = "preKeyPublic";
    public static final String PRE_KEY_ID = "preKeyId";
    private final int signedPreKeyId;
    private final String signedPreKeyB64;
    private byte[] signedPreKey;
    private final String signedPreKeySignatureB64;
    private byte[] signedPreKeySignature;
    private final String identityKeyB64;
    private byte[] identityKey;
    private final Map<Integer, String> preKeysB64;
    private Map<Integer, byte[]> preKeys;

    public OmemoBundleElement(int signedPreKeyId, String signedPreKeyB64, String signedPreKeySigB64, String identityKeyB64, Map<Integer, String> preKeysB64) {
        if (signedPreKeyId < 0) {
            throw new IllegalArgumentException("signedPreKeyId MUST be greater than or equal to 0.");
        }
        this.signedPreKeyId = signedPreKeyId;
        this.signedPreKeyB64 = (String)StringUtils.requireNotNullNorEmpty((CharSequence)signedPreKeyB64, (String)"signedPreKeyB64 MUST NOT be null nor empty.");
        this.signedPreKeySignatureB64 = (String)StringUtils.requireNotNullNorEmpty((CharSequence)signedPreKeySigB64, (String)"signedPreKeySigB64 MUST NOT be null nor empty.");
        this.identityKeyB64 = (String)StringUtils.requireNotNullNorEmpty((CharSequence)identityKeyB64, (String)"identityKeyB64 MUST NOT be null nor empty.");
        if (preKeysB64 == null || preKeysB64.isEmpty()) {
            throw new IllegalArgumentException("PreKeys MUST NOT be null nor empty.");
        }
        this.preKeysB64 = preKeysB64;
    }

    public OmemoBundleElement(int signedPreKeyId, byte[] signedPreKey, byte[] signedPreKeySig, byte[] identityKey, Map<Integer, byte[]> preKeys) {
        this(signedPreKeyId, signedPreKey != null ? Base64.encodeToString((byte[])signedPreKey) : null, signedPreKeySig != null ? Base64.encodeToString((byte[])signedPreKeySig) : null, identityKey != null ? Base64.encodeToString((byte[])identityKey) : null, OmemoBundleElement.base64EncodePreKeys(preKeys));
        this.signedPreKey = signedPreKey;
        this.signedPreKeySignature = signedPreKeySig;
        this.identityKey = identityKey;
        this.preKeys = preKeys;
    }

    private static Map<Integer, String> base64EncodePreKeys(Map<Integer, byte[]> preKeys) {
        if (preKeys == null) {
            return null;
        }
        HashMap<Integer, String> converted = new HashMap<Integer, String>();
        for (Integer id : preKeys.keySet()) {
            converted.put(id, Base64.encodeToString((byte[])preKeys.get(id)));
        }
        return converted;
    }

    public byte[] getSignedPreKey() {
        if (this.signedPreKey == null) {
            this.signedPreKey = Base64.decode((String)this.signedPreKeyB64);
        }
        return (byte[])this.signedPreKey.clone();
    }

    public int getSignedPreKeyId() {
        return this.signedPreKeyId;
    }

    public byte[] getSignedPreKeySignature() {
        if (this.signedPreKeySignature == null) {
            this.signedPreKeySignature = Base64.decode((String)this.signedPreKeySignatureB64);
        }
        return (byte[])this.signedPreKeySignature.clone();
    }

    public byte[] getIdentityKey() {
        if (this.identityKey == null) {
            this.identityKey = Base64.decode((String)this.identityKeyB64);
        }
        return (byte[])this.identityKey.clone();
    }

    public Map<Integer, byte[]> getPreKeys() {
        if (this.preKeys == null) {
            this.preKeys = new HashMap<Integer, byte[]>();
            for (int id : this.preKeysB64.keySet()) {
                this.preKeys.put(id, Base64.decode((String)this.preKeysB64.get(id)));
            }
        }
        return this.preKeys;
    }

    public byte[] getPreKey(int id) {
        return this.getPreKeys().get(id);
    }

    public String getElementName() {
        return BUNDLE;
    }

    public XmlStringBuilder toXML(XmlEnvironment enclosingNamespace) {
        XmlStringBuilder sb = new XmlStringBuilder((XmlElement)this, enclosingNamespace).rightAngleBracket();
        sb.halfOpenElement(SIGNED_PRE_KEY_PUB).attribute(SIGNED_PRE_KEY_ID, this.signedPreKeyId).rightAngleBracket().append((CharSequence)this.signedPreKeyB64).closeElement(SIGNED_PRE_KEY_PUB);
        sb.openElement(SIGNED_PRE_KEY_SIG).append((CharSequence)this.signedPreKeySignatureB64).closeElement(SIGNED_PRE_KEY_SIG);
        sb.openElement(IDENTITY_KEY).append((CharSequence)this.identityKeyB64).closeElement(IDENTITY_KEY);
        sb.openElement(PRE_KEYS);
        for (Map.Entry<Integer, String> p : this.preKeysB64.entrySet()) {
            sb.halfOpenElement(PRE_KEY_PUB).attribute(PRE_KEY_ID, p.getKey().intValue()).rightAngleBracket().append((CharSequence)p.getValue()).closeElement(PRE_KEY_PUB);
        }
        sb.closeElement(PRE_KEYS);
        sb.closeElement((NamedElement)this);
        return sb;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("OmemoBundleElement[\n");
        sb.append(SIGNED_PRE_KEY_PUB).append(' ').append(SIGNED_PRE_KEY_ID).append('=').append(this.signedPreKeyId).append(':').append(this.signedPreKeyB64).append('\n').append(SIGNED_PRE_KEY_SIG).append(": ").append(this.signedPreKeySignatureB64).append('\n').append(IDENTITY_KEY).append(": ").append(this.identityKeyB64).append('\n').append(PRE_KEYS).append(" (").append(this.preKeysB64.size()).append(")\n");
        for (Map.Entry<Integer, String> e : this.preKeysB64.entrySet()) {
            sb.append(PRE_KEY_PUB).append(' ').append(PRE_KEY_ID).append('=').append(e.getKey()).append(": ").append(e.getValue()).append('\n');
        }
        sb.append(']');
        return sb.toString();
    }

    public boolean equals(Object other) {
        if (!(other instanceof OmemoBundleElement)) {
            return false;
        }
        OmemoBundleElement otherOmemoBundleElement = (OmemoBundleElement)other;
        return this.toXML().toString().equals(otherOmemoBundleElement.toXML().toString());
    }

    public int hashCode() {
        return this.toXML().toString().hashCode();
    }
}

