/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.omemo;

import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.MessageBuilder;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smack.packet.XmlElement;
import org.jivesoftware.smackx.carbons.packet.CarbonExtension;
import org.jivesoftware.smackx.mam.MamManager;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.jivesoftware.smackx.muc.MultiUserChatManager;
import org.jivesoftware.smackx.muc.Occupant;
import org.jivesoftware.smackx.omemo.OmemoConfiguration;
import org.jivesoftware.smackx.omemo.OmemoManager;
import org.jivesoftware.smackx.omemo.OmemoMessage;
import org.jivesoftware.smackx.omemo.OmemoRatchet;
import org.jivesoftware.smackx.omemo.OmemoStore;
import org.jivesoftware.smackx.omemo.element.OmemoBundleElement;
import org.jivesoftware.smackx.omemo.element.OmemoBundleElement_VAxolotl;
import org.jivesoftware.smackx.omemo.element.OmemoDeviceListElement;
import org.jivesoftware.smackx.omemo.element.OmemoDeviceListElement_VAxolotl;
import org.jivesoftware.smackx.omemo.element.OmemoElement;
import org.jivesoftware.smackx.omemo.exceptions.CannotEstablishOmemoSessionException;
import org.jivesoftware.smackx.omemo.exceptions.CorruptedOmemoKeyException;
import org.jivesoftware.smackx.omemo.exceptions.CryptoFailedException;
import org.jivesoftware.smackx.omemo.exceptions.NoIdentityKeyException;
import org.jivesoftware.smackx.omemo.exceptions.NoRawSessionException;
import org.jivesoftware.smackx.omemo.exceptions.ReadOnlyDeviceException;
import org.jivesoftware.smackx.omemo.exceptions.UndecidedOmemoIdentityException;
import org.jivesoftware.smackx.omemo.exceptions.UntrustedOmemoIdentityException;
import org.jivesoftware.smackx.omemo.internal.CipherAndAuthTag;
import org.jivesoftware.smackx.omemo.internal.OmemoCachedDeviceList;
import org.jivesoftware.smackx.omemo.internal.OmemoDevice;
import org.jivesoftware.smackx.omemo.internal.listener.OmemoCarbonCopyStanzaReceivedListener;
import org.jivesoftware.smackx.omemo.internal.listener.OmemoMessageStanzaReceivedListener;
import org.jivesoftware.smackx.omemo.trust.OmemoFingerprint;
import org.jivesoftware.smackx.omemo.trust.OmemoTrustCallback;
import org.jivesoftware.smackx.omemo.trust.TrustState;
import org.jivesoftware.smackx.omemo.util.MessageOrOmemoMessage;
import org.jivesoftware.smackx.omemo.util.OmemoMessageBuilder;
import org.jivesoftware.smackx.pep.PepManager;
import org.jivesoftware.smackx.pubsub.Item;
import org.jivesoftware.smackx.pubsub.LeafNode;
import org.jivesoftware.smackx.pubsub.PayloadItem;
import org.jivesoftware.smackx.pubsub.PubSubException;
import org.jivesoftware.smackx.pubsub.PubSubManager;
import org.jxmpp.jid.BareJid;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.Jid;

public abstract class OmemoService<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess, T_Addr, T_ECPub, T_Bundle, T_Ciph>
implements OmemoCarbonCopyStanzaReceivedListener,
OmemoMessageStanzaReceivedListener {
    protected static final Logger LOGGER = Logger.getLogger(OmemoService.class.getName());
    private static final long MILLIS_PER_HOUR = 3600000L;
    private static OmemoService<?, ?, ?, ?, ?, ?, ?, ?, ?> INSTANCE;
    private OmemoStore<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess, T_Addr, T_ECPub, T_Bundle, T_Ciph> omemoStore;
    private final HashMap<OmemoManager, OmemoRatchet<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess, T_Addr, T_ECPub, T_Bundle, T_Ciph>> omemoRatchets = new HashMap();
    private static final OmemoTrustCallback gullibleTrustCallback;

    protected OmemoService() {
    }

    public static OmemoService<?, ?, ?, ?, ?, ?, ?, ?, ?> getInstance() {
        if (INSTANCE == null) {
            throw new IllegalStateException("No OmemoService registered");
        }
        return INSTANCE;
    }

    protected static void setInstance(OmemoService<?, ?, ?, ?, ?, ?, ?, ?, ?> omemoService) {
        if (INSTANCE != null) {
            throw new IllegalStateException("An OmemoService is already registered");
        }
        INSTANCE = omemoService;
    }

    public static boolean isServiceRegistered() {
        return INSTANCE != null;
    }

    public OmemoStore<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess, T_Addr, T_ECPub, T_Bundle, T_Ciph> getOmemoStoreBackend() {
        if (this.omemoStore == null) {
            this.omemoStore = this.createDefaultOmemoStoreBackend();
        }
        return this.omemoStore;
    }

    public void setOmemoStoreBackend(OmemoStore<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess, T_Addr, T_ECPub, T_Bundle, T_Ciph> omemoStore) {
        if (this.omemoStore != null) {
            throw new IllegalStateException("An OmemoStore backend has already been set.");
        }
        this.omemoStore = omemoStore;
    }

    protected abstract OmemoStore<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess, T_Addr, T_ECPub, T_Bundle, T_Ciph> createDefaultOmemoStoreBackend();

    protected abstract OmemoRatchet<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess, T_Addr, T_ECPub, T_Bundle, T_Ciph> instantiateOmemoRatchet(OmemoManager var1, OmemoStore<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess, T_Addr, T_ECPub, T_Bundle, T_Ciph> var2);

    protected OmemoRatchet<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess, T_Addr, T_ECPub, T_Bundle, T_Ciph> getOmemoRatchet(OmemoManager manager) {
        OmemoRatchet<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess, T_Addr, T_ECPub, T_Bundle, T_Ciph> omemoRatchet = this.omemoRatchets.get((Object)manager);
        if (omemoRatchet == null) {
            omemoRatchet = this.instantiateOmemoRatchet(manager, this.omemoStore);
            this.omemoRatchets.put(manager, omemoRatchet);
        }
        return omemoRatchet;
    }

    void registerRatchetForManager(OmemoManager manager) {
        this.omemoRatchets.put(manager, this.instantiateOmemoRatchet(manager, this.getOmemoStoreBackend()));
    }

    void init(OmemoManager.LoggedInOmemoManager managerGuard) throws InterruptedException, CorruptedOmemoKeyException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, SmackException.NoResponseException, PubSubException.NotALeafNodeException, IOException {
        OmemoManager manager = managerGuard.get();
        OmemoDevice userDevice = manager.getOwnDevice();
        this.getOmemoStoreBackend().replenishKeys(userDevice);
        if (this.shouldRotateSignedPreKey(userDevice)) {
            this.getOmemoStoreBackend().changeSignedPreKey(userDevice);
        }
        OmemoBundleElement_VAxolotl bundle = this.getOmemoStoreBackend().packOmemoBundle(userDevice);
        OmemoService.publishBundle(manager.getConnection(), userDevice, bundle);
        this.refreshAndRepublishDeviceList(manager.getConnection(), userDevice);
    }

    OmemoElement createRatchetUpdateElement(OmemoManager.LoggedInOmemoManager managerGuard, OmemoDevice contactsDevice) throws InterruptedException, SmackException.NoResponseException, CorruptedOmemoKeyException, SmackException.NotConnectedException, CannotEstablishOmemoSessionException, NoSuchAlgorithmException, CryptoFailedException, IOException {
        OmemoMessageBuilder<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess, T_Addr, T_ECPub, T_Bundle, T_Ciph> builder;
        OmemoManager manager = managerGuard.get();
        OmemoDevice userDevice = manager.getOwnDevice();
        if (contactsDevice.equals(userDevice)) {
            throw new IllegalArgumentException("\"Thou shall not update thy own ratchet!\" - William Shakespeare");
        }
        if (!this.hasSession(userDevice, contactsDevice)) {
            this.buildFreshSessionWithDevice(manager.getConnection(), userDevice, contactsDevice);
        }
        byte[] messageKey = OmemoMessageBuilder.generateKey("AES", 128);
        byte[] iv = OmemoMessageBuilder.generateIv();
        try {
            builder = new OmemoMessageBuilder<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess, T_Addr, T_ECPub, T_Bundle, T_Ciph>(userDevice, gullibleTrustCallback, this.getOmemoRatchet(manager), messageKey, iv, null);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new CryptoFailedException(e);
        }
        try {
            builder.addRecipient(contactsDevice);
        }
        catch (UndecidedOmemoIdentityException | UntrustedOmemoIdentityException e) {
            throw new AssertionError((Object)"Gullible Trust Callback reported undecided or untrusted device, even though it MUST NOT do that.");
        }
        catch (NoIdentityKeyException e) {
            throw new AssertionError((Object)("We MUST have an identityKey for " + String.valueOf(contactsDevice) + " since we built a session." + String.valueOf(e)));
        }
        return builder.finish();
    }

    private OmemoMessage.Sent encrypt(OmemoManager.LoggedInOmemoManager managerGuard, Set<OmemoDevice> contactsDevices, byte[] messageKey, byte[] iv, String message) throws SmackException.NotConnectedException, InterruptedException, SmackException.NoResponseException, UndecidedOmemoIdentityException, CryptoFailedException, IOException {
        OmemoMessageBuilder<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess, T_Addr, T_ECPub, T_Bundle, T_Ciph> builder;
        OmemoManager manager = managerGuard.get();
        OmemoDevice userDevice = manager.getOwnDevice();
        OmemoService.removeOurDevice(userDevice, contactsDevices);
        this.buildMissingSessionsWithDevices(manager.getConnection(), userDevice, contactsDevices);
        Set<OmemoDevice> undecidedDevices = this.getUndecidedDevices(userDevice, manager.getTrustCallback(), contactsDevices);
        if (!undecidedDevices.isEmpty()) {
            throw new UndecidedOmemoIdentityException(undecidedDevices);
        }
        HashMap<OmemoDevice, Throwable> skippedRecipients = new HashMap<OmemoDevice, Throwable>();
        try {
            builder = new OmemoMessageBuilder<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess, T_Addr, T_ECPub, T_Bundle, T_Ciph>(userDevice, manager.getTrustCallback(), this.getOmemoRatchet(managerGuard.get()), messageKey, iv, message);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new CryptoFailedException(e);
        }
        for (OmemoDevice contactsDevice : contactsDevices) {
            if (!this.hasSession(userDevice, contactsDevice)) {
                try {
                    this.buildFreshSessionWithDevice(manager.getConnection(), userDevice, contactsDevice);
                }
                catch (CannotEstablishOmemoSessionException | CorruptedOmemoKeyException e) {
                    LOGGER.log(Level.WARNING, "Could not build session with " + String.valueOf(contactsDevice) + ".", e);
                    skippedRecipients.put(contactsDevice, e);
                    continue;
                }
            }
            int messageCounter = this.omemoStore.loadOmemoMessageCounter(userDevice, contactsDevice);
            if (OmemoConfiguration.getIgnoreReadOnlyDevices()) {
                boolean readOnly;
                boolean bl = readOnly = messageCounter >= OmemoConfiguration.getMaxReadOnlyMessageCount();
                if (readOnly) {
                    LOGGER.log(Level.FINE, "Device " + String.valueOf(contactsDevice) + " seems to be read-only (We sent " + messageCounter + " messages without getting a reply back (max allowed is " + OmemoConfiguration.getMaxReadOnlyMessageCount() + "). Ignoring the device.");
                    skippedRecipients.put(contactsDevice, new ReadOnlyDeviceException(contactsDevice));
                    continue;
                }
            }
            try {
                builder.addRecipient(contactsDevice);
            }
            catch (CorruptedOmemoKeyException | NoIdentityKeyException e) {
                LOGGER.log(Level.WARNING, "Encryption failed for device " + String.valueOf(contactsDevice) + ".", e);
                skippedRecipients.put(contactsDevice, e);
            }
            catch (UndecidedOmemoIdentityException e) {
                throw new AssertionError((Object)("Recipients device seems to be undecided, even though we should have thrown an exception earlier in that case. " + String.valueOf(e)));
            }
            catch (UntrustedOmemoIdentityException e) {
                LOGGER.log(Level.WARNING, "Device " + String.valueOf(contactsDevice) + " is untrusted. Message is not encrypted for it.");
                skippedRecipients.put(contactsDevice, e);
            }
            this.omemoStore.storeOmemoMessageCounter(userDevice, contactsDevice, messageCounter + 1);
        }
        OmemoElement element = builder.finish();
        return new OmemoMessage.Sent(element, messageKey, iv, contactsDevices, skippedRecipients);
    }

    OmemoMessage.Received decryptMessage(OmemoManager.LoggedInOmemoManager managerGuard, BareJid senderJid, OmemoElement omemoElement) throws CorruptedOmemoKeyException, CryptoFailedException, NoRawSessionException, IOException {
        OmemoFingerprint senderFingerprint;
        OmemoManager manager = managerGuard.get();
        int senderId = omemoElement.getHeader().getSid();
        OmemoDevice senderDevice = new OmemoDevice(senderJid, senderId);
        CipherAndAuthTag cipherAndAuthTag = this.getOmemoRatchet(manager).retrieveMessageKeyAndAuthTag(senderDevice, omemoElement);
        try {
            senderFingerprint = this.getOmemoStoreBackend().getFingerprint(manager.getOwnDevice(), senderDevice);
        }
        catch (NoIdentityKeyException e) {
            throw new AssertionError((Object)("Cannot retrieve OmemoFingerprint of sender although decryption was successful: " + String.valueOf(e)));
        }
        this.omemoStore.storeOmemoMessageCounter(manager.getOwnDevice(), senderDevice, 0);
        if (omemoElement.isMessageElement()) {
            String plaintext = OmemoRatchet.decryptMessageElement(omemoElement, cipherAndAuthTag);
            return new OmemoMessage.Received(omemoElement, cipherAndAuthTag.getKey(), cipherAndAuthTag.getIv(), plaintext, senderFingerprint, senderDevice, cipherAndAuthTag.wasPreKeyEncrypted());
        }
        return new OmemoMessage.Received(omemoElement, cipherAndAuthTag.getKey(), cipherAndAuthTag.getIv(), null, senderFingerprint, senderDevice, cipherAndAuthTag.wasPreKeyEncrypted());
    }

    OmemoMessage.Sent createKeyTransportElement(OmemoManager.LoggedInOmemoManager managerGuard, Set<OmemoDevice> contactsDevices, byte[] key, byte[] iv) throws InterruptedException, UndecidedOmemoIdentityException, CryptoFailedException, SmackException.NotConnectedException, SmackException.NoResponseException, IOException {
        return this.encrypt(managerGuard, contactsDevices, key, iv, null);
    }

    OmemoMessage.Sent createOmemoMessage(OmemoManager.LoggedInOmemoManager managerGuard, Set<OmemoDevice> contactsDevices, String message) throws InterruptedException, UndecidedOmemoIdentityException, CryptoFailedException, SmackException.NotConnectedException, SmackException.NoResponseException, IOException {
        byte[] key;
        byte[] iv = OmemoMessageBuilder.generateIv();
        try {
            key = OmemoMessageBuilder.generateKey("AES", 128);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoFailedException(e);
        }
        return this.encrypt(managerGuard, contactsDevices, key, iv, message);
    }

    private static OmemoBundleElement fetchBundle(XMPPConnection connection, OmemoDevice contactsDevice) throws SmackException.NotConnectedException, InterruptedException, SmackException.NoResponseException, XMPPException.XMPPErrorException, PubSubException.NotALeafNodeException, PubSubException.NotAPubSubNodeException {
        PubSubManager pm = PubSubManager.getInstanceFor((XMPPConnection)connection, (BareJid)contactsDevice.getJid());
        LeafNode node = pm.getLeafNode(contactsDevice.getBundleNodeName());
        if (node == null) {
            return null;
        }
        List bundleItems = node.getItems();
        if (bundleItems.isEmpty()) {
            return null;
        }
        return (OmemoBundleElement)((PayloadItem)bundleItems.get(bundleItems.size() - 1)).getPayload();
    }

    static void publishBundle(XMPPConnection connection, OmemoDevice userDevice, OmemoBundleElement bundle) throws XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, SmackException.NoResponseException, PubSubException.NotALeafNodeException {
        PepManager pm = PepManager.getInstanceFor((XMPPConnection)connection);
        pm.publish(userDevice.getBundleNodeName(), (Item)new PayloadItem((XmlElement)bundle));
    }

    private static OmemoDeviceListElement fetchDeviceList(XMPPConnection connection, BareJid contact) throws InterruptedException, PubSubException.NotALeafNodeException, SmackException.NoResponseException, SmackException.NotConnectedException, XMPPException.XMPPErrorException, PubSubException.NotAPubSubNodeException {
        String nodeName;
        PubSubManager pm = PubSubManager.getInstanceFor((XMPPConnection)connection, (BareJid)contact);
        LeafNode node = pm.getLeafNode(nodeName = "eu.siacs.conversations.axolotl.devicelist");
        if (node == null) {
            return null;
        }
        List items = node.getItems();
        if (items.isEmpty()) {
            return null;
        }
        return (OmemoDeviceListElement)((PayloadItem)items.get(items.size() - 1)).getPayload();
    }

    static void publishDeviceList(XMPPConnection connection, OmemoDeviceListElement deviceList) throws InterruptedException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, SmackException.NoResponseException, PubSubException.NotALeafNodeException {
        PepManager pm = PepManager.getInstanceFor((XMPPConnection)connection);
        pm.publish("eu.siacs.conversations.axolotl.devicelist", (Item)new PayloadItem((XmlElement)deviceList));
    }

    private void refreshAndRepublishDeviceList(XMPPConnection connection, OmemoDevice userDevice) throws InterruptedException, PubSubException.NotALeafNodeException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, SmackException.NoResponseException, IOException {
        OmemoDeviceListElement publishedList;
        try {
            publishedList = OmemoService.fetchDeviceList(connection, userDevice.getJid());
        }
        catch (PubSubException.NotAPubSubNodeException e) {
            publishedList = null;
        }
        catch (XMPPException.XMPPErrorException e) {
            if (e.getStanzaError().getCondition() == StanzaError.Condition.item_not_found) {
                publishedList = null;
            }
            throw e;
        }
        if (publishedList == null) {
            publishedList = new OmemoDeviceListElement_VAxolotl(Collections.emptySet());
        }
        this.getOmemoStoreBackend().mergeCachedDeviceList(userDevice, userDevice.getJid(), publishedList);
        OmemoCachedDeviceList cachedList = this.cleanUpDeviceList(userDevice);
        if (!publishedList.getDeviceIds().equals(cachedList.getActiveDevices())) {
            OmemoService.publishDeviceList(connection, new OmemoDeviceListElement_VAxolotl(cachedList));
        }
    }

    OmemoCachedDeviceList cleanUpDeviceList(OmemoDevice userDevice) throws IOException {
        OmemoCachedDeviceList cachedDeviceList = OmemoConfiguration.getDeleteStaleDevices() ? this.deleteStaleDevices(userDevice) : this.getOmemoStoreBackend().loadCachedDeviceList(userDevice);
        if (!cachedDeviceList.getActiveDevices().contains(userDevice.getDeviceId())) {
            cachedDeviceList.addDevice(userDevice.getDeviceId());
        }
        this.getOmemoStoreBackend().storeCachedDeviceList(userDevice, userDevice.getJid(), cachedDeviceList);
        return cachedDeviceList;
    }

    OmemoCachedDeviceList refreshDeviceList(XMPPConnection connection, OmemoDevice userDevice, BareJid contact) throws InterruptedException, PubSubException.NotALeafNodeException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, SmackException.NoResponseException, IOException {
        OmemoDeviceListElement publishedList;
        try {
            publishedList = OmemoService.fetchDeviceList(connection, contact);
        }
        catch (PubSubException.NotAPubSubNodeException e) {
            LOGGER.log(Level.WARNING, "Error refreshing deviceList: ", e);
            publishedList = null;
        }
        if (publishedList == null) {
            publishedList = new OmemoDeviceListElement_VAxolotl(Collections.emptySet());
        }
        return this.getOmemoStoreBackend().mergeCachedDeviceList(userDevice, contact, publishedList);
    }

    void buildFreshSessionWithDevice(XMPPConnection connection, OmemoDevice userDevice, OmemoDevice contactsDevice) throws CannotEstablishOmemoSessionException, SmackException.NotConnectedException, InterruptedException, SmackException.NoResponseException, CorruptedOmemoKeyException {
        OmemoBundleElement bundleElement;
        if (contactsDevice.equals(userDevice)) {
            return;
        }
        try {
            bundleElement = OmemoService.fetchBundle(connection, contactsDevice);
        }
        catch (XMPPException.XMPPErrorException | PubSubException.NotALeafNodeException | PubSubException.NotAPubSubNodeException e) {
            throw new CannotEstablishOmemoSessionException(contactsDevice, e);
        }
        Map bundlesList = this.getOmemoStoreBackend().keyUtil().BUNDLE.bundles(bundleElement, contactsDevice);
        int randomIndex = new Random().nextInt(bundlesList.size());
        Object randomPreKeyBundle = new ArrayList(bundlesList.values()).get(randomIndex);
        OmemoManager omemoManager = OmemoManager.getInstanceFor(connection, userDevice.getDeviceId());
        this.processBundle(omemoManager, randomPreKeyBundle, contactsDevice);
    }

    private Set<OmemoDevice> buildMissingSessionsWithDevices(XMPPConnection connection, OmemoDevice userDevice, Set<OmemoDevice> devices) throws SmackException.NotConnectedException, InterruptedException, SmackException.NoResponseException, IOException {
        HashSet<OmemoDevice> devicesWithSession = new HashSet<OmemoDevice>();
        for (OmemoDevice device : devices) {
            if (this.hasSession(userDevice, device)) {
                devicesWithSession.add(device);
                continue;
            }
            try {
                this.buildFreshSessionWithDevice(connection, userDevice, device);
                devicesWithSession.add(device);
            }
            catch (CannotEstablishOmemoSessionException e) {
                LOGGER.log(Level.WARNING, String.valueOf(userDevice) + " cannot establish session with " + String.valueOf(device) + " because their bundle could not be fetched.", e);
            }
            catch (CorruptedOmemoKeyException e) {
                LOGGER.log(Level.WARNING, String.valueOf(userDevice) + " could not establish session with " + String.valueOf(device) + "because their bundle seems to be corrupt.", e);
            }
        }
        return devicesWithSession;
    }

    private Set<OmemoDevice> getUndecidedDevices(OmemoDevice userDevice, OmemoTrustCallback callback, Set<OmemoDevice> devices) throws IOException {
        HashSet<OmemoDevice> undecidedDevices = new HashSet<OmemoDevice>();
        for (OmemoDevice device : devices) {
            OmemoFingerprint fingerprint;
            try {
                fingerprint = this.getOmemoStoreBackend().getFingerprint(userDevice, device);
            }
            catch (CorruptedOmemoKeyException | NoIdentityKeyException e) {
                LOGGER.log(Level.WARNING, "Could not load fingerprint of " + String.valueOf(device), e);
                undecidedDevices.add(device);
                continue;
            }
            if (callback.getTrust(device, fingerprint) != TrustState.undecided) continue;
            undecidedDevices.add(device);
        }
        return undecidedDevices;
    }

    private boolean hasSession(OmemoDevice userDevice, OmemoDevice contactsDevice) throws IOException {
        return this.getOmemoStoreBackend().loadRawSession(userDevice, contactsDevice) != null;
    }

    protected abstract void processBundle(OmemoManager var1, T_Bundle var2, OmemoDevice var3) throws CorruptedOmemoKeyException;

    private boolean shouldRotateSignedPreKey(OmemoDevice userDevice) throws IOException {
        if (!OmemoConfiguration.getRenewOldSignedPreKeys()) {
            return false;
        }
        Date now = new Date();
        Date lastRenewal = this.getOmemoStoreBackend().getDateOfLastSignedPreKeyRenewal(userDevice);
        if (lastRenewal == null) {
            lastRenewal = new Date();
            this.getOmemoStoreBackend().setDateOfLastSignedPreKeyRenewal(userDevice, lastRenewal);
        }
        long allowedAgeMillis = 3600000L * (long)OmemoConfiguration.getRenewOldSignedPreKeysAfterHours();
        return now.getTime() - lastRenewal.getTime() > allowedAgeMillis;
    }

    private OmemoCachedDeviceList deleteStaleDevices(OmemoDevice userDevice) throws IOException {
        OmemoCachedDeviceList deviceList = this.getOmemoStoreBackend().loadCachedDeviceList(userDevice);
        int maxAgeHours = OmemoConfiguration.getDeleteStaleDevicesAfterHours();
        return this.removeStaleDevicesFromDeviceList(userDevice, userDevice.getJid(), deviceList, maxAgeHours);
    }

    private OmemoCachedDeviceList removeStaleDevicesFromDeviceList(OmemoDevice userDevice, BareJid contact, OmemoCachedDeviceList contactsDeviceList, int maxAgeHours) throws IOException {
        OmemoCachedDeviceList deviceList = new OmemoCachedDeviceList(contactsDeviceList);
        for (int deviceId : contactsDeviceList.getActiveDevices()) {
            Date lastMessageReceived;
            OmemoDevice device = new OmemoDevice(contact, deviceId);
            Date lastDeviceIdPublication = this.getOmemoStoreBackend().getDateOfLastDeviceIdPublication(userDevice, device);
            if (lastDeviceIdPublication == null) {
                lastDeviceIdPublication = new Date();
                this.getOmemoStoreBackend().setDateOfLastDeviceIdPublication(userDevice, device, lastDeviceIdPublication);
            }
            if ((lastMessageReceived = this.getOmemoStoreBackend().getDateOfLastReceivedMessage(userDevice, device)) == null) {
                lastMessageReceived = new Date();
                this.getOmemoStoreBackend().setDateOfLastReceivedMessage(userDevice, device, lastMessageReceived);
            }
            boolean stale = OmemoService.isStale(userDevice, device, lastDeviceIdPublication, maxAgeHours);
            if (!(stale &= OmemoService.isStale(userDevice, device, lastMessageReceived, maxAgeHours))) continue;
            deviceList.addInactiveDevice(deviceId);
        }
        return deviceList;
    }

    static void removeOurDevice(OmemoDevice userDevice, Collection<OmemoDevice> devices) {
        if (devices.contains(userDevice)) {
            devices.remove(userDevice);
        }
    }

    static boolean isStale(OmemoDevice userDevice, OmemoDevice subject, Date lastReceipt, int maxAgeHours) {
        if (userDevice.equals(subject)) {
            return false;
        }
        if (lastReceipt == null) {
            return false;
        }
        long maxAgeMillis = 3600000L * (long)maxAgeHours;
        Date now = new Date();
        return now.getTime() - lastReceipt.getTime() > maxAgeMillis;
    }

    List<MessageOrOmemoMessage> decryptMamQueryResult(OmemoManager.LoggedInOmemoManager managerGuard, MamManager.MamQuery mamQuery) throws IOException {
        ArrayList<MessageOrOmemoMessage> result = new ArrayList<MessageOrOmemoMessage>();
        for (Message message : mamQuery.getMessages()) {
            if (OmemoManager.stanzaContainsOmemoElement((Stanza)message)) {
                OmemoElement element = (OmemoElement)message.getExtensionElement("encrypted", "eu.siacs.conversations.axolotl");
                try {
                    OmemoMessage.Received omemoMessage = this.decryptMessage(managerGuard, message.getFrom().asBareJid(), element);
                    result.add(new MessageOrOmemoMessage(omemoMessage));
                }
                catch (CorruptedOmemoKeyException | CryptoFailedException | NoRawSessionException e) {
                    LOGGER.log(Level.WARNING, "decryptMamQueryResult failed to decrypt message from " + String.valueOf(message.getFrom()) + " due to corrupted session/key: " + e.getMessage());
                    result.add(new MessageOrOmemoMessage(message));
                }
                continue;
            }
            result.add(new MessageOrOmemoMessage(message));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onOmemoCarbonCopyReceived(CarbonExtension.Direction direction, Message carbonCopy, Message wrappingMessage, OmemoManager.LoggedInOmemoManager managerGuard) throws IOException {
        OmemoManager manager;
        OmemoManager omemoManager = manager = managerGuard.get();
        synchronized (omemoManager) {
            OmemoDevice userDevice;
            block14: {
                userDevice = manager.getOwnDevice();
                OmemoElement element = (OmemoElement)carbonCopy.getExtensionElement("encrypted", "eu.siacs.conversations.axolotl");
                if (element == null) {
                    return;
                }
                BareJid sender = carbonCopy.getFrom().asBareJid();
                try {
                    OmemoMessage.Received decrypted = this.decryptMessage(managerGuard, sender, element);
                    manager.notifyOmemoCarbonCopyReceived(direction, carbonCopy, wrappingMessage, decrypted);
                    if (!decrypted.isPreKeyMessage() || !OmemoConfiguration.getCompleteSessionWithEmptyMessage()) break block14;
                    LOGGER.log(Level.FINE, "Received a preKeyMessage in a carbon copy from " + String.valueOf(decrypted.getSenderDevice()) + ".\nComplete the session by sending an empty response message.");
                    try {
                        this.sendRatchetUpdate(managerGuard, decrypted.getSenderDevice());
                    }
                    catch (CannotEstablishOmemoSessionException e) {
                        throw new AssertionError((Object)("Since we successfully received a message, we MUST be able to establish a session. " + String.valueOf(e)));
                    }
                    catch (InterruptedException | NoSuchAlgorithmException | SmackException.NoResponseException | SmackException.NotConnectedException e) {
                        LOGGER.log(Level.WARNING, "Cannot send a ratchet update message.", e);
                    }
                }
                catch (NoRawSessionException e) {
                    OmemoDevice device = e.getDeviceWithoutSession();
                    LOGGER.log(Level.WARNING, "No raw session found for contact " + String.valueOf(device) + ". ", e);
                    if (OmemoConfiguration.getRepairBrokenSessionsWithPreKeyMessages()) {
                        this.repairBrokenSessionWithPreKeyMessage(managerGuard, device);
                    }
                }
                catch (CorruptedOmemoKeyException | CryptoFailedException e) {
                    LOGGER.log(Level.WARNING, "Could not decrypt incoming carbon copy: ", e);
                }
            }
            if (this.getOmemoStoreBackend().loadOmemoPreKeys(userDevice).size() < 100) {
                LOGGER.log(Level.FINE, "We used up a preKey. Upload a fresh bundle.");
                try {
                    this.getOmemoStoreBackend().replenishKeys(userDevice);
                    OmemoBundleElement_VAxolotl bundleElement = this.getOmemoStoreBackend().packOmemoBundle(userDevice);
                    OmemoService.publishBundle(manager.getConnection(), userDevice, bundleElement);
                }
                catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException.XMPPErrorException | CorruptedOmemoKeyException | PubSubException.NotALeafNodeException e) {
                    LOGGER.log(Level.WARNING, "Could not republish replenished bundle.", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onOmemoMessageStanzaReceived(Stanza stanza, OmemoManager.LoggedInOmemoManager managerGuard) throws IOException {
        OmemoManager manager;
        OmemoManager omemoManager = manager = managerGuard.get();
        synchronized (omemoManager) {
            OmemoDevice userDevice;
            block18: {
                userDevice = manager.getOwnDevice();
                OmemoElement element = (OmemoElement)stanza.getExtensionElement("encrypted", "eu.siacs.conversations.axolotl");
                if (element == null) {
                    return;
                }
                try {
                    OmemoMessage.Received decrypted;
                    MultiUserChat muc = OmemoService.getMuc(manager.getConnection(), stanza.getFrom());
                    if (muc != null) {
                        Occupant occupant = muc.getOccupant(stanza.getFrom().asEntityFullJidIfPossible());
                        if (occupant == null) {
                            LOGGER.log(Level.WARNING, "Cannot decrypt OMEMO MUC message; MUC Occupant is null.");
                            return;
                        }
                        Jid occupantJid = occupant.getJid();
                        if (occupantJid == null) {
                            LOGGER.log(Level.WARNING, "Cannot decrypt OMEMO MUC message; Senders Jid is null. " + String.valueOf(stanza.getFrom()));
                            return;
                        }
                        BareJid sender = occupantJid.asBareJid();
                        decrypted = this.decryptMessage(managerGuard, sender, element);
                        manager.notifyOmemoMucMessageReceived(muc, stanza, decrypted);
                    } else {
                        BareJid sender = stanza.getFrom().asBareJid();
                        decrypted = this.decryptMessage(managerGuard, sender, element);
                        manager.notifyOmemoMessageReceived(stanza, decrypted);
                    }
                    if (!decrypted.isPreKeyMessage() || !OmemoConfiguration.getCompleteSessionWithEmptyMessage()) break block18;
                    LOGGER.log(Level.FINE, "Received a preKeyMessage from " + String.valueOf(decrypted.getSenderDevice()) + ".\nComplete the session by sending an empty response message.");
                    try {
                        this.sendRatchetUpdate(managerGuard, decrypted.getSenderDevice());
                    }
                    catch (CannotEstablishOmemoSessionException e) {
                        throw new AssertionError((Object)("Since we successfully received a message, we MUST be able to establish a session. " + String.valueOf(e)));
                    }
                    catch (InterruptedException | NoSuchAlgorithmException | SmackException.NoResponseException | SmackException.NotConnectedException e) {
                        LOGGER.log(Level.WARNING, "Cannot send a ratchet update message.", e);
                    }
                }
                catch (NoRawSessionException e) {
                    OmemoDevice device = e.getDeviceWithoutSession();
                    LOGGER.log(Level.WARNING, "No raw session found for contact " + String.valueOf(device) + ". ", e);
                    if (OmemoConfiguration.getRepairBrokenSessionsWithPreKeyMessages()) {
                        this.repairBrokenSessionWithPreKeyMessage(managerGuard, device);
                    }
                }
                catch (CorruptedOmemoKeyException | CryptoFailedException e) {
                    LOGGER.log(Level.WARNING, "Could not decrypt incoming message: ", e);
                }
            }
            if (this.getOmemoStoreBackend().loadOmemoPreKeys(userDevice).size() < 100) {
                LOGGER.log(Level.FINE, "We used up a preKey. Upload a fresh bundle.");
                try {
                    this.getOmemoStoreBackend().replenishKeys(userDevice);
                    OmemoBundleElement_VAxolotl bundleElement = this.getOmemoStoreBackend().packOmemoBundle(userDevice);
                    OmemoService.publishBundle(manager.getConnection(), userDevice, bundleElement);
                }
                catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException.XMPPErrorException | CorruptedOmemoKeyException | PubSubException.NotALeafNodeException e) {
                    LOGGER.log(Level.WARNING, "Could not republish replenished bundle.", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OmemoMessage.Received decryptStanza(Stanza stanza, OmemoManager.LoggedInOmemoManager managerGuard) throws IOException {
        OmemoManager manager;
        OmemoManager omemoManager = manager = managerGuard.get();
        synchronized (omemoManager) {
            OmemoMessage.Received decrypted;
            OmemoDevice userDevice;
            block16: {
                userDevice = manager.getOwnDevice();
                OmemoElement element = (OmemoElement)stanza.getExtensionElement("encrypted", "eu.siacs.conversations.axolotl");
                if (element == null) {
                    return null;
                }
                decrypted = null;
                try {
                    MultiUserChat muc = OmemoService.getMuc(manager.getConnection(), stanza.getFrom());
                    if (muc != null) {
                        Occupant occupant = muc.getOccupant(stanza.getFrom().asEntityFullJidIfPossible());
                        Jid occupantJid = occupant.getJid();
                        if (occupantJid == null) {
                            LOGGER.log(Level.WARNING, "MUC message received, but there is no way to retrieve the senders Jid. " + String.valueOf(stanza.getFrom()));
                            return null;
                        }
                        BareJid sender = occupantJid.asBareJid();
                        decrypted = this.decryptMessage(managerGuard, sender, element);
                    } else {
                        BareJid sender = stanza.getFrom().asBareJid();
                        decrypted = this.decryptMessage(managerGuard, sender, element);
                    }
                    if (!decrypted.isPreKeyMessage() || !OmemoConfiguration.getCompleteSessionWithEmptyMessage()) break block16;
                    LOGGER.log(Level.FINE, "Received a preKeyMessage from " + String.valueOf(decrypted.getSenderDevice()) + ".\nComplete the session by sending an empty response message.");
                    try {
                        this.sendRatchetUpdate(managerGuard, decrypted.getSenderDevice());
                    }
                    catch (CannotEstablishOmemoSessionException e) {
                        throw new AssertionError((Object)("Since we successfully received a message, we MUST be able to establish a session. " + String.valueOf(e)));
                    }
                    catch (InterruptedException | NoSuchAlgorithmException | SmackException.NoResponseException | SmackException.NotConnectedException e) {
                        LOGGER.log(Level.WARNING, "Cannot send a ratchet update message.", e);
                    }
                }
                catch (NoRawSessionException e) {
                    OmemoDevice device = e.getDeviceWithoutSession();
                    LOGGER.log(Level.WARNING, "No raw session found for contact " + String.valueOf(device) + ". ", e);
                }
                catch (CorruptedOmemoKeyException | CryptoFailedException e) {
                    LOGGER.log(Level.WARNING, "Could not decrypt incoming message: ", e);
                }
            }
            if (this.getOmemoStoreBackend().loadOmemoPreKeys(userDevice).size() < 100) {
                LOGGER.log(Level.FINE, "We used up a preKey. Upload a fresh bundle.");
                try {
                    this.getOmemoStoreBackend().replenishKeys(userDevice);
                    OmemoBundleElement_VAxolotl bundleElement = this.getOmemoStoreBackend().packOmemoBundle(userDevice);
                    OmemoService.publishBundle(manager.getConnection(), userDevice, bundleElement);
                }
                catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException.XMPPErrorException | CorruptedOmemoKeyException | PubSubException.NotALeafNodeException e) {
                    LOGGER.log(Level.WARNING, "Could not republish replenished bundle.", e);
                }
            }
            return decrypted;
        }
    }

    private void repairBrokenSessionWithPreKeyMessage(OmemoManager.LoggedInOmemoManager managerGuard, OmemoDevice brokenDevice) throws IOException {
        LOGGER.log(Level.WARNING, "Attempt to repair the session by sending a fresh preKey message to " + String.valueOf(brokenDevice));
        OmemoManager manager = managerGuard.get();
        try {
            this.buildFreshSessionWithDevice(manager.getConnection(), manager.getOwnDevice(), brokenDevice);
            this.sendRatchetUpdate(managerGuard, brokenDevice);
        }
        catch (CannotEstablishOmemoSessionException | CorruptedOmemoKeyException e) {
            LOGGER.log(Level.WARNING, "Unable to repair session with " + String.valueOf(brokenDevice), e);
        }
        catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException e) {
            LOGGER.log(Level.WARNING, "Could not fetch fresh bundle for " + String.valueOf(brokenDevice), e);
        }
        catch (NoSuchAlgorithmException | CryptoFailedException e) {
            LOGGER.log(Level.WARNING, "Could not create PreKeyMessage", e);
        }
    }

    private void sendRatchetUpdate(OmemoManager.LoggedInOmemoManager managerGuard, OmemoDevice contactsDevice) throws CorruptedOmemoKeyException, InterruptedException, SmackException.NoResponseException, NoSuchAlgorithmException, SmackException.NotConnectedException, CryptoFailedException, CannotEstablishOmemoSessionException, IOException {
        OmemoManager manager = managerGuard.get();
        OmemoElement ratchetUpdate = this.createRatchetUpdateElement(managerGuard, contactsDevice);
        XMPPConnection connection = manager.getConnection();
        Message message = ((MessageBuilder)((MessageBuilder)connection.getStanzaFactory().buildMessageStanza().to((Jid)contactsDevice.getJid())).addExtension((XmlElement)ratchetUpdate)).build();
        connection.sendStanza((Stanza)message);
    }

    private static MultiUserChat getMuc(XMPPConnection connection, Jid jid) {
        EntityBareJid ebj = jid.asEntityBareJidIfPossible();
        if (ebj == null) {
            return null;
        }
        MultiUserChatManager mucm = MultiUserChatManager.getInstanceFor((XMPPConnection)connection);
        Set joinedRooms = mucm.getJoinedRooms();
        if (joinedRooms.contains(ebj)) {
            return mucm.getMultiUserChat(ebj);
        }
        return null;
    }

    public void purgeDeviceList(OmemoManager.LoggedInOmemoManager managerGuard) throws InterruptedException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, SmackException.NoResponseException, IOException, PubSubException.NotALeafNodeException {
        OmemoManager omemoManager = managerGuard.get();
        OmemoDevice userDevice = omemoManager.getOwnDevice();
        OmemoDeviceListElement_VAxolotl newList = new OmemoDeviceListElement_VAxolotl(Collections.singleton(userDevice.getDeviceId()));
        this.getOmemoStoreBackend().mergeCachedDeviceList(userDevice, userDevice.getJid(), newList);
        OmemoService.publishDeviceList(omemoManager.getConnection(), newList);
    }

    static {
        gullibleTrustCallback = new OmemoTrustCallback(){

            @Override
            public TrustState getTrust(OmemoDevice device, OmemoFingerprint fingerprint) {
                return TrustState.trusted;
            }

            @Override
            public void setTrust(OmemoDevice device, OmemoFingerprint fingerprint, TrustState state) {
            }
        };
    }
}

