/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.ox.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Set;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.stringencoder.Base64;
import org.jivesoftware.smackx.ox.crypto.OpenPgpProvider;
import org.jivesoftware.smackx.ox.element.SecretkeyElement;
import org.jivesoftware.smackx.ox.exception.InvalidBackupCodeException;
import org.jivesoftware.smackx.ox.exception.MissingOpenPgpKeyException;
import org.jxmpp.jid.BareJid;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.key.OpenPgpV4Fingerprint;
import org.pgpainless.util.Passphrase;

public class SecretKeyBackupHelper {
    public static String generateBackupPassword() {
        return StringUtils.secureOfflineAttackSafeRandomString();
    }

    public static SecretkeyElement createSecretkeyElement(OpenPgpProvider provider, BareJid owner, Set<OpenPgpV4Fingerprint> fingerprints, String backupCode) throws PGPException, IOException, MissingOpenPgpKeyException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        for (OpenPgpV4Fingerprint fingerprint : fingerprints) {
            PGPSecretKeyRing key = provider.getStore().getSecretKeyRing(owner, fingerprint);
            if (key == null) {
                throw new MissingOpenPgpKeyException(owner, fingerprint);
            }
            byte[] bytes = key.getEncoded();
            buffer.write(bytes);
        }
        return SecretKeyBackupHelper.createSecretkeyElement(buffer.toByteArray(), backupCode);
    }

    public static SecretkeyElement createSecretkeyElement(byte[] keys, String backupCode) throws PGPException, IOException {
        byte[] encrypted = PGPainless.encryptWithPassword((byte[])keys, (Passphrase)new Passphrase(backupCode.toCharArray()), (SymmetricKeyAlgorithm)SymmetricKeyAlgorithm.AES_256);
        return new SecretkeyElement(Base64.encode((byte[])encrypted));
    }

    public static PGPSecretKeyRing restoreSecretKeyBackup(SecretkeyElement backup, String backupCode) throws InvalidBackupCodeException, IOException, PGPException {
        byte[] decrypted;
        byte[] encrypted = Base64.decode((byte[])backup.getB64Data());
        try {
            decrypted = PGPainless.decryptWithPassword((byte[])encrypted, (Passphrase)new Passphrase(backupCode.toCharArray()));
        }
        catch (IOException | PGPException e) {
            throw new InvalidBackupCodeException("Could not decrypt secret key backup. Possibly wrong passphrase?", e);
        }
        return PGPainless.readKeyRing().secretKeyRing(decrypted);
    }
}

