/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.ox;

import java.io.File;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import junit.framework.TestCase;
import org.apache.commons.io.FileUtils;
import org.bouncycastle.openpgp.PGPException;
import org.jivesoftware.smack.DummyConnection;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.test.util.SmackTestSuite;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.ox.OpenPgpContact;
import org.jivesoftware.smackx.ox.OpenPgpMessage;
import org.jivesoftware.smackx.ox.OpenPgpSelf;
import org.jivesoftware.smackx.ox.crypto.OpenPgpElementAndMetadata;
import org.jivesoftware.smackx.ox.crypto.PainlessOpenPgpProvider;
import org.jivesoftware.smackx.ox.element.CryptElement;
import org.jivesoftware.smackx.ox.element.SignElement;
import org.jivesoftware.smackx.ox.element.SigncryptElement;
import org.jivesoftware.smackx.ox.exception.MissingUserIdOnKeyException;
import org.jivesoftware.smackx.ox.store.definition.OpenPgpStore;
import org.jivesoftware.smackx.ox.store.filebased.FileBasedOpenPgpStore;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.jupiter.api.Test;
import org.jxmpp.jid.BareJid;
import org.jxmpp.jid.JidTestUtil;
import org.pgpainless.key.OpenPgpV4Fingerprint;
import org.pgpainless.key.collection.PGPKeyRing;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.protection.UnprotectedKeysProtector;

public class PainlessOpenPgpProviderTest
extends SmackTestSuite {
    private static final File storagePath;
    private static final BareJid alice;
    private static final BareJid bob;

    @BeforeClass
    @AfterClass
    public static void deletePath() throws IOException {
        FileUtils.deleteDirectory((File)storagePath);
    }

    @Test
    public void encryptDecryptTest() throws PGPException, NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException, IOException, MissingUserIdOnKeyException, XmlPullParserException {
        FileBasedOpenPgpStore aliceStore = new FileBasedOpenPgpStore(storagePath);
        FileBasedOpenPgpStore bobStore = new FileBasedOpenPgpStore(storagePath);
        aliceStore.setKeyRingProtector((SecretKeyRingProtector)new UnprotectedKeysProtector());
        bobStore.setKeyRingProtector((SecretKeyRingProtector)new UnprotectedKeysProtector());
        PainlessOpenPgpProvider aliceProvider = new PainlessOpenPgpProvider((XMPPConnection)new DummyConnection(), (OpenPgpStore)aliceStore);
        PainlessOpenPgpProvider bobProvider = new PainlessOpenPgpProvider((XMPPConnection)new DummyConnection(), (OpenPgpStore)bobStore);
        PGPKeyRing aliceKeys = aliceStore.generateKeyRing(alice);
        PGPKeyRing bobKeys = bobStore.generateKeyRing(bob);
        OpenPgpV4Fingerprint aliceFingerprint = new OpenPgpV4Fingerprint(aliceKeys.getPublicKeys());
        OpenPgpV4Fingerprint bobFingerprint = new OpenPgpV4Fingerprint(bobKeys.getPublicKeys());
        aliceStore.importSecretKey(alice, aliceKeys.getSecretKeys());
        bobStore.importSecretKey(bob, bobKeys.getSecretKeys());
        aliceStore.setAnnouncedFingerprintsOf(alice, Collections.singletonMap(new OpenPgpV4Fingerprint(aliceKeys.getPublicKeys()), new Date()));
        bobStore.setAnnouncedFingerprintsOf(bob, Collections.singletonMap(new OpenPgpV4Fingerprint(bobKeys.getPublicKeys()), new Date()));
        OpenPgpSelf aliceSelf = new OpenPgpSelf(alice, (OpenPgpStore)aliceStore);
        aliceSelf.trust(aliceFingerprint);
        OpenPgpSelf bobSelf = new OpenPgpSelf(bob, (OpenPgpStore)bobStore);
        bobSelf.trust(bobFingerprint);
        aliceStore.importPublicKey(bob, bobKeys.getPublicKeys());
        bobStore.importPublicKey(alice, aliceKeys.getPublicKeys());
        aliceStore.setAnnouncedFingerprintsOf(bob, Collections.singletonMap(new OpenPgpV4Fingerprint(bobKeys.getPublicKeys()), new Date()));
        bobStore.setAnnouncedFingerprintsOf(alice, Collections.singletonMap(new OpenPgpV4Fingerprint(aliceKeys.getPublicKeys()), new Date()));
        OpenPgpContact aliceForBob = new OpenPgpContact(alice, (OpenPgpStore)bobStore);
        aliceForBob.trust(aliceFingerprint);
        OpenPgpContact bobForAlice = new OpenPgpContact(bob, (OpenPgpStore)aliceStore);
        bobForAlice.trust(bobFingerprint);
        Message.Body body = new Message.Body(null, "Lorem ipsum dolor sit amet, consectetur adipisici elit, sed eiusmod tempor incidunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquid ex ea commodi consequat. Quis aute iure reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint obcaecat cupiditat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.");
        List<Message.Body> payload = Collections.singletonList(body);
        SigncryptElement signcryptElement = new SigncryptElement(Collections.singleton(bob), payload);
        OpenPgpElementAndMetadata encrypted = aliceProvider.signAndEncrypt(signcryptElement, aliceSelf, Collections.singleton(bobForAlice));
        OpenPgpMessage decrypted = bobProvider.decryptAndOrVerify(encrypted.getElement(), bobSelf, aliceForBob);
        OpenPgpV4Fingerprint decryptionFingerprint = decrypted.getMetadata().getDecryptionFingerprint();
        TestCase.assertTrue((boolean)bobSelf.getSecretKeys().contains(decryptionFingerprint.getKeyId()));
        TestCase.assertTrue((boolean)decrypted.getMetadata().getVerifiedSignatureKeyFingerprints().contains(aliceFingerprint));
        TestCase.assertEquals((Object)OpenPgpMessage.State.signcrypt, (Object)decrypted.getState());
        SigncryptElement decryptedSignCrypt = (SigncryptElement)decrypted.getOpenPgpContentElement();
        TestCase.assertEquals((String)body.getMessage(), (String)((Message.Body)decryptedSignCrypt.getExtension("body", "jabber:client")).getMessage());
        CryptElement cryptElement = new CryptElement(Collections.singleton(bob), payload);
        encrypted = aliceProvider.encrypt(cryptElement, aliceSelf, Collections.singleton(bobForAlice));
        decrypted = bobProvider.decryptAndOrVerify(encrypted.getElement(), bobSelf, aliceForBob);
        decryptionFingerprint = decrypted.getMetadata().getDecryptionFingerprint();
        TestCase.assertTrue((boolean)bobSelf.getSecretKeys().contains(decryptionFingerprint.getKeyId()));
        TestCase.assertTrue((boolean)decrypted.getMetadata().getVerifiedSignatureKeyFingerprints().isEmpty());
        TestCase.assertEquals((Object)OpenPgpMessage.State.crypt, (Object)decrypted.getState());
        CryptElement decryptedCrypt = (CryptElement)decrypted.getOpenPgpContentElement();
        TestCase.assertEquals((String)body.getMessage(), (String)((Message.Body)decryptedCrypt.getExtension("body", "jabber:client")).getMessage());
        SignElement signElement = new SignElement(Collections.singleton(bob), new Date(), payload);
        encrypted = aliceProvider.sign(signElement, aliceSelf);
        decrypted = bobProvider.decryptAndOrVerify(encrypted.getElement(), bobSelf, aliceForBob);
        TestCase.assertNull((Object)decrypted.getMetadata().getDecryptionFingerprint());
        TestCase.assertTrue((boolean)decrypted.getMetadata().getVerifiedSignatureKeyFingerprints().contains(aliceFingerprint));
        TestCase.assertEquals((Object)OpenPgpMessage.State.sign, (Object)decrypted.getState());
        SignElement decryptedSign = (SignElement)decrypted.getOpenPgpContentElement();
        TestCase.assertEquals((String)body.getMessage(), (String)((Message.Body)decryptedSign.getExtension("body", "jabber:client")).getMessage());
    }

    static {
        alice = JidTestUtil.BARE_JID_1;
        bob = JidTestUtil.BARE_JID_2;
        storagePath = new File(FileUtils.getTempDirectory(), "smack-painlessprovidertest");
    }
}

