/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.ox;

import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import junit.framework.TestCase;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.test.util.SmackTestSuite;
import org.jivesoftware.smack.test.util.SmackTestUtil;
import org.jivesoftware.smack.test.util.XmlUnitUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.ox.element.PubkeyElement;
import org.jivesoftware.smackx.ox.provider.PubkeyElementProvider;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.jxmpp.util.XmppDateTime;

public class PubkeyElementTest
extends SmackTestSuite {
    @ParameterizedTest
    @EnumSource(value=SmackTestUtil.XmlPullParserKind.class)
    public void providerTest(SmackTestUtil.XmlPullParserKind parserKind) throws ParseException, XmlPullParserException, IOException, SmackParsingException {
        String base64EncodedOpenPgpPublicKey = "VGhpcyBpcyBqdXN0IGEgdGVzdA==";
        String pubkeyElement = "<pubkey xmlns='urn:xmpp:openpgp:0' date='2018-01-21T10:46:21.000+00:00'><data>" + base64EncodedOpenPgpPublicKey + "</data></pubkey>";
        Date date = XmppDateTime.parseXEP0082Date((String)"2018-01-21T10:46:21.000+00:00");
        PubkeyElement element = new PubkeyElement(new PubkeyElement.PubkeyDataElement(base64EncodedOpenPgpPublicKey), date);
        XmlUnitUtils.assertXmlSimilar((CharSequence)pubkeyElement, (CharSequence)element.toXML().toString());
        XmlPullParser parser = SmackTestUtil.getParserFor((String)pubkeyElement, (SmackTestUtil.XmlPullParserKind)parserKind);
        PubkeyElement parsed = (PubkeyElement)PubkeyElementProvider.INSTANCE.parse(parser);
        TestCase.assertEquals((Object)element.getDate(), (Object)parsed.getDate());
        TestCase.assertEquals((String)element.getDataElement().getB64Data(), (String)parsed.getDataElement().getB64Data());
    }
}

