/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.ox;

import java.util.Date;
import junit.framework.TestCase;
import org.bouncycastle.openpgp.PGPException;
import org.jivesoftware.smack.test.util.SmackTestSuite;
import org.jivesoftware.smack.test.util.TestUtils;
import org.jivesoftware.smack.test.util.XmlUnitUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smackx.ox.element.PublicKeysListElement;
import org.jivesoftware.smackx.ox.provider.PublicKeysListElementProvider;
import org.junit.jupiter.api.Test;
import org.jxmpp.util.XmppDateTime;
import org.pgpainless.key.OpenPgpV4Fingerprint;

public class PublicKeysListElementTest
extends SmackTestSuite {
    @Test
    public void providerTest() throws Exception {
        String expected = "<public-keys-list xmlns='urn:xmpp:openpgp:0'><pubkey-metadata v4-fingerprint='1357B01865B2503C18453D208CAC2A9678548E35' date='2018-03-01T15:26:12.000+00:00'/><pubkey-metadata v4-fingerprint='67819B343B2AB70DED9320872C6464AF2A8E4C02' date='1953-05-16T12:00:00.000+00:00'/></public-keys-list>";
        Date date1 = XmppDateTime.parseDate((String)"2018-03-01T15:26:12.000+00:00");
        Date date2 = XmppDateTime.parseDate((String)"1953-05-16T12:00:00.000+00:00");
        PublicKeysListElement.PubkeyMetadataElement child1 = new PublicKeysListElement.PubkeyMetadataElement(new OpenPgpV4Fingerprint("1357B01865B2503C18453D208CAC2A9678548E35"), date1);
        PublicKeysListElement.PubkeyMetadataElement child2 = new PublicKeysListElement.PubkeyMetadataElement(new OpenPgpV4Fingerprint("67819B343B2AB70DED9320872C6464AF2A8E4C02"), date2);
        PublicKeysListElement element = PublicKeysListElement.builder().addMetadata(child1).addMetadata(child2).build();
        XmlUnitUtils.assertXmlSimilar((CharSequence)expected, (CharSequence)element.toXML().toString());
        XmlPullParser parser = TestUtils.getParser((String)expected);
        PublicKeysListElement parsed = (PublicKeysListElement)PublicKeysListElementProvider.TEST_INSTANCE.parse(parser);
        TestCase.assertEquals((Object)element.getMetadata(), (Object)parsed.getMetadata());
    }

    @Test
    public void listBuilderRefusesDuplicatesTest() throws PGPException {
        PublicKeysListElement.Builder builder = PublicKeysListElement.builder();
        String fp40 = "49545320414c4c2041424f555420444120484558";
        Date oneDate = new Date(12337883234L);
        Date otherDate = new Date(8888348384L);
        builder.addMetadata(new PublicKeysListElement.PubkeyMetadataElement(new OpenPgpV4Fingerprint(fp40), oneDate));
        TestCase.assertEquals((int)builder.build().getMetadata().size(), (int)1);
        builder.addMetadata(new PublicKeysListElement.PubkeyMetadataElement(new OpenPgpV4Fingerprint(fp40), otherDate));
        TestCase.assertEquals((int)builder.build().getMetadata().size(), (int)1);
    }
}

