/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.ox_im;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.bouncycastle.openpgp.PGPException;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.chat2.ChatManager;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.MessageBuilder;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.eme.element.ExplicitMessageEncryptionElement;
import org.jivesoftware.smackx.hints.element.StoreHint;
import org.jivesoftware.smackx.ox.OpenPgpContact;
import org.jivesoftware.smackx.ox.OpenPgpManager;
import org.jivesoftware.smackx.ox.OpenPgpMessage;
import org.jivesoftware.smackx.ox.OpenPgpSelf;
import org.jivesoftware.smackx.ox.crypto.OpenPgpElementAndMetadata;
import org.jivesoftware.smackx.ox.element.OpenPgpElement;
import org.jivesoftware.smackx.ox.element.SigncryptElement;
import org.jivesoftware.smackx.ox.listener.SigncryptElementReceivedListener;
import org.jivesoftware.smackx.ox_im.OxMessageListener;
import org.jxmpp.jid.BareJid;
import org.jxmpp.jid.Jid;
import org.pgpainless.decryption_verification.OpenPgpMetadata;

public final class OXInstantMessagingManager
extends Manager {
    public static final String NAMESPACE_0 = "urn:xmpp:openpgp:im:0";
    private static final Map<XMPPConnection, OXInstantMessagingManager> INSTANCES = new WeakHashMap<XMPPConnection, OXInstantMessagingManager>();
    private final Set<OxMessageListener> oxMessageListeners = new HashSet<OxMessageListener>();
    private final OpenPgpManager openPgpManager;
    private final SigncryptElementReceivedListener signcryptElementReceivedListener = new SigncryptElementReceivedListener(){

        @Override
        public void signcryptElementReceived(OpenPgpContact contact, Message originalMessage, SigncryptElement signcryptElement, OpenPgpMetadata metadata) {
            for (OxMessageListener listener : OXInstantMessagingManager.this.oxMessageListeners) {
                listener.newIncomingOxMessage(contact, originalMessage, signcryptElement, metadata);
            }
        }
    };

    private OXInstantMessagingManager(XMPPConnection connection) {
        super(connection);
        this.openPgpManager = OpenPgpManager.getInstanceFor(connection);
        this.openPgpManager.registerSigncryptReceivedListener(this.signcryptElementReceivedListener);
        this.announceSupportForOxInstantMessaging();
    }

    public static synchronized OXInstantMessagingManager getInstanceFor(XMPPConnection connection) {
        OXInstantMessagingManager manager = INSTANCES.get(connection);
        if (manager == null) {
            manager = new OXInstantMessagingManager(connection);
            INSTANCES.put(connection, manager);
        }
        return manager;
    }

    public void announceSupportForOxInstantMessaging() {
        ServiceDiscoveryManager.getInstanceFor((XMPPConnection)this.connection()).addFeature(NAMESPACE_0);
    }

    public boolean contactSupportsOxInstantMessaging(BareJid jid) throws XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, SmackException.NoResponseException {
        return ServiceDiscoveryManager.getInstanceFor((XMPPConnection)this.connection()).supportsFeature((Jid)jid, (CharSequence)NAMESPACE_0);
    }

    public boolean contactSupportsOxInstantMessaging(OpenPgpContact contact) throws XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, SmackException.NoResponseException {
        return this.contactSupportsOxInstantMessaging(contact.getJid());
    }

    public boolean addOxMessageListener(OxMessageListener listener) {
        return this.oxMessageListeners.add(listener);
    }

    public boolean removeOxMessageListener(OxMessageListener listener) {
        return this.oxMessageListeners.remove(listener);
    }

    public OpenPgpMetadata sendOxMessage(OpenPgpContact contact, CharSequence body) throws InterruptedException, IOException, SmackException.NotConnectedException, SmackException.NotLoggedInException, PGPException {
        MessageBuilder messageBuilder = (MessageBuilder)this.connection().getStanzaFactory().buildMessageStanza().to((Jid)contact.getJid());
        Message.Body mBody = new Message.Body(null, body.toString());
        OpenPgpMetadata metadata = this.addOxMessage(messageBuilder, contact, Collections.singletonList(mBody));
        Message message = messageBuilder.build();
        ChatManager.getInstanceFor((XMPPConnection)this.connection()).chatWith(contact.getJid().asEntityBareJidIfPossible()).send(message);
        return metadata;
    }

    public OpenPgpMetadata addOxMessage(MessageBuilder messageBuilder, OpenPgpContact contact, List<ExtensionElement> payload) throws SmackException.NotLoggedInException, PGPException, IOException {
        return this.addOxMessage(messageBuilder, Collections.singleton(contact), payload);
    }

    public OpenPgpMetadata addOxMessage(MessageBuilder messageBuilder, Set<OpenPgpContact> contacts, List<ExtensionElement> payload) throws SmackException.NotLoggedInException, IOException, PGPException {
        HashSet<OpenPgpContact> recipients = new HashSet<OpenPgpContact>(contacts);
        OpenPgpSelf self = this.openPgpManager.getOpenPgpSelf();
        recipients.add(self);
        OpenPgpElementAndMetadata openPgpElementAndMetadata = this.signAndEncrypt(recipients, payload);
        messageBuilder.addExtension((ExtensionElement)openPgpElementAndMetadata.getElement());
        ExplicitMessageEncryptionElement.set((MessageBuilder)messageBuilder, (ExplicitMessageEncryptionElement.ExplicitMessageEncryptionProtocol)ExplicitMessageEncryptionElement.ExplicitMessageEncryptionProtocol.openpgpV0);
        StoreHint.set((MessageBuilder)messageBuilder);
        OXInstantMessagingManager.setOXBodyHint(messageBuilder);
        return openPgpElementAndMetadata.getMetadata();
    }

    public OpenPgpElementAndMetadata signAndEncrypt(Set<OpenPgpContact> contacts, List<ExtensionElement> payload) throws SmackException.NotLoggedInException, IOException, PGPException {
        HashSet<BareJid> jids = new HashSet<BareJid>();
        for (OpenPgpContact contact : contacts) {
            jids.add(contact.getJid());
        }
        jids.add(this.openPgpManager.getOpenPgpSelf().getJid());
        SigncryptElement signcryptElement = new SigncryptElement(jids, payload);
        OpenPgpElementAndMetadata encrypted = this.openPgpManager.getOpenPgpProvider().signAndEncrypt(signcryptElement, this.openPgpManager.getOpenPgpSelf(), contacts);
        return encrypted;
    }

    public OpenPgpMessage decryptAndVerify(OpenPgpElement element, OpenPgpContact sender) throws SmackException.NotLoggedInException, PGPException, IOException, XmlPullParserException {
        OpenPgpMessage decrypted = this.openPgpManager.decryptOpenPgpElement(element, sender);
        if (decrypted.getState() != OpenPgpMessage.State.signcrypt) {
            throw new IllegalArgumentException("Decrypted message does appear to not be an OX message. (State: " + (Object)((Object)decrypted.getState()) + ")");
        }
        return decrypted;
    }

    private static void setOXBodyHint(MessageBuilder message) {
        message.setBody("This message is encrypted using XEP-0374: OpenPGP for XMPP: Instant Messaging.");
    }
}

