/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.ox.crypto;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.util.io.Streams;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.stringencoder.Base64;
import org.jivesoftware.smackx.ox.OpenPgpContact;
import org.jivesoftware.smackx.ox.OpenPgpMessage;
import org.jivesoftware.smackx.ox.OpenPgpSelf;
import org.jivesoftware.smackx.ox.crypto.OpenPgpElementAndMetadata;
import org.jivesoftware.smackx.ox.crypto.OpenPgpProvider;
import org.jivesoftware.smackx.ox.element.CryptElement;
import org.jivesoftware.smackx.ox.element.OpenPgpElement;
import org.jivesoftware.smackx.ox.element.SignElement;
import org.jivesoftware.smackx.ox.element.SigncryptElement;
import org.jivesoftware.smackx.ox.store.definition.OpenPgpStore;
import org.pgpainless.PGPainless;
import org.pgpainless.decryption_verification.DecryptionStream;
import org.pgpainless.decryption_verification.MissingPublicKeyCallback;
import org.pgpainless.decryption_verification.OpenPgpMetadata;
import org.pgpainless.encryption_signing.EncryptionStream;

public class PainlessOpenPgpProvider
implements OpenPgpProvider {
    private static final Logger LOGGER = Logger.getLogger(PainlessOpenPgpProvider.class.getName());
    private final XMPPConnection connection;
    private final OpenPgpStore store;

    public PainlessOpenPgpProvider(XMPPConnection connection, OpenPgpStore store) {
        this.connection = (XMPPConnection)Objects.requireNonNull((Object)connection);
        this.store = (OpenPgpStore)Objects.requireNonNull((Object)store);
    }

    @Override
    public OpenPgpStore getStore() {
        return this.store;
    }

    @Override
    public OpenPgpElementAndMetadata signAndEncrypt(SigncryptElement element, OpenPgpSelf self, Collection<OpenPgpContact> recipients) throws IOException, PGPException {
        InputStream plainText = element.toInputStream();
        ByteArrayOutputStream cipherText = new ByteArrayOutputStream();
        ArrayList<PGPPublicKeyRingCollection> recipientKeys = new ArrayList<PGPPublicKeyRingCollection>();
        for (OpenPgpContact contact : recipients) {
            PGPPublicKeyRingCollection keys = contact.getTrustedAnnouncedKeys();
            if (keys != null) {
                recipientKeys.add(keys);
                continue;
            }
            LOGGER.log(Level.WARNING, "There are no suitable keys for contact " + contact.getJid().toString());
        }
        EncryptionStream cipherStream = PGPainless.createEncryptor().onOutputStream((OutputStream)cipherText).toRecipients(recipientKeys.toArray(new PGPPublicKeyRingCollection[0])).andToSelf(self.getTrustedAnnouncedKeys()).usingSecureAlgorithms().signWith(this.getStore().getKeyRingProtector(), new PGPSecretKeyRing[]{self.getSigningKeyRing()}).noArmor();
        Streams.pipeAll((InputStream)plainText, (OutputStream)cipherStream);
        plainText.close();
        cipherStream.flush();
        cipherStream.close();
        cipherText.close();
        String base64 = Base64.encodeToString((byte[])cipherText.toByteArray());
        OpenPgpElement openPgpElement = new OpenPgpElement(base64);
        return new OpenPgpElementAndMetadata(openPgpElement, cipherStream.getResult());
    }

    @Override
    public OpenPgpElementAndMetadata sign(SignElement element, OpenPgpSelf self) throws IOException, PGPException {
        InputStream plainText = element.toInputStream();
        ByteArrayOutputStream cipherText = new ByteArrayOutputStream();
        EncryptionStream cipherStream = PGPainless.createEncryptor().onOutputStream((OutputStream)cipherText).doNotEncrypt().signWith(this.getStore().getKeyRingProtector(), new PGPSecretKeyRing[]{self.getSigningKeyRing()}).noArmor();
        Streams.pipeAll((InputStream)plainText, (OutputStream)cipherStream);
        plainText.close();
        cipherStream.flush();
        cipherStream.close();
        cipherText.close();
        String base64 = Base64.encodeToString((byte[])cipherText.toByteArray());
        OpenPgpElement openPgpElement = new OpenPgpElement(base64);
        return new OpenPgpElementAndMetadata(openPgpElement, cipherStream.getResult());
    }

    @Override
    public OpenPgpElementAndMetadata encrypt(CryptElement element, OpenPgpSelf self, Collection<OpenPgpContact> recipients) throws IOException, PGPException {
        InputStream plainText = element.toInputStream();
        ByteArrayOutputStream cipherText = new ByteArrayOutputStream();
        ArrayList<PGPPublicKeyRingCollection> recipientKeys = new ArrayList<PGPPublicKeyRingCollection>();
        for (OpenPgpContact contact : recipients) {
            PGPPublicKeyRingCollection keys = contact.getTrustedAnnouncedKeys();
            if (keys != null) {
                recipientKeys.add(keys);
                continue;
            }
            LOGGER.log(Level.WARNING, "There are no suitable keys for contact " + contact.getJid().toString());
        }
        EncryptionStream cipherStream = PGPainless.createEncryptor().onOutputStream((OutputStream)cipherText).toRecipients(recipientKeys.toArray(new PGPPublicKeyRingCollection[0])).andToSelf(self.getTrustedAnnouncedKeys()).usingSecureAlgorithms().doNotSign().noArmor();
        Streams.pipeAll((InputStream)plainText, (OutputStream)cipherStream);
        plainText.close();
        cipherStream.flush();
        cipherStream.close();
        cipherText.close();
        String base64 = Base64.encodeToString((byte[])cipherText.toByteArray());
        OpenPgpElement openPgpElement = new OpenPgpElement(base64);
        return new OpenPgpElementAndMetadata(openPgpElement, cipherStream.getResult());
    }

    @Override
    public OpenPgpMessage decryptAndOrVerify(OpenPgpElement element, OpenPgpSelf self, final OpenPgpContact sender) throws IOException, PGPException {
        OpenPgpMessage.State state;
        ByteArrayOutputStream plainText = new ByteArrayOutputStream();
        InputStream cipherText = element.toInputStream();
        PGPPublicKeyRingCollection announcedPublicKeys = sender.getAnnouncedPublicKeys();
        if (announcedPublicKeys == null) {
            LOGGER.log(Level.INFO, "Received a message from " + sender.getJid() + " but we have no keys yet. Try fetching them.");
            try {
                sender.updateKeys(this.connection);
                announcedPublicKeys = sender.getAnnouncedPublicKeys();
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Fetching keys of " + sender.getJid() + " failed. Abort decryption and discard message.", e);
                throw new PGPException("Abort decryption due to lack of keys.", e);
            }
        }
        MissingPublicKeyCallback missingPublicKeyCallback = new MissingPublicKeyCallback(){

            public PGPPublicKey onMissingPublicKeyEncountered(Long keyId) {
                try {
                    sender.updateKeys(PainlessOpenPgpProvider.this.connection);
                    return sender.getAnyPublicKeys().getPublicKey(keyId.longValue());
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Cannot fetch missing key " + keyId, e);
                    return null;
                }
            }
        };
        DecryptionStream cipherStream = PGPainless.createDecryptor().onInputStream(cipherText).decryptWith(this.getStore().getKeyRingProtector(), self.getSecretKeys()).verifyWith(announcedPublicKeys).handleMissingPublicKeysWith(missingPublicKeyCallback).build();
        Streams.pipeAll((InputStream)cipherStream, (OutputStream)plainText);
        cipherText.close();
        cipherStream.close();
        plainText.close();
        OpenPgpMetadata info = cipherStream.getResult();
        if (info.isSigned()) {
            state = info.isEncrypted() ? OpenPgpMessage.State.signcrypt : OpenPgpMessage.State.sign;
        } else if (info.isEncrypted()) {
            state = OpenPgpMessage.State.crypt;
        } else {
            throw new PGPException("Received message appears to be neither encrypted, nor signed.");
        }
        return new OpenPgpMessage(plainText.toByteArray(), state, info);
    }
}

