/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.ox.store.abstr;

import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smackx.ox.OpenPgpContact;
import org.jivesoftware.smackx.ox.callback.SecretKeyPassphraseCallback;
import org.jivesoftware.smackx.ox.exception.MissingUserIdOnKeyException;
import org.jivesoftware.smackx.ox.store.definition.OpenPgpKeyStore;
import org.jivesoftware.smackx.ox.store.definition.OpenPgpMetadataStore;
import org.jivesoftware.smackx.ox.store.definition.OpenPgpStore;
import org.jivesoftware.smackx.ox.store.definition.OpenPgpTrustStore;
import org.jxmpp.jid.BareJid;
import org.pgpainless.key.OpenPgpV4Fingerprint;
import org.pgpainless.key.collection.PGPKeyRing;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.protection.UnprotectedKeysProtector;

public abstract class AbstractOpenPgpStore
implements OpenPgpStore {
    protected final OpenPgpKeyStore keyStore;
    protected final OpenPgpMetadataStore metadataStore;
    protected final OpenPgpTrustStore trustStore;
    protected SecretKeyPassphraseCallback secretKeyPassphraseCallback;
    protected SecretKeyRingProtector unlocker = new UnprotectedKeysProtector();
    protected final Map<BareJid, OpenPgpContact> contacts = new HashMap<BareJid, OpenPgpContact>();

    @Override
    public void deletePublicKeyRing(BareJid owner, OpenPgpV4Fingerprint fingerprint) throws IOException, PGPException {
        this.keyStore.deletePublicKeyRing(owner, fingerprint);
    }

    @Override
    public void deleteSecretKeyRing(BareJid owner, OpenPgpV4Fingerprint fingerprint) throws IOException, PGPException {
        this.keyStore.deleteSecretKeyRing(owner, fingerprint);
    }

    protected AbstractOpenPgpStore(OpenPgpKeyStore keyStore, OpenPgpMetadataStore metadataStore, OpenPgpTrustStore trustStore) {
        this.keyStore = (OpenPgpKeyStore)Objects.requireNonNull((Object)keyStore);
        this.metadataStore = (OpenPgpMetadataStore)Objects.requireNonNull((Object)metadataStore);
        this.trustStore = (OpenPgpTrustStore)Objects.requireNonNull((Object)trustStore);
    }

    @Override
    public OpenPgpContact getOpenPgpContact(BareJid jid) {
        OpenPgpContact contact = this.contacts.get(jid);
        if (contact == null) {
            contact = new OpenPgpContact(jid, this);
            this.contacts.put(jid, contact);
        }
        return contact;
    }

    @Override
    public void setKeyRingProtector(SecretKeyRingProtector protector) {
        this.unlocker = protector;
    }

    @Override
    public SecretKeyRingProtector getKeyRingProtector() {
        return this.unlocker;
    }

    @Override
    public void setSecretKeyPassphraseCallback(SecretKeyPassphraseCallback callback) {
        this.secretKeyPassphraseCallback = callback;
    }

    @Override
    public PGPPublicKeyRingCollection getPublicKeysOf(BareJid owner) throws IOException, PGPException {
        return this.keyStore.getPublicKeysOf(owner);
    }

    @Override
    public PGPSecretKeyRingCollection getSecretKeysOf(BareJid owner) throws IOException, PGPException {
        return this.keyStore.getSecretKeysOf(owner);
    }

    @Override
    public PGPPublicKeyRing getPublicKeyRing(BareJid owner, OpenPgpV4Fingerprint fingerprint) throws IOException, PGPException {
        return this.keyStore.getPublicKeyRing(owner, fingerprint);
    }

    @Override
    public PGPSecretKeyRing getSecretKeyRing(BareJid owner, OpenPgpV4Fingerprint fingerprint) throws IOException, PGPException {
        return this.keyStore.getSecretKeyRing(owner, fingerprint);
    }

    @Override
    public PGPKeyRing generateKeyRing(BareJid owner) throws PGPException, NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException {
        return this.keyStore.generateKeyRing(owner);
    }

    @Override
    public void importSecretKey(BareJid owner, PGPSecretKeyRing secretKeys) throws IOException, PGPException, MissingUserIdOnKeyException {
        this.keyStore.importSecretKey(owner, secretKeys);
    }

    @Override
    public void importPublicKey(BareJid owner, PGPPublicKeyRing publicKeys) throws IOException, PGPException, MissingUserIdOnKeyException {
        this.keyStore.importPublicKey(owner, publicKeys);
    }

    @Override
    public Map<OpenPgpV4Fingerprint, Date> getPublicKeyFetchDates(BareJid contact) throws IOException {
        return this.keyStore.getPublicKeyFetchDates(contact);
    }

    @Override
    public void setPublicKeyFetchDates(BareJid contact, Map<OpenPgpV4Fingerprint, Date> dates) throws IOException {
        this.keyStore.setPublicKeyFetchDates(contact, dates);
    }

    @Override
    public Map<OpenPgpV4Fingerprint, Date> getAnnouncedFingerprintsOf(BareJid contact) throws IOException {
        return this.metadataStore.getAnnouncedFingerprintsOf(contact);
    }

    @Override
    public void setAnnouncedFingerprintsOf(BareJid contact, Map<OpenPgpV4Fingerprint, Date> data) throws IOException {
        this.metadataStore.setAnnouncedFingerprintsOf(contact, data);
    }

    @Override
    public OpenPgpTrustStore.Trust getTrust(BareJid owner, OpenPgpV4Fingerprint fingerprint) throws IOException {
        return this.trustStore.getTrust(owner, fingerprint);
    }

    @Override
    public void setTrust(BareJid owner, OpenPgpV4Fingerprint fingerprint, OpenPgpTrustStore.Trust trust) throws IOException {
        this.trustStore.setTrust(owner, fingerprint, trust);
    }
}

