/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.ox;

import java.io.File;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Arrays;
import java.util.Collections;
import junit.framework.TestCase;
import org.apache.commons.io.FileUtils;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.jivesoftware.smack.test.util.SmackTestSuite;
import org.jivesoftware.smackx.ox.crypto.OpenPgpProvider;
import org.jivesoftware.smackx.ox.crypto.PainlessOpenPgpProvider;
import org.jivesoftware.smackx.ox.element.SecretkeyElement;
import org.jivesoftware.smackx.ox.exception.InvalidBackupCodeException;
import org.jivesoftware.smackx.ox.exception.MissingOpenPgpKeyException;
import org.jivesoftware.smackx.ox.exception.MissingUserIdOnKeyException;
import org.jivesoftware.smackx.ox.store.definition.OpenPgpStore;
import org.jivesoftware.smackx.ox.store.filebased.FileBasedOpenPgpStore;
import org.jivesoftware.smackx.ox.util.SecretKeyBackupHelper;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.jupiter.api.Test;
import org.jxmpp.jid.BareJid;
import org.jxmpp.jid.impl.JidCreate;
import org.pgpainless.PGPainless;
import org.pgpainless.key.OpenPgpV4Fingerprint;
import org.pgpainless.key.collection.PGPKeyRing;

public class SecretKeyBackupHelperTest
extends SmackTestSuite {
    private static final File basePath = new File(FileUtils.getTempDirectory(), "ox_secret_keys");

    @Test
    public void backupPasswordGenerationTest() {
        String alphabet = "123456789ABCDEFGHIJKLMNPQRSTUVWXYZ";
        String backupCode = SecretKeyBackupHelper.generateBackupPassword();
        TestCase.assertEquals((int)29, (int)backupCode.length());
        for (int i = 0; i < backupCode.length(); ++i) {
            if ((i + 1) % 5 == 0) {
                TestCase.assertEquals((char)'-', (char)backupCode.charAt(i));
                continue;
            }
            TestCase.assertTrue(("123456789ABCDEFGHIJKLMNPQRSTUVWXYZ".indexOf(backupCode.charAt(i)) != -1 ? 1 : 0) != 0);
        }
    }

    @Test
    public void createAndDecryptSecretKeyElementTest() throws PGPException, NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException, IOException, MissingUserIdOnKeyException, MissingOpenPgpKeyException, InvalidBackupCodeException {
        FileBasedOpenPgpStore store = new FileBasedOpenPgpStore(basePath);
        PainlessOpenPgpProvider provider = new PainlessOpenPgpProvider((OpenPgpStore)store);
        PGPKeyRing keyRing = PGPainless.generateKeyRing().simpleEcKeyRing("xmpp:alice@wonderland.lit");
        BareJid jid = JidCreate.bareFrom((String)"alice@wonderland.lit");
        provider.getStore().importSecretKey(jid, keyRing.getSecretKeys());
        String backupCode = SecretKeyBackupHelper.generateBackupPassword();
        SecretkeyElement element = SecretKeyBackupHelper.createSecretkeyElement((OpenPgpProvider)provider, (BareJid)jid, Collections.singleton(new OpenPgpV4Fingerprint(keyRing.getSecretKeys())), (String)backupCode);
        PGPSecretKeyRing secretKeyRing = SecretKeyBackupHelper.restoreSecretKeyBackup((SecretkeyElement)element, (String)backupCode);
        TestCase.assertTrue((boolean)Arrays.equals(keyRing.getSecretKeys().getEncoded(), secretKeyRing.getEncoded()));
    }

    @AfterClass
    @BeforeClass
    public static void deleteDirs() throws IOException {
        FileUtils.deleteDirectory((File)basePath);
    }
}

