/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.ox_im;

import java.io.File;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Collections;
import java.util.Date;
import junit.framework.TestCase;
import org.apache.commons.io.FileUtils;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.jivesoftware.smack.DummyConnection;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.MessageBuilder;
import org.jivesoftware.smack.packet.MessageView;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StanzaBuilder;
import org.jivesoftware.smack.test.util.SmackTestSuite;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.eme.element.ExplicitMessageEncryptionElement;
import org.jivesoftware.smackx.ox.OpenPgpContact;
import org.jivesoftware.smackx.ox.OpenPgpManager;
import org.jivesoftware.smackx.ox.OpenPgpMessage;
import org.jivesoftware.smackx.ox.OpenPgpSelf;
import org.jivesoftware.smackx.ox.crypto.OpenPgpProvider;
import org.jivesoftware.smackx.ox.crypto.PainlessOpenPgpProvider;
import org.jivesoftware.smackx.ox.element.OpenPgpElement;
import org.jivesoftware.smackx.ox.element.SigncryptElement;
import org.jivesoftware.smackx.ox.exception.MissingUserIdOnKeyException;
import org.jivesoftware.smackx.ox.store.definition.OpenPgpStore;
import org.jivesoftware.smackx.ox.store.filebased.FileBasedOpenPgpStore;
import org.jivesoftware.smackx.ox_im.OXInstantMessagingManager;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.jupiter.api.Test;
import org.jxmpp.jid.EntityBareJid;
import org.pgpainless.decryption_verification.OpenPgpMetadata;

public class OXInstantMessagingManagerTest
extends SmackTestSuite {
    private static final File basePath = new File(FileUtils.getTempDirectory(), "ox_im_test_" + StringUtils.randomString((int)10));

    @Test
    public void test() throws IOException, PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException, SmackException, MissingUserIdOnKeyException, InterruptedException, XMPPException, XmlPullParserException {
        DummyConnection aliceCon = new DummyConnection();
        aliceCon.connect().login();
        DummyConnection bobCon = new DummyConnection();
        bobCon.connect().login();
        FileBasedOpenPgpStore aliceStore = new FileBasedOpenPgpStore(new File(basePath, "alice"));
        FileBasedOpenPgpStore bobStore = new FileBasedOpenPgpStore(new File(basePath, "bob"));
        PainlessOpenPgpProvider aliceProvider = new PainlessOpenPgpProvider((OpenPgpStore)aliceStore);
        PainlessOpenPgpProvider bobProvider = new PainlessOpenPgpProvider((OpenPgpStore)bobStore);
        OpenPgpManager aliceOpenPgp = OpenPgpManager.getInstanceFor((XMPPConnection)aliceCon);
        OpenPgpManager bobOpenPgp = OpenPgpManager.getInstanceFor((XMPPConnection)bobCon);
        aliceOpenPgp.setOpenPgpProvider((OpenPgpProvider)aliceProvider);
        bobOpenPgp.setOpenPgpProvider((OpenPgpProvider)bobProvider);
        OXInstantMessagingManager aliceOxim = OXInstantMessagingManager.getInstanceFor((XMPPConnection)aliceCon);
        OpenPgpSelf aliceSelf = aliceOpenPgp.getOpenPgpSelf();
        OpenPgpSelf bobSelf = bobOpenPgp.getOpenPgpSelf();
        TestCase.assertFalse((boolean)aliceSelf.hasSecretKeyAvailable());
        TestCase.assertFalse((boolean)bobSelf.hasSecretKeyAvailable());
        aliceOpenPgp.generateAndImportKeyPair(aliceSelf.getJid());
        bobOpenPgp.generateAndImportKeyPair(bobSelf.getJid());
        TestCase.assertTrue((boolean)aliceSelf.hasSecretKeyAvailable());
        TestCase.assertTrue((boolean)bobSelf.hasSecretKeyAvailable());
        TestCase.assertTrue((boolean)aliceSelf.isTrusted(aliceSelf.getSigningKeyFingerprint()));
        TestCase.assertTrue((boolean)bobSelf.isTrusted(bobSelf.getSigningKeyFingerprint()));
        TestCase.assertTrue((boolean)aliceSelf.getTrustedFingerprints().contains(aliceSelf.getSigningKeyFingerprint()));
        aliceStore.importPublicKey(bobSelf.getJid(), (PGPPublicKeyRing)bobSelf.getAnnouncedPublicKeys().iterator().next());
        bobStore.importPublicKey(aliceSelf.getJid(), (PGPPublicKeyRing)aliceSelf.getAnnouncedPublicKeys().iterator().next());
        bobStore.setAnnouncedFingerprintsOf(bobSelf.getJid(), Collections.singletonMap(bobSelf.getSigningKeyFingerprint(), new Date()));
        bobStore.setAnnouncedFingerprintsOf(aliceSelf.getJid(), Collections.singletonMap(aliceSelf.getSigningKeyFingerprint(), new Date()));
        aliceStore.setAnnouncedFingerprintsOf(aliceSelf.getJid(), Collections.singletonMap(aliceSelf.getSigningKeyFingerprint(), new Date()));
        aliceStore.setAnnouncedFingerprintsOf(bobSelf.getJid(), Collections.singletonMap(bobSelf.getSigningKeyFingerprint(), new Date()));
        OpenPgpContact aliceForBob = bobOpenPgp.getOpenPgpContact((EntityBareJid)aliceSelf.getJid());
        OpenPgpContact bobForAlice = aliceOpenPgp.getOpenPgpContact((EntityBareJid)bobSelf.getJid());
        TestCase.assertTrue((boolean)aliceForBob.hasUndecidedKeys());
        TestCase.assertTrue((boolean)bobForAlice.hasUndecidedKeys());
        TestCase.assertTrue((boolean)aliceForBob.getUndecidedFingerprints().contains(aliceSelf.getSigningKeyFingerprint()));
        TestCase.assertTrue((boolean)bobForAlice.getUndecidedFingerprints().contains(bobSelf.getSigningKeyFingerprint()));
        bobForAlice.trust(bobSelf.getSigningKeyFingerprint());
        aliceForBob.trust(aliceSelf.getSigningKeyFingerprint());
        TestCase.assertFalse((boolean)aliceForBob.hasUndecidedKeys());
        TestCase.assertFalse((boolean)bobForAlice.hasUndecidedKeys());
        MessageBuilder messageBuilder = StanzaBuilder.buildMessage();
        TestCase.assertFalse((boolean)ExplicitMessageEncryptionElement.hasProtocol((MessageView)messageBuilder.build(), (ExplicitMessageEncryptionElement.ExplicitMessageEncryptionProtocol)ExplicitMessageEncryptionElement.ExplicitMessageEncryptionProtocol.openpgpV0));
        aliceOxim.addOxMessage(messageBuilder, bobForAlice, Collections.singletonList(new Message.Body(null, "Hello World!")));
        Message message = messageBuilder.build();
        TestCase.assertTrue((boolean)ExplicitMessageEncryptionElement.hasProtocol((MessageView)message, (ExplicitMessageEncryptionElement.ExplicitMessageEncryptionProtocol)ExplicitMessageEncryptionElement.ExplicitMessageEncryptionProtocol.openpgpV0));
        TestCase.assertNotNull((Object)OpenPgpElement.fromStanza((Stanza)message));
        OpenPgpMessage decrypted = bobOpenPgp.decryptOpenPgpElement(OpenPgpElement.fromStanza((Stanza)message), aliceForBob);
        TestCase.assertEquals((Object)OpenPgpMessage.State.signcrypt, (Object)decrypted.getState());
        SigncryptElement signcryptElement = (SigncryptElement)decrypted.getOpenPgpContentElement();
        Message.Body body = (Message.Body)signcryptElement.getExtension("body", "jabber:client");
        TestCase.assertNotNull((Object)body);
        TestCase.assertEquals((String)"Hello World!", (String)body.getMessage());
        OpenPgpMetadata metadata = decrypted.getMetadata();
        TestCase.assertTrue((metadata.isSigned() && metadata.isEncrypted() ? 1 : 0) != 0);
        TestCase.assertNotNull((Object)bobSelf.getSigningKeyRing().getPublicKey(metadata.getDecryptionFingerprint().getKeyId()));
        TestCase.assertTrue((boolean)metadata.containsVerifiedSignatureFrom((PGPPublicKeyRing)aliceForBob.getTrustedAnnouncedKeys().iterator().next()));
    }

    @AfterClass
    @BeforeClass
    public static void deleteDirs() throws IOException {
        FileUtils.deleteDirectory((File)basePath);
    }
}

