/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.ox;

import java.io.File;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.commons.io.FileUtils;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.jivesoftware.smack.test.util.SmackTestSuite;
import org.jivesoftware.smackx.ox.OpenPgpContact;
import org.jivesoftware.smackx.ox.callback.SecretKeyPassphraseCallback;
import org.jivesoftware.smackx.ox.exception.MissingUserIdOnKeyException;
import org.jivesoftware.smackx.ox.store.definition.OpenPgpStore;
import org.jivesoftware.smackx.ox.store.definition.OpenPgpTrustStore;
import org.jivesoftware.smackx.ox.store.filebased.FileBasedOpenPgpStore;
import org.junit.After;
import org.junit.Before;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.junit.runner.RunWith;
import org.junit.runners.MethodSorters;
import org.junit.runners.Parameterized;
import org.jxmpp.jid.BareJid;
import org.jxmpp.jid.JidTestUtil;
import org.pgpainless.key.OpenPgpV4Fingerprint;
import org.pgpainless.key.collection.PGPKeyRing;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.protection.UnprotectedKeysProtector;
import org.pgpainless.util.Passphrase;

@RunWith(value=Parameterized.class)
@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class OpenPgpStoreTest
extends SmackTestSuite {
    private static final File storagePath;
    private static final BareJid alice;
    private static final BareJid bob;
    private static final OpenPgpV4Fingerprint finger1;
    private static final OpenPgpV4Fingerprint finger2;
    private static final OpenPgpV4Fingerprint finger3;
    private final OpenPgpStore openPgpStoreInstance1;
    private final OpenPgpStore openPgpStoreInstance2;

    @Parameterized.Parameters
    public static Collection<OpenPgpStore[]> data() {
        return Arrays.asList(new OpenPgpStore[][]{{new FileBasedOpenPgpStore(storagePath), new FileBasedOpenPgpStore(storagePath)}});
    }

    public OpenPgpStoreTest(OpenPgpStore firstInstance, OpenPgpStore secondInstance) {
        if (firstInstance == secondInstance || !firstInstance.getClass().equals(secondInstance.getClass())) {
            throw new IllegalArgumentException("firstInstance must be another instance of the same class as secondInstance.");
        }
        this.openPgpStoreInstance1 = firstInstance;
        this.openPgpStoreInstance2 = secondInstance;
    }

    @Before
    @After
    public void deletePath() throws IOException {
        FileUtils.deleteDirectory((File)storagePath);
    }

    @Test
    public void t00_store_protectorGetSet() {
        this.openPgpStoreInstance1.setKeyRingProtector((SecretKeyRingProtector)new UnprotectedKeysProtector());
        TestCase.assertNotNull((Object)this.openPgpStoreInstance1.getKeyRingProtector());
        this.openPgpStoreInstance1.setSecretKeyPassphraseCallback(new SecretKeyPassphraseCallback(){

            public Passphrase onPassphraseNeeded(OpenPgpV4Fingerprint fingerprint) {
                return null;
            }
        });
    }

    @Test
    public void t00_deleteTest() throws IOException, PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException, MissingUserIdOnKeyException {
        TestCase.assertNull((Object)this.openPgpStoreInstance1.getSecretKeysOf(alice));
        TestCase.assertNull((Object)this.openPgpStoreInstance1.getPublicKeysOf(alice));
        PGPKeyRing keys = this.openPgpStoreInstance1.generateKeyRing(alice);
        this.openPgpStoreInstance1.importSecretKey(alice, keys.getSecretKeys());
        this.openPgpStoreInstance1.importPublicKey(alice, keys.getPublicKeys());
        TestCase.assertNotNull((Object)this.openPgpStoreInstance1.getSecretKeysOf(alice));
        TestCase.assertNotNull((Object)this.openPgpStoreInstance1.getPublicKeysOf(alice));
        this.openPgpStoreInstance1.deleteSecretKeyRing(alice, new OpenPgpV4Fingerprint(keys.getSecretKeys()));
        this.openPgpStoreInstance1.deletePublicKeyRing(alice, new OpenPgpV4Fingerprint(keys.getSecretKeys()));
        TestCase.assertNull((Object)this.openPgpStoreInstance1.getPublicKeysOf(alice));
        TestCase.assertNull((Object)this.openPgpStoreInstance1.getSecretKeysOf(alice));
    }

    @Test
    public void t01_key_emptyStoreTest() throws IOException, PGPException {
        TestCase.assertNull((Object)this.openPgpStoreInstance1.getPublicKeysOf(alice));
        TestCase.assertNull((Object)this.openPgpStoreInstance1.getSecretKeysOf(alice));
        TestCase.assertNull((Object)this.openPgpStoreInstance1.getPublicKeyRing(alice, finger1));
        TestCase.assertNull((Object)this.openPgpStoreInstance1.getSecretKeyRing(alice, finger1));
    }

    @Test
    public void t02_key_importKeysTest() throws IOException, PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException, MissingUserIdOnKeyException {
        PGPKeyRing keys = this.openPgpStoreInstance1.generateKeyRing(alice);
        PGPSecretKeyRing secretKeys = keys.getSecretKeys();
        PGPPublicKeyRing publicKeys = keys.getPublicKeys();
        TestCase.assertNotNull((Object)secretKeys);
        TestCase.assertNotNull((Object)publicKeys);
        OpenPgpContact cAlice = this.openPgpStoreInstance1.getOpenPgpContact(alice);
        TestCase.assertNull((Object)cAlice.getAnyPublicKeys());
        OpenPgpV4Fingerprint fingerprint = new OpenPgpV4Fingerprint(publicKeys);
        TestCase.assertEquals((Object)fingerprint, (Object)new OpenPgpV4Fingerprint(secretKeys));
        TestCase.assertNull((Object)this.openPgpStoreInstance1.getPublicKeysOf(alice));
        TestCase.assertNull((Object)this.openPgpStoreInstance1.getSecretKeysOf(alice));
        this.openPgpStoreInstance1.importPublicKey(alice, publicKeys);
        TestCase.assertTrue((boolean)Arrays.equals(publicKeys.getEncoded(), this.openPgpStoreInstance1.getPublicKeysOf(alice).getEncoded()));
        TestCase.assertNotNull((Object)this.openPgpStoreInstance1.getPublicKeyRing(alice, fingerprint));
        TestCase.assertNull((Object)this.openPgpStoreInstance1.getSecretKeysOf(alice));
        cAlice = this.openPgpStoreInstance1.getOpenPgpContact(alice);
        TestCase.assertNotNull((Object)cAlice.getAnyPublicKeys());
        this.openPgpStoreInstance1.importPublicKey(alice, publicKeys);
        TestCase.assertTrue((boolean)Arrays.equals(publicKeys.getEncoded(), this.openPgpStoreInstance1.getPublicKeysOf(alice).getEncoded()));
        this.openPgpStoreInstance1.importSecretKey(alice, secretKeys);
        TestCase.assertTrue((boolean)Arrays.equals(secretKeys.getEncoded(), this.openPgpStoreInstance1.getSecretKeysOf(alice).getEncoded()));
        this.openPgpStoreInstance1.importSecretKey(alice, secretKeys);
        TestCase.assertNotNull((Object)this.openPgpStoreInstance1.getSecretKeysOf(alice));
        TestCase.assertTrue((boolean)Arrays.equals(secretKeys.getEncoded(), this.openPgpStoreInstance1.getSecretKeysOf(alice).getEncoded()));
        TestCase.assertNotNull((Object)this.openPgpStoreInstance1.getSecretKeyRing(alice, fingerprint));
        TestCase.assertTrue((boolean)Arrays.equals(secretKeys.getEncoded(), this.openPgpStoreInstance1.getSecretKeyRing(alice, fingerprint).getEncoded()));
        TestCase.assertTrue((boolean)Arrays.equals(publicKeys.getEncoded(), this.openPgpStoreInstance1.getPublicKeyRing(alice, fingerprint).getEncoded()));
        this.openPgpStoreInstance1.deletePublicKeyRing(alice, fingerprint);
        this.openPgpStoreInstance1.deleteSecretKeyRing(alice, fingerprint);
    }

    @Test
    public void t04_key_wrongBareJidOnSecretKeyImportTest() throws PGPException, NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException, IOException, MissingUserIdOnKeyException {
        PGPSecretKeyRing secretKeys = this.openPgpStoreInstance1.generateKeyRing(alice).getSecretKeys();
        Assertions.assertThrows(MissingUserIdOnKeyException.class, () -> this.openPgpStoreInstance1.importSecretKey(bob, secretKeys));
    }

    @Test
    public void t05_key_wrongBareJidOnPublicKeyImportTest() throws PGPException, NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException, IOException, MissingUserIdOnKeyException {
        PGPPublicKeyRing publicKeys = this.openPgpStoreInstance1.generateKeyRing(alice).getPublicKeys();
        Assertions.assertThrows(MissingUserIdOnKeyException.class, () -> this.openPgpStoreInstance1.importPublicKey(bob, publicKeys));
    }

    @Test
    public void t06_key_keyReloadTest() throws PGPException, NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException, IOException, MissingUserIdOnKeyException {
        PGPKeyRing keys = this.openPgpStoreInstance1.generateKeyRing(alice);
        PGPSecretKeyRing secretKeys = keys.getSecretKeys();
        OpenPgpV4Fingerprint fingerprint = new OpenPgpV4Fingerprint(secretKeys);
        PGPPublicKeyRing publicKeys = keys.getPublicKeys();
        this.openPgpStoreInstance1.importSecretKey(alice, secretKeys);
        this.openPgpStoreInstance1.importPublicKey(alice, publicKeys);
        TestCase.assertNotNull((Object)this.openPgpStoreInstance2.getSecretKeysOf(alice));
        TestCase.assertNotNull((Object)this.openPgpStoreInstance2.getPublicKeysOf(alice));
        this.openPgpStoreInstance1.deletePublicKeyRing(alice, fingerprint);
        this.openPgpStoreInstance1.deleteSecretKeyRing(alice, fingerprint);
        this.openPgpStoreInstance2.deletePublicKeyRing(alice, fingerprint);
        this.openPgpStoreInstance2.deleteSecretKeyRing(alice, fingerprint);
    }

    @Test
    public void t07_multipleKeysTest() throws PGPException, NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException, IOException, MissingUserIdOnKeyException {
        PGPKeyRing one = this.openPgpStoreInstance1.generateKeyRing(alice);
        PGPKeyRing two = this.openPgpStoreInstance1.generateKeyRing(alice);
        OpenPgpV4Fingerprint fingerprint1 = new OpenPgpV4Fingerprint(one.getSecretKeys());
        OpenPgpV4Fingerprint fingerprint2 = new OpenPgpV4Fingerprint(two.getSecretKeys());
        this.openPgpStoreInstance1.importSecretKey(alice, one.getSecretKeys());
        this.openPgpStoreInstance1.importSecretKey(alice, two.getSecretKeys());
        this.openPgpStoreInstance1.importPublicKey(alice, one.getPublicKeys());
        this.openPgpStoreInstance1.importPublicKey(alice, two.getPublicKeys());
        TestCase.assertTrue((boolean)Arrays.equals(one.getSecretKeys().getEncoded(), this.openPgpStoreInstance1.getSecretKeyRing(alice, fingerprint1).getEncoded()));
        TestCase.assertTrue((boolean)Arrays.equals(two.getSecretKeys().getEncoded(), this.openPgpStoreInstance1.getSecretKeyRing(alice, fingerprint2).getEncoded()));
        TestCase.assertTrue((boolean)Arrays.equals(one.getSecretKeys().getEncoded(), this.openPgpStoreInstance1.getSecretKeysOf(alice).getSecretKeyRing(fingerprint1.getKeyId()).getEncoded()));
        TestCase.assertTrue((boolean)Arrays.equals(one.getPublicKeys().getEncoded(), this.openPgpStoreInstance1.getPublicKeyRing(alice, fingerprint1).getEncoded()));
        this.openPgpStoreInstance1.deletePublicKeyRing(alice, fingerprint1);
        this.openPgpStoreInstance1.deletePublicKeyRing(alice, fingerprint2);
        this.openPgpStoreInstance1.deleteSecretKeyRing(alice, fingerprint1);
        this.openPgpStoreInstance1.deleteSecretKeyRing(alice, fingerprint2);
    }

    @Test
    public void t08_trust_emptyStoreTest() throws IOException {
        TestCase.assertEquals((Object)OpenPgpTrustStore.Trust.undecided, (Object)this.openPgpStoreInstance1.getTrust(alice, finger2));
        this.openPgpStoreInstance1.setTrust(alice, finger2, OpenPgpTrustStore.Trust.trusted);
        TestCase.assertEquals((Object)OpenPgpTrustStore.Trust.trusted, (Object)this.openPgpStoreInstance1.getTrust(alice, finger2));
        this.openPgpStoreInstance1.setTrust(alice, finger2, OpenPgpTrustStore.Trust.trusted);
        TestCase.assertEquals((Object)OpenPgpTrustStore.Trust.trusted, (Object)this.openPgpStoreInstance1.getTrust(alice, finger2));
        TestCase.assertEquals((Object)OpenPgpTrustStore.Trust.undecided, (Object)this.openPgpStoreInstance1.getTrust(alice, finger3));
        this.openPgpStoreInstance1.setTrust(bob, finger2, OpenPgpTrustStore.Trust.untrusted);
        TestCase.assertEquals((Object)OpenPgpTrustStore.Trust.untrusted, (Object)this.openPgpStoreInstance1.getTrust(bob, finger2));
        TestCase.assertEquals((Object)OpenPgpTrustStore.Trust.trusted, (Object)this.openPgpStoreInstance1.getTrust(alice, finger2));
        this.openPgpStoreInstance1.setTrust(alice, finger2, OpenPgpTrustStore.Trust.undecided);
        this.openPgpStoreInstance1.setTrust(bob, finger2, OpenPgpTrustStore.Trust.undecided);
    }

    @Test
    public void t09_trust_reloadTest() throws IOException {
        this.openPgpStoreInstance1.setTrust(alice, finger1, OpenPgpTrustStore.Trust.trusted);
        TestCase.assertEquals((Object)OpenPgpTrustStore.Trust.trusted, (Object)this.openPgpStoreInstance2.getTrust(alice, finger1));
        this.openPgpStoreInstance1.setTrust(alice, finger1, OpenPgpTrustStore.Trust.undecided);
        this.openPgpStoreInstance2.setTrust(alice, finger1, OpenPgpTrustStore.Trust.undecided);
    }

    @Test
    public void t10_meta_emptyStoreTest() throws IOException {
        TestCase.assertNotNull((Object)this.openPgpStoreInstance1.getAnnouncedFingerprintsOf(alice));
        TestCase.assertTrue((boolean)this.openPgpStoreInstance1.getAnnouncedFingerprintsOf(alice).isEmpty());
        HashMap<OpenPgpV4Fingerprint, Date> map = new HashMap<OpenPgpV4Fingerprint, Date>();
        Date date1 = new Date(12354563423L);
        Date date2 = new Date(8274729879812L);
        map.put(finger1, date1);
        map.put(finger2, date2);
        this.openPgpStoreInstance1.setAnnouncedFingerprintsOf(alice, map);
        TestCase.assertFalse((boolean)this.openPgpStoreInstance1.getAnnouncedFingerprintsOf(alice).isEmpty());
        TestCase.assertEquals(map, (Object)this.openPgpStoreInstance1.getAnnouncedFingerprintsOf(alice));
        TestCase.assertTrue((boolean)this.openPgpStoreInstance1.getAnnouncedFingerprintsOf(bob).isEmpty());
        TestCase.assertFalse((boolean)this.openPgpStoreInstance2.getAnnouncedFingerprintsOf(alice).isEmpty());
        TestCase.assertEquals(map, (Object)this.openPgpStoreInstance2.getAnnouncedFingerprintsOf(alice));
        this.openPgpStoreInstance1.setAnnouncedFingerprintsOf(alice, Collections.emptyMap());
        this.openPgpStoreInstance2.setAnnouncedFingerprintsOf(alice, Collections.emptyMap());
    }

    @Test
    public void t11_key_fetchDateTest() throws IOException {
        Map fetchDates1 = this.openPgpStoreInstance1.getPublicKeyFetchDates(alice);
        TestCase.assertNotNull((Object)fetchDates1);
        TestCase.assertTrue((boolean)fetchDates1.isEmpty());
        Date date1 = new Date(85092830954L);
        fetchDates1.put(finger1, date1);
        this.openPgpStoreInstance1.setPublicKeyFetchDates(alice, fetchDates1);
        Map fetchDates2 = this.openPgpStoreInstance1.getPublicKeyFetchDates(alice);
        TestCase.assertNotNull((Object)fetchDates2);
        TestCase.assertFalse((boolean)fetchDates2.isEmpty());
        TestCase.assertEquals((Object)fetchDates1, (Object)fetchDates2);
        Map fetchDates3 = this.openPgpStoreInstance2.getPublicKeyFetchDates(alice);
        TestCase.assertNotNull((Object)fetchDates3);
        TestCase.assertEquals((Object)fetchDates1, (Object)fetchDates3);
        this.openPgpStoreInstance1.setPublicKeyFetchDates(alice, null);
        this.openPgpStoreInstance2.setPublicKeyFetchDates(alice, null);
        TestCase.assertNotNull((Object)this.openPgpStoreInstance1.getPublicKeyFetchDates(alice));
        TestCase.assertTrue((boolean)this.openPgpStoreInstance1.getPublicKeyFetchDates(alice).isEmpty());
    }

    static {
        alice = JidTestUtil.BARE_JID_1;
        bob = JidTestUtil.BARE_JID_2;
        finger1 = new OpenPgpV4Fingerprint("DEADBEEFDEADBEEFDEADBEEFDEADBEEFDEADBEEF");
        finger2 = new OpenPgpV4Fingerprint("C0FFEEC0FFEEC0FFEEC0FFEEC0FFEEC0FFEE1234");
        finger3 = new OpenPgpV4Fingerprint("0123012301230123012301230123012301230123");
        storagePath = new File(FileUtils.getTempDirectory(), "storeTest");
    }
}

