/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.ox;

import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.util.stringencoder.Base64;
import org.jivesoftware.smackx.ox.element.PubkeyElement;
import org.jivesoftware.smackx.ox.element.PublicKeysListElement;
import org.jivesoftware.smackx.ox.exception.MissingUserIdOnKeyException;
import org.jivesoftware.smackx.ox.store.definition.OpenPgpStore;
import org.jivesoftware.smackx.ox.store.definition.OpenPgpTrustStore;
import org.jivesoftware.smackx.ox.util.OpenPgpPubSubUtil;
import org.jivesoftware.smackx.pubsub.PubSubException;
import org.jxmpp.jid.BareJid;
import org.pgpainless.key.OpenPgpV4Fingerprint;
import org.pgpainless.key.info.KeyRingInfo;

public class OpenPgpContact {
    private final Logger LOGGER;
    protected final BareJid jid;
    protected final OpenPgpStore store;
    protected final Map<OpenPgpV4Fingerprint, Throwable> unfetchableKeys = new HashMap<OpenPgpV4Fingerprint, Throwable>();

    public OpenPgpContact(BareJid jid, OpenPgpStore store) {
        this.jid = jid;
        this.store = store;
        this.LOGGER = Logger.getLogger(OpenPgpContact.class.getName() + ":" + jid.toString());
    }

    public BareJid getJid() {
        return this.jid;
    }

    public PGPPublicKeyRingCollection getAnyPublicKeys() throws IOException, PGPException {
        return this.store.getPublicKeysOf(this.jid);
    }

    public PGPPublicKeyRingCollection getAnnouncedPublicKeys() throws IOException, PGPException {
        PGPPublicKeyRingCollection anyKeys = this.getAnyPublicKeys();
        Map<OpenPgpV4Fingerprint, Date> announced = this.store.getAnnouncedFingerprintsOf(this.jid);
        PGPPublicKeyRingCollection announcedKeysCollection = null;
        for (OpenPgpV4Fingerprint announcedFingerprint : announced.keySet()) {
            PGPPublicKeyRing ring = anyKeys.getPublicKeyRing(announcedFingerprint.getKeyId());
            if (ring == null) continue;
            if (!new KeyRingInfo((PGPKeyRing)ring).isUserIdValid("xmpp:" + this.getJid().toString())) {
                this.LOGGER.log(Level.WARNING, "Ignore key " + Long.toHexString(ring.getPublicKey().getKeyID()) + " as it lacks the user-id \"xmpp" + this.getJid().toString() + "\"");
                continue;
            }
            if (announcedKeysCollection == null) {
                announcedKeysCollection = new PGPPublicKeyRingCollection(Collections.singleton(ring));
                continue;
            }
            announcedKeysCollection = PGPPublicKeyRingCollection.addPublicKeyRing(announcedKeysCollection, (PGPPublicKeyRing)ring);
        }
        return announcedKeysCollection;
    }

    protected PGPPublicKeyRingCollection getPublicKeysOfTrustState(PGPPublicKeyRingCollection keys, OpenPgpTrustStore.Trust trust) throws IOException {
        if (keys == null) {
            return null;
        }
        HashSet<PGPPublicKeyRing> toRemove = new HashSet<PGPPublicKeyRing>();
        for (PGPPublicKeyRing ring : keys) {
            OpenPgpV4Fingerprint fingerprint = new OpenPgpV4Fingerprint(ring);
            if (this.store.getTrust(this.getJid(), fingerprint) == trust) continue;
            toRemove.add(ring);
        }
        for (PGPPublicKeyRing ring : toRemove) {
            keys = PGPPublicKeyRingCollection.removePublicKeyRing((PGPPublicKeyRingCollection)keys, (PGPPublicKeyRing)ring);
        }
        if (!keys.iterator().hasNext()) {
            return null;
        }
        return keys;
    }

    public PGPPublicKeyRingCollection getTrustedAnnouncedKeys() throws IOException, PGPException {
        PGPPublicKeyRingCollection announced = this.getAnnouncedPublicKeys();
        PGPPublicKeyRingCollection trusted = this.getPublicKeysOfTrustState(announced, OpenPgpTrustStore.Trust.trusted);
        return trusted;
    }

    public Set<OpenPgpV4Fingerprint> getTrustedFingerprints() throws IOException, PGPException {
        return this.getFingerprintsOfKeysWithState(this.getAnyPublicKeys(), OpenPgpTrustStore.Trust.trusted);
    }

    public Set<OpenPgpV4Fingerprint> getUntrustedFingerprints() throws IOException, PGPException {
        return this.getFingerprintsOfKeysWithState(this.getAnyPublicKeys(), OpenPgpTrustStore.Trust.untrusted);
    }

    public Set<OpenPgpV4Fingerprint> getUndecidedFingerprints() throws IOException, PGPException {
        return this.getFingerprintsOfKeysWithState(this.getAnyPublicKeys(), OpenPgpTrustStore.Trust.undecided);
    }

    public Set<OpenPgpV4Fingerprint> getFingerprintsOfKeysWithState(PGPPublicKeyRingCollection publicKeys, OpenPgpTrustStore.Trust trust) throws IOException {
        PGPPublicKeyRingCollection keys = this.getPublicKeysOfTrustState(publicKeys, trust);
        HashSet<OpenPgpV4Fingerprint> fingerprints = new HashSet<OpenPgpV4Fingerprint>();
        if (keys == null) {
            return fingerprints;
        }
        for (PGPPublicKeyRing ring : keys) {
            fingerprints.add(new OpenPgpV4Fingerprint(ring));
        }
        return fingerprints;
    }

    public OpenPgpTrustStore.Trust getTrust(OpenPgpV4Fingerprint fingerprint) throws IOException {
        return this.store.getTrust(this.getJid(), fingerprint);
    }

    public boolean isTrusted(OpenPgpV4Fingerprint fingerprint) throws IOException {
        return this.getTrust(fingerprint) == OpenPgpTrustStore.Trust.trusted;
    }

    public void trust(OpenPgpV4Fingerprint fingerprint) throws IOException {
        this.store.setTrust(this.getJid(), fingerprint, OpenPgpTrustStore.Trust.trusted);
    }

    public void distrust(OpenPgpV4Fingerprint fingerprint) throws IOException {
        this.store.setTrust(this.getJid(), fingerprint, OpenPgpTrustStore.Trust.untrusted);
    }

    public boolean hasUndecidedKeys() throws IOException, PGPException {
        return this.getUndecidedFingerprints().size() != 0;
    }

    public Map<OpenPgpV4Fingerprint, Throwable> getUnfetchableKeys() {
        return new HashMap<OpenPgpV4Fingerprint, Throwable>(this.unfetchableKeys);
    }

    public void updateKeys(XMPPConnection connection) throws InterruptedException, SmackException.NotConnectedException, SmackException.NoResponseException, XMPPException.XMPPErrorException, PubSubException.NotALeafNodeException, PubSubException.NotAPubSubNodeException, IOException {
        PublicKeysListElement metadata = OpenPgpPubSubUtil.fetchPubkeysList(connection, this.getJid());
        if (metadata == null) {
            return;
        }
        this.updateKeys(connection, metadata);
    }

    public void updateKeys(XMPPConnection connection, PublicKeysListElement metadata) throws InterruptedException, SmackException.NotConnectedException, SmackException.NoResponseException, IOException {
        HashMap<OpenPgpV4Fingerprint, Date> fingerprintsAndDates = new HashMap<OpenPgpV4Fingerprint, Date>();
        for (OpenPgpV4Fingerprint fingerprint : metadata.getMetadata().keySet()) {
            fingerprintsAndDates.put(fingerprint, metadata.getMetadata().get(fingerprint).getDate());
        }
        this.store.setAnnouncedFingerprintsOf(this.getJid(), fingerprintsAndDates);
        Map<OpenPgpV4Fingerprint, Date> fetchDates = this.store.getPublicKeyFetchDates(this.getJid());
        for (OpenPgpV4Fingerprint fingerprint : metadata.getMetadata().keySet()) {
            Date fetchDate = fetchDates.get(fingerprint);
            if (fetchDate != null && fingerprintsAndDates.get(fingerprint) != null && fetchDate.after((Date)fingerprintsAndDates.get(fingerprint))) {
                this.LOGGER.log(Level.FINE, "Skip key " + Long.toHexString(fingerprint.getKeyId()) + " as we already have the most recent version. Last announced: " + ((Date)fingerprintsAndDates.get(fingerprint)).toString() + " Last fetched: " + fetchDate.toString());
                continue;
            }
            try {
                PubkeyElement key = OpenPgpPubSubUtil.fetchPubkey(connection, this.getJid(), fingerprint);
                this.unfetchableKeys.remove(fingerprint);
                fetchDates.put(fingerprint, new Date());
                if (key == null) {
                    this.LOGGER.log(Level.WARNING, "Public key " + Long.toHexString(fingerprint.getKeyId()) + " can not be imported: Is null");
                    this.unfetchableKeys.put(fingerprint, new NullPointerException("Public key is null."));
                    continue;
                }
                PGPPublicKeyRing keyRing = new PGPPublicKeyRing(Base64.decode((String)key.getDataElement().getB64Data()), (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
                this.store.importPublicKey(this.getJid(), keyRing);
            }
            catch (XMPPException.XMPPErrorException | PubSubException.NotALeafNodeException | PubSubException.NotAPubSubNodeException e) {
                this.LOGGER.log(Level.WARNING, "Error fetching public key " + Long.toHexString(fingerprint.getKeyId()), e);
                this.unfetchableKeys.put(fingerprint, e);
            }
            catch (IOException | PGPException e) {
                this.LOGGER.log(Level.WARNING, "Public key " + Long.toHexString(fingerprint.getKeyId()) + " can not be imported.", e);
                this.unfetchableKeys.put(fingerprint, e);
            }
            catch (MissingUserIdOnKeyException e) {
                this.LOGGER.log(Level.WARNING, "Public key " + Long.toHexString(fingerprint.getKeyId()) + " is missing the user-id \"xmpp:" + this.getJid() + "\". Refuse to import it.", e);
                this.unfetchableKeys.put(fingerprint, e);
            }
        }
        this.store.setPublicKeyFetchDates(this.getJid(), fetchDates);
    }
}

