/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.ox.crypto;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.util.io.Streams;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.stringencoder.Base64;
import org.jivesoftware.smackx.ox.OpenPgpContact;
import org.jivesoftware.smackx.ox.OpenPgpMessage;
import org.jivesoftware.smackx.ox.OpenPgpSelf;
import org.jivesoftware.smackx.ox.crypto.OpenPgpElementAndMetadata;
import org.jivesoftware.smackx.ox.crypto.OpenPgpProvider;
import org.jivesoftware.smackx.ox.element.CryptElement;
import org.jivesoftware.smackx.ox.element.OpenPgpElement;
import org.jivesoftware.smackx.ox.element.SignElement;
import org.jivesoftware.smackx.ox.element.SigncryptElement;
import org.jivesoftware.smackx.ox.store.definition.OpenPgpStore;
import org.jivesoftware.smackx.pubsub.PubSubException;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.DocumentSignatureType;
import org.pgpainless.decryption_verification.ConsumerOptions;
import org.pgpainless.decryption_verification.DecryptionStream;
import org.pgpainless.decryption_verification.MissingPublicKeyCallback;
import org.pgpainless.decryption_verification.OpenPgpMetadata;
import org.pgpainless.encryption_signing.EncryptionOptions;
import org.pgpainless.encryption_signing.EncryptionStream;
import org.pgpainless.encryption_signing.ProducerOptions;
import org.pgpainless.encryption_signing.SigningOptions;

public class PainlessOpenPgpProvider
implements OpenPgpProvider {
    private static final Logger LOGGER = Logger.getLogger(PainlessOpenPgpProvider.class.getName());
    private final OpenPgpStore store;

    public PainlessOpenPgpProvider(OpenPgpStore store) {
        this.store = (OpenPgpStore)Objects.requireNonNull((Object)store);
    }

    @Override
    public OpenPgpStore getStore() {
        return this.store;
    }

    @Override
    public OpenPgpElementAndMetadata signAndEncrypt(SigncryptElement element, OpenPgpSelf self, Collection<OpenPgpContact> recipients) throws IOException, PGPException {
        InputStream plainText = element.toInputStream();
        ByteArrayOutputStream cipherText = new ByteArrayOutputStream();
        EncryptionOptions encOpts = EncryptionOptions.encryptCommunications();
        for (OpenPgpContact contact : recipients) {
            PGPPublicKeyRingCollection keys = contact.getTrustedAnnouncedKeys();
            if (keys == null) {
                LOGGER.log(Level.WARNING, "There are no suitable keys for contact " + contact.getJid());
            }
            encOpts.addRecipients(keys);
        }
        encOpts.addRecipients(self.getTrustedAnnouncedKeys());
        SigningOptions signOpts = new SigningOptions();
        signOpts.addInlineSignature(this.getStore().getKeyRingProtector(), self.getSigningKeyRing(), DocumentSignatureType.BINARY_DOCUMENT);
        EncryptionStream cipherStream = PGPainless.encryptAndOrSign().onOutputStream((OutputStream)cipherText).withOptions(ProducerOptions.signAndEncrypt((EncryptionOptions)encOpts, (SigningOptions)signOpts).setAsciiArmor(false));
        Streams.pipeAll((InputStream)plainText, (OutputStream)cipherStream);
        plainText.close();
        cipherStream.flush();
        cipherStream.close();
        cipherText.close();
        String base64 = Base64.encodeToString((byte[])cipherText.toByteArray());
        OpenPgpElement openPgpElement = new OpenPgpElement(base64);
        return new OpenPgpElementAndMetadata(openPgpElement, cipherStream.getResult());
    }

    @Override
    public OpenPgpElementAndMetadata sign(SignElement element, OpenPgpSelf self) throws IOException, PGPException {
        InputStream plainText = element.toInputStream();
        ByteArrayOutputStream cipherText = new ByteArrayOutputStream();
        EncryptionStream cipherStream = PGPainless.encryptAndOrSign().onOutputStream((OutputStream)cipherText).withOptions(ProducerOptions.sign((SigningOptions)new SigningOptions().addInlineSignature(this.getStore().getKeyRingProtector(), self.getSigningKeyRing(), "xmpp:" + self.getJid().toString(), DocumentSignatureType.BINARY_DOCUMENT)).setAsciiArmor(false));
        Streams.pipeAll((InputStream)plainText, (OutputStream)cipherStream);
        plainText.close();
        cipherStream.flush();
        cipherStream.close();
        cipherText.close();
        String base64 = Base64.encodeToString((byte[])cipherText.toByteArray());
        OpenPgpElement openPgpElement = new OpenPgpElement(base64);
        return new OpenPgpElementAndMetadata(openPgpElement, cipherStream.getResult());
    }

    @Override
    public OpenPgpElementAndMetadata encrypt(CryptElement element, OpenPgpSelf self, Collection<OpenPgpContact> recipients) throws IOException, PGPException {
        InputStream plainText = element.toInputStream();
        ByteArrayOutputStream cipherText = new ByteArrayOutputStream();
        EncryptionOptions encOpts = EncryptionOptions.encryptCommunications();
        for (OpenPgpContact contact : recipients) {
            PGPPublicKeyRingCollection keys = contact.getTrustedAnnouncedKeys();
            if (keys == null) {
                LOGGER.log(Level.WARNING, "There are no suitable keys for contact " + contact.getJid());
            }
            encOpts.addRecipients(keys);
        }
        encOpts.addRecipients(self.getTrustedAnnouncedKeys());
        EncryptionStream cipherStream = PGPainless.encryptAndOrSign().onOutputStream((OutputStream)cipherText).withOptions(ProducerOptions.encrypt((EncryptionOptions)encOpts).setAsciiArmor(false));
        Streams.pipeAll((InputStream)plainText, (OutputStream)cipherStream);
        plainText.close();
        cipherStream.flush();
        cipherStream.close();
        cipherText.close();
        String base64 = Base64.encodeToString((byte[])cipherText.toByteArray());
        OpenPgpElement openPgpElement = new OpenPgpElement(base64);
        return new OpenPgpElementAndMetadata(openPgpElement, cipherStream.getResult());
    }

    @Override
    public OpenPgpMessage decryptAndOrVerify(final XMPPConnection connection, OpenPgpElement element, OpenPgpSelf self, final OpenPgpContact sender) throws IOException, PGPException {
        OpenPgpMessage.State state;
        ByteArrayOutputStream plainText = new ByteArrayOutputStream();
        InputStream cipherText = element.toInputStream();
        PGPPublicKeyRingCollection announcedPublicKeys = sender.getAnnouncedPublicKeys();
        if (announcedPublicKeys == null) {
            try {
                sender.updateKeys(connection);
                announcedPublicKeys = sender.getAnnouncedPublicKeys();
            }
            catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException.XMPPErrorException | PubSubException.NotALeafNodeException | PubSubException.NotAPubSubNodeException e) {
                throw new PGPException("Abort decryption due to lack of keys", (Exception)e);
            }
        }
        MissingPublicKeyCallback missingPublicKeyCallback = new MissingPublicKeyCallback(){

            public PGPPublicKeyRing onMissingPublicKeyEncountered(Long keyId) {
                try {
                    sender.updateKeys(connection);
                    PGPPublicKeyRingCollection anyKeys = sender.getAnyPublicKeys();
                    for (PGPPublicKeyRing ring : anyKeys) {
                        if (ring.getPublicKey(keyId.longValue()) == null) continue;
                        return ring;
                    }
                    return null;
                }
                catch (IOException | InterruptedException | PGPException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException.XMPPErrorException | PubSubException.NotALeafNodeException | PubSubException.NotAPubSubNodeException e) {
                    LOGGER.log(Level.WARNING, "Cannot fetch missing key " + keyId, e);
                    return null;
                }
            }
        };
        DecryptionStream cipherStream = PGPainless.decryptAndOrVerify().onInputStream(cipherText).withOptions(new ConsumerOptions().addDecryptionKeys(self.getSecretKeys(), this.getStore().getKeyRingProtector()).addVerificationCerts(announcedPublicKeys).setMissingCertificateCallback(missingPublicKeyCallback));
        Streams.pipeAll((InputStream)cipherStream, (OutputStream)plainText);
        cipherText.close();
        cipherStream.close();
        plainText.close();
        OpenPgpMetadata info = cipherStream.getResult();
        if (info.isSigned()) {
            state = info.isEncrypted() ? OpenPgpMessage.State.signcrypt : OpenPgpMessage.State.sign;
        } else if (info.isEncrypted()) {
            state = OpenPgpMessage.State.crypt;
        } else {
            throw new PGPException("Received message appears to be neither encrypted, nor signed.");
        }
        return new OpenPgpMessage(plainText.toByteArray(), state, info);
    }
}

