/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.ox.store.filebased;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.util.CloseableUtil;
import org.jivesoftware.smack.util.FileUtils;
import org.jivesoftware.smackx.ox.store.abstr.AbstractOpenPgpMetadataStore;
import org.jivesoftware.smackx.ox.store.filebased.FileBasedOpenPgpStore;
import org.jivesoftware.smackx.ox.util.Util;
import org.jxmpp.jid.BareJid;
import org.jxmpp.util.XmppDateTime;
import org.pgpainless.key.OpenPgpV4Fingerprint;

public class FileBasedOpenPgpMetadataStore
extends AbstractOpenPgpMetadataStore {
    public static final String ANNOUNCED = "announced.list";
    private static final Logger LOGGER = Logger.getLogger(FileBasedOpenPgpMetadataStore.class.getName());
    private final File basePath;

    public FileBasedOpenPgpMetadataStore(File basePath) {
        this.basePath = basePath;
    }

    @Override
    public Map<OpenPgpV4Fingerprint, Date> readAnnouncedFingerprintsOf(BareJid contact) throws IOException {
        return FileBasedOpenPgpMetadataStore.readFingerprintsAndDates(this.getAnnouncedFingerprintsPath(contact));
    }

    @Override
    public void writeAnnouncedFingerprintsOf(BareJid contact, Map<OpenPgpV4Fingerprint, Date> metadata) throws IOException {
        File destination = this.getAnnouncedFingerprintsPath(contact);
        FileBasedOpenPgpMetadataStore.writeFingerprintsAndDates(metadata, destination);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map<OpenPgpV4Fingerprint, Date> readFingerprintsAndDates(File source) throws IOException {
        HashMap<OpenPgpV4Fingerprint, Date> hashMap;
        if (!source.exists() || source.isDirectory()) {
            return new HashMap<OpenPgpV4Fingerprint, Date>();
        }
        BufferedReader reader = null;
        try {
            String line;
            FileInputStream inputStream = FileUtils.prepareFileInputStream((File)source);
            InputStreamReader isr = new InputStreamReader((InputStream)inputStream, Util.UTF8);
            reader = new BufferedReader(isr);
            HashMap<OpenPgpV4Fingerprint, Date> fingerprintDateMap = new HashMap<OpenPgpV4Fingerprint, Date>();
            int lineNr = 0;
            while ((line = reader.readLine()) != null) {
                ++lineNr;
                String[] split = (line = line.trim()).split(" ");
                if (split.length != 2) {
                    LOGGER.log(Level.FINE, "Skipping invalid line " + lineNr + " in file " + source.getAbsolutePath());
                    continue;
                }
                try {
                    OpenPgpV4Fingerprint fingerprint = new OpenPgpV4Fingerprint(split[0]);
                    Date date = XmppDateTime.parseXEP0082Date((String)split[1]);
                    fingerprintDateMap.put(fingerprint, date);
                }
                catch (IllegalArgumentException | ParseException e) {
                    LOGGER.log(Level.WARNING, "Error parsing fingerprint/date touple in line " + lineNr + " of file " + source.getAbsolutePath(), e);
                }
            }
            hashMap = fingerprintDateMap;
        }
        catch (Throwable throwable) {
            CloseableUtil.maybeClose(reader, (Logger)LOGGER);
            throw throwable;
        }
        CloseableUtil.maybeClose((Closeable)reader, (Logger)LOGGER);
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeFingerprintsAndDates(Map<OpenPgpV4Fingerprint, Date> data, File destination) throws IOException {
        if (data == null || data.isEmpty()) {
            FileUtils.maybeDeleteFileOrThrow((File)destination);
            return;
        }
        FileUtils.maybeCreateFileWithParentDirectories((File)destination);
        BufferedWriter writer = null;
        try {
            FileOutputStream outputStream = FileUtils.prepareFileOutputStream((File)destination);
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)outputStream, Util.UTF8);
            writer = new BufferedWriter(osw);
            for (OpenPgpV4Fingerprint fingerprint : data.keySet()) {
                Date date = data.get(fingerprint);
                String line = fingerprint.toString() + " " + (date != null ? XmppDateTime.formatXEP0082Date((Date)date) : XmppDateTime.formatXEP0082Date((Date)new Date()));
                writer.write(line);
                writer.newLine();
            }
        }
        catch (Throwable throwable) {
            CloseableUtil.maybeClose(writer, (Logger)LOGGER);
            throw throwable;
        }
        CloseableUtil.maybeClose((Closeable)writer, (Logger)LOGGER);
    }

    private File getAnnouncedFingerprintsPath(BareJid contact) {
        return new File(FileBasedOpenPgpStore.getContactsPath(this.basePath, contact), ANNOUNCED);
    }
}

