/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.ox;

import java.io.File;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.jivesoftware.smack.test.util.SmackTestSuite;
import org.jivesoftware.smackx.ox.OpenPgpContact;
import org.jivesoftware.smackx.ox.callback.SecretKeyPassphraseCallback;
import org.jivesoftware.smackx.ox.exception.MissingUserIdOnKeyException;
import org.jivesoftware.smackx.ox.store.definition.OpenPgpStore;
import org.jivesoftware.smackx.ox.store.definition.OpenPgpTrustStore;
import org.jivesoftware.smackx.ox.store.filebased.FileBasedOpenPgpStore;
import org.junit.After;
import org.junit.Before;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.junit.runner.RunWith;
import org.junit.runners.MethodSorters;
import org.junit.runners.Parameterized;
import org.jxmpp.jid.BareJid;
import org.jxmpp.jid.JidTestUtil;
import org.pgpainless.key.OpenPgpV4Fingerprint;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.protection.UnprotectedKeysProtector;
import org.pgpainless.key.util.KeyRingUtils;
import org.pgpainless.util.Passphrase;

@RunWith(value=Parameterized.class)
@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class OpenPgpStoreTest
extends SmackTestSuite {
    private static final File storagePath;
    private static final BareJid alice;
    private static final BareJid bob;
    private static final OpenPgpV4Fingerprint finger1;
    private static final OpenPgpV4Fingerprint finger2;
    private static final OpenPgpV4Fingerprint finger3;
    private final OpenPgpStore openPgpStoreInstance1;
    private final OpenPgpStore openPgpStoreInstance2;

    @Parameterized.Parameters
    public static Collection<OpenPgpStore[]> data() {
        return Arrays.asList(new OpenPgpStore[][]{{new FileBasedOpenPgpStore(storagePath), new FileBasedOpenPgpStore(storagePath)}});
    }

    public OpenPgpStoreTest(OpenPgpStore firstInstance, OpenPgpStore secondInstance) {
        if (firstInstance == secondInstance || !firstInstance.getClass().equals(secondInstance.getClass())) {
            throw new IllegalArgumentException("firstInstance must be another instance of the same class as secondInstance.");
        }
        this.openPgpStoreInstance1 = firstInstance;
        this.openPgpStoreInstance2 = secondInstance;
    }

    @Before
    @After
    public void deletePath() throws IOException {
        FileUtils.deleteDirectory((File)storagePath);
    }

    @Test
    public void t00_store_protectorGetSet() {
        this.openPgpStoreInstance1.setKeyRingProtector((SecretKeyRingProtector)new UnprotectedKeysProtector());
        Assertions.assertNotNull((Object)this.openPgpStoreInstance1.getKeyRingProtector());
        this.openPgpStoreInstance1.setSecretKeyPassphraseCallback(new SecretKeyPassphraseCallback(){

            public Passphrase onPassphraseNeeded(OpenPgpV4Fingerprint fingerprint) {
                return null;
            }
        });
    }

    @Test
    public void t00_deleteTest() throws IOException, PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException, MissingUserIdOnKeyException {
        Assertions.assertNull((Object)this.openPgpStoreInstance1.getSecretKeysOf(alice));
        Assertions.assertNull((Object)this.openPgpStoreInstance1.getPublicKeysOf(alice));
        PGPSecretKeyRing keys = this.openPgpStoreInstance1.generateKeyRing(alice);
        OpenPgpV4Fingerprint fingerprint = new OpenPgpV4Fingerprint(keys);
        this.openPgpStoreInstance1.importSecretKey(alice, keys);
        this.openPgpStoreInstance1.importPublicKey(alice, KeyRingUtils.publicKeyRingFrom((PGPSecretKeyRing)keys));
        Assertions.assertNotNull((Object)this.openPgpStoreInstance1.getSecretKeysOf(alice));
        Assertions.assertNotNull((Object)this.openPgpStoreInstance1.getPublicKeysOf(alice));
        this.openPgpStoreInstance1.deleteSecretKeyRing(alice, fingerprint);
        this.openPgpStoreInstance1.deletePublicKeyRing(alice, fingerprint);
        Assertions.assertNull((Object)this.openPgpStoreInstance1.getPublicKeysOf(alice));
        Assertions.assertNull((Object)this.openPgpStoreInstance1.getSecretKeysOf(alice));
    }

    @Test
    public void t01_key_emptyStoreTest() throws IOException, PGPException {
        Assertions.assertNull((Object)this.openPgpStoreInstance1.getPublicKeysOf(alice));
        Assertions.assertNull((Object)this.openPgpStoreInstance1.getSecretKeysOf(alice));
        Assertions.assertNull((Object)this.openPgpStoreInstance1.getPublicKeyRing(alice, finger1));
        Assertions.assertNull((Object)this.openPgpStoreInstance1.getSecretKeyRing(alice, finger1));
    }

    @Test
    public void t02_key_importKeysTest() throws IOException, PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException, MissingUserIdOnKeyException {
        PGPSecretKeyRing secretKeys = this.openPgpStoreInstance1.generateKeyRing(alice);
        PGPPublicKeyRing publicKeys = KeyRingUtils.publicKeyRingFrom((PGPSecretKeyRing)secretKeys);
        Assertions.assertNotNull((Object)secretKeys);
        Assertions.assertNotNull((Object)publicKeys);
        OpenPgpV4Fingerprint fingerprint = new OpenPgpV4Fingerprint(secretKeys);
        OpenPgpContact cAlice = this.openPgpStoreInstance1.getOpenPgpContact(alice);
        Assertions.assertNull((Object)cAlice.getAnyPublicKeys());
        Assertions.assertEquals((Object)fingerprint, (Object)new OpenPgpV4Fingerprint(secretKeys));
        Assertions.assertNull((Object)this.openPgpStoreInstance1.getPublicKeysOf(alice));
        Assertions.assertNull((Object)this.openPgpStoreInstance1.getSecretKeysOf(alice));
        this.openPgpStoreInstance1.importPublicKey(alice, publicKeys);
        Assertions.assertArrayEquals((byte[])publicKeys.getEncoded(), (byte[])this.openPgpStoreInstance1.getPublicKeysOf(alice).getEncoded());
        Assertions.assertNotNull((Object)this.openPgpStoreInstance1.getPublicKeyRing(alice, fingerprint));
        Assertions.assertNull((Object)this.openPgpStoreInstance1.getSecretKeysOf(alice));
        cAlice = this.openPgpStoreInstance1.getOpenPgpContact(alice);
        Assertions.assertNotNull((Object)cAlice.getAnyPublicKeys());
        this.openPgpStoreInstance1.importPublicKey(alice, publicKeys);
        Assertions.assertArrayEquals((byte[])publicKeys.getEncoded(), (byte[])this.openPgpStoreInstance1.getPublicKeysOf(alice).getEncoded());
        this.openPgpStoreInstance1.importSecretKey(alice, secretKeys);
        Assertions.assertArrayEquals((byte[])secretKeys.getEncoded(), (byte[])this.openPgpStoreInstance1.getSecretKeysOf(alice).getEncoded());
        this.openPgpStoreInstance1.importSecretKey(alice, secretKeys);
        Assertions.assertNotNull((Object)this.openPgpStoreInstance1.getSecretKeysOf(alice));
        Assertions.assertArrayEquals((byte[])secretKeys.getEncoded(), (byte[])this.openPgpStoreInstance1.getSecretKeysOf(alice).getEncoded());
        Assertions.assertNotNull((Object)this.openPgpStoreInstance1.getSecretKeyRing(alice, fingerprint));
        Assertions.assertArrayEquals((byte[])secretKeys.getEncoded(), (byte[])this.openPgpStoreInstance1.getSecretKeyRing(alice, fingerprint).getEncoded());
        Assertions.assertArrayEquals((byte[])publicKeys.getEncoded(), (byte[])this.openPgpStoreInstance1.getPublicKeyRing(alice, fingerprint).getEncoded());
        this.openPgpStoreInstance1.deletePublicKeyRing(alice, fingerprint);
        this.openPgpStoreInstance1.deleteSecretKeyRing(alice, fingerprint);
    }

    @Test
    public void t04_key_wrongBareJidOnSecretKeyImportTest() throws PGPException, NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException {
        PGPSecretKeyRing secretKeys = this.openPgpStoreInstance1.generateKeyRing(alice);
        Assertions.assertThrows(MissingUserIdOnKeyException.class, () -> this.openPgpStoreInstance1.importSecretKey(bob, secretKeys));
    }

    @Test
    public void t05_key_wrongBareJidOnPublicKeyImportTest() throws PGPException, NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException {
        PGPSecretKeyRing secretKeys = this.openPgpStoreInstance1.generateKeyRing(alice);
        PGPPublicKeyRing publicKeys = KeyRingUtils.publicKeyRingFrom((PGPSecretKeyRing)secretKeys);
        Assertions.assertThrows(MissingUserIdOnKeyException.class, () -> this.openPgpStoreInstance1.importPublicKey(bob, publicKeys));
    }

    @Test
    public void t06_key_keyReloadTest() throws PGPException, NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException, IOException, MissingUserIdOnKeyException {
        PGPSecretKeyRing secretKeys = this.openPgpStoreInstance1.generateKeyRing(alice);
        OpenPgpV4Fingerprint fingerprint = new OpenPgpV4Fingerprint(secretKeys);
        PGPPublicKeyRing publicKeys = KeyRingUtils.publicKeyRingFrom((PGPSecretKeyRing)secretKeys);
        this.openPgpStoreInstance1.importSecretKey(alice, secretKeys);
        this.openPgpStoreInstance1.importPublicKey(alice, publicKeys);
        Assertions.assertNotNull((Object)this.openPgpStoreInstance2.getSecretKeysOf(alice));
        Assertions.assertNotNull((Object)this.openPgpStoreInstance2.getPublicKeysOf(alice));
        this.openPgpStoreInstance1.deletePublicKeyRing(alice, fingerprint);
        this.openPgpStoreInstance1.deleteSecretKeyRing(alice, fingerprint);
        this.openPgpStoreInstance2.deletePublicKeyRing(alice, fingerprint);
        this.openPgpStoreInstance2.deleteSecretKeyRing(alice, fingerprint);
    }

    @Test
    public void t07_multipleKeysTest() throws PGPException, NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException, IOException, MissingUserIdOnKeyException {
        PGPSecretKeyRing one = this.openPgpStoreInstance1.generateKeyRing(alice);
        PGPSecretKeyRing two = this.openPgpStoreInstance1.generateKeyRing(alice);
        OpenPgpV4Fingerprint fingerprint1 = new OpenPgpV4Fingerprint(one);
        OpenPgpV4Fingerprint fingerprint2 = new OpenPgpV4Fingerprint(two);
        this.openPgpStoreInstance1.importSecretKey(alice, one);
        this.openPgpStoreInstance1.importSecretKey(alice, two);
        this.openPgpStoreInstance1.importPublicKey(alice, KeyRingUtils.publicKeyRingFrom((PGPSecretKeyRing)one));
        this.openPgpStoreInstance1.importPublicKey(alice, KeyRingUtils.publicKeyRingFrom((PGPSecretKeyRing)two));
        Assertions.assertArrayEquals((byte[])one.getEncoded(), (byte[])this.openPgpStoreInstance1.getSecretKeyRing(alice, fingerprint1).getEncoded());
        Assertions.assertArrayEquals((byte[])two.getEncoded(), (byte[])this.openPgpStoreInstance1.getSecretKeyRing(alice, fingerprint2).getEncoded());
        Assertions.assertArrayEquals((byte[])one.getEncoded(), (byte[])this.openPgpStoreInstance1.getSecretKeysOf(alice).getSecretKeyRing(fingerprint1.getKeyId()).getEncoded());
        Assertions.assertArrayEquals((byte[])KeyRingUtils.publicKeyRingFrom((PGPSecretKeyRing)one).getEncoded(), (byte[])this.openPgpStoreInstance1.getPublicKeyRing(alice, fingerprint1).getEncoded());
        this.openPgpStoreInstance1.deletePublicKeyRing(alice, fingerprint1);
        this.openPgpStoreInstance1.deletePublicKeyRing(alice, fingerprint2);
        this.openPgpStoreInstance1.deleteSecretKeyRing(alice, fingerprint1);
        this.openPgpStoreInstance1.deleteSecretKeyRing(alice, fingerprint2);
    }

    @Test
    public void t08_trust_emptyStoreTest() throws IOException {
        Assertions.assertEquals((Object)OpenPgpTrustStore.Trust.undecided, (Object)this.openPgpStoreInstance1.getTrust(alice, finger2));
        this.openPgpStoreInstance1.setTrust(alice, finger2, OpenPgpTrustStore.Trust.trusted);
        Assertions.assertEquals((Object)OpenPgpTrustStore.Trust.trusted, (Object)this.openPgpStoreInstance1.getTrust(alice, finger2));
        this.openPgpStoreInstance1.setTrust(alice, finger2, OpenPgpTrustStore.Trust.trusted);
        Assertions.assertEquals((Object)OpenPgpTrustStore.Trust.trusted, (Object)this.openPgpStoreInstance1.getTrust(alice, finger2));
        Assertions.assertEquals((Object)OpenPgpTrustStore.Trust.undecided, (Object)this.openPgpStoreInstance1.getTrust(alice, finger3));
        this.openPgpStoreInstance1.setTrust(bob, finger2, OpenPgpTrustStore.Trust.untrusted);
        Assertions.assertEquals((Object)OpenPgpTrustStore.Trust.untrusted, (Object)this.openPgpStoreInstance1.getTrust(bob, finger2));
        Assertions.assertEquals((Object)OpenPgpTrustStore.Trust.trusted, (Object)this.openPgpStoreInstance1.getTrust(alice, finger2));
        this.openPgpStoreInstance1.setTrust(alice, finger2, OpenPgpTrustStore.Trust.undecided);
        this.openPgpStoreInstance1.setTrust(bob, finger2, OpenPgpTrustStore.Trust.undecided);
    }

    @Test
    public void t09_trust_reloadTest() throws IOException {
        this.openPgpStoreInstance1.setTrust(alice, finger1, OpenPgpTrustStore.Trust.trusted);
        Assertions.assertEquals((Object)OpenPgpTrustStore.Trust.trusted, (Object)this.openPgpStoreInstance2.getTrust(alice, finger1));
        this.openPgpStoreInstance1.setTrust(alice, finger1, OpenPgpTrustStore.Trust.undecided);
        this.openPgpStoreInstance2.setTrust(alice, finger1, OpenPgpTrustStore.Trust.undecided);
    }

    @Test
    public void t10_meta_emptyStoreTest() throws IOException {
        Assertions.assertNotNull((Object)this.openPgpStoreInstance1.getAnnouncedFingerprintsOf(alice));
        Assertions.assertTrue((boolean)this.openPgpStoreInstance1.getAnnouncedFingerprintsOf(alice).isEmpty());
        HashMap<OpenPgpV4Fingerprint, Date> map = new HashMap<OpenPgpV4Fingerprint, Date>();
        Date date1 = new Date(12354563423L);
        Date date2 = new Date(8274729879812L);
        map.put(finger1, date1);
        map.put(finger2, date2);
        this.openPgpStoreInstance1.setAnnouncedFingerprintsOf(alice, map);
        Assertions.assertFalse((boolean)this.openPgpStoreInstance1.getAnnouncedFingerprintsOf(alice).isEmpty());
        Assertions.assertEquals(map, (Object)this.openPgpStoreInstance1.getAnnouncedFingerprintsOf(alice));
        Assertions.assertTrue((boolean)this.openPgpStoreInstance1.getAnnouncedFingerprintsOf(bob).isEmpty());
        Assertions.assertFalse((boolean)this.openPgpStoreInstance2.getAnnouncedFingerprintsOf(alice).isEmpty());
        Assertions.assertEquals(map, (Object)this.openPgpStoreInstance2.getAnnouncedFingerprintsOf(alice));
        this.openPgpStoreInstance1.setAnnouncedFingerprintsOf(alice, Collections.emptyMap());
        this.openPgpStoreInstance2.setAnnouncedFingerprintsOf(alice, Collections.emptyMap());
    }

    @Test
    public void t11_key_fetchDateTest() throws IOException {
        Map fetchDates1 = this.openPgpStoreInstance1.getPublicKeyFetchDates(alice);
        Assertions.assertNotNull((Object)fetchDates1);
        Assertions.assertTrue((boolean)fetchDates1.isEmpty());
        Date date1 = new Date(85092830954L);
        fetchDates1.put(finger1, date1);
        this.openPgpStoreInstance1.setPublicKeyFetchDates(alice, fetchDates1);
        Map fetchDates2 = this.openPgpStoreInstance1.getPublicKeyFetchDates(alice);
        Assertions.assertNotNull((Object)fetchDates2);
        Assertions.assertFalse((boolean)fetchDates2.isEmpty());
        Assertions.assertEquals((Object)fetchDates1, (Object)fetchDates2);
        Map fetchDates3 = this.openPgpStoreInstance2.getPublicKeyFetchDates(alice);
        Assertions.assertNotNull((Object)fetchDates3);
        Assertions.assertEquals((Object)fetchDates1, (Object)fetchDates3);
        this.openPgpStoreInstance1.setPublicKeyFetchDates(alice, null);
        this.openPgpStoreInstance2.setPublicKeyFetchDates(alice, null);
        Assertions.assertNotNull((Object)this.openPgpStoreInstance1.getPublicKeyFetchDates(alice));
        Assertions.assertTrue((boolean)this.openPgpStoreInstance1.getPublicKeyFetchDates(alice).isEmpty());
    }

    static {
        alice = JidTestUtil.BARE_JID_1;
        bob = JidTestUtil.BARE_JID_2;
        finger1 = new OpenPgpV4Fingerprint("DEADBEEFDEADBEEFDEADBEEFDEADBEEFDEADBEEF");
        finger2 = new OpenPgpV4Fingerprint("C0FFEEC0FFEEC0FFEEC0FFEEC0FFEEC0FFEE1234");
        finger3 = new OpenPgpV4Fingerprint("0123012301230123012301230123012301230123");
        storagePath = new File(FileUtils.getTempDirectory(), "storeTest");
    }
}

