/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.ox.provider;

import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smack.util.ParserUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.ox.element.OpenPgpContentElement;
import org.jivesoftware.smackx.ox.provider.CryptElementProvider;
import org.jivesoftware.smackx.ox.provider.SignElementProvider;
import org.jivesoftware.smackx.ox.provider.SigncryptElementProvider;
import org.jxmpp.jid.BareJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;

public abstract class OpenPgpContentElementProvider<O extends OpenPgpContentElement>
extends ExtensionElementProvider<O> {
    private static final Logger LOGGER = Logger.getLogger(OpenPgpContentElementProvider.class.getName());

    public static OpenPgpContentElement parseOpenPgpContentElement(String element) throws XmlPullParserException, IOException {
        XmlPullParser parser = PacketParserUtils.getParserFor((String)element);
        return OpenPgpContentElementProvider.parseOpenPgpContentElement(parser);
    }

    public static OpenPgpContentElement parseOpenPgpContentElement(XmlPullParser parser) throws XmlPullParserException {
        try {
            switch (parser.getName()) {
                case "signcrypt": {
                    return (OpenPgpContentElement)SigncryptElementProvider.INSTANCE.parse(parser);
                }
                case "sign": {
                    return (OpenPgpContentElement)SignElementProvider.INSTANCE.parse(parser);
                }
                case "crypt": {
                    return (OpenPgpContentElement)CryptElementProvider.INSTANCE.parse(parser);
                }
            }
            throw new XmlPullParserException("Expected <crypt/>, <sign/> or <signcrypt/> element, but got neither of them.");
        }
        catch (Exception e) {
            throw new XmlPullParserException(e.getMessage());
        }
    }

    public abstract O parse(XmlPullParser var1, int var2, XmlEnvironment var3) throws XmlPullParserException, IOException, SmackParsingException, ParseException;

    /*
     * Unable to fully structure code
     */
    protected static OpenPgpContentElementData parseOpenPgpContentElementData(XmlPullParser parser, int initialDepth) throws XmlPullParserException, IOException, SmackParsingException, ParseException {
        to = new HashSet<BareJid>();
        timestamp = null;
        rpad = null;
        payload = new LinkedList<ExtensionElement>();
        block28: while (true) {
            tag = parser.next();
            name = parser.getName();
            switch (1.$SwitchMap$org$jivesoftware$smack$xml$XmlPullParser$Event[tag.ordinal()]) {
                case 1: {
                    var8_8 = name;
                    var9_9 = -1;
                    switch (var8_8.hashCode()) {
                        case 3560141: {
                            if (!var8_8.equals("time")) break;
                            var9_9 = 0;
                            break;
                        }
                        case 3707: {
                            if (!var8_8.equals("to")) break;
                            var9_9 = 1;
                            break;
                        }
                        case 3506913: {
                            if (!var8_8.equals("rpad")) break;
                            var9_9 = 2;
                            break;
                        }
                        case -786701938: {
                            if (!var8_8.equals("payload")) break;
                            var9_9 = 3;
                        }
                    }
                    block10 : switch (var9_9) {
                        case 0: {
                            stamp = parser.getAttributeValue("", "stamp");
                            timestamp = ParserUtils.getDateFromXep82String((String)stamp);
                            break;
                        }
                        case 1: {
                            jid = parser.getAttributeValue("", "jid");
                            to.add(JidCreate.bareFrom((String)jid));
                            break;
                        }
                        case 2: {
                            rpad = parser.nextText();
                            break;
                        }
                        case 3: {
                            while (true) {
                                ptag = parser.next();
                                pname = parser.getName();
                                pns = parser.getNamespace();
                                switch (1.$SwitchMap$org$jivesoftware$smack$xml$XmlPullParser$Event[ptag.ordinal()]) {
                                    case 1: {
                                        provider = ProviderManager.getExtensionProvider((String)pname, (String)pns);
                                        if (provider == null) {
                                            OpenPgpContentElementProvider.LOGGER.log(Level.INFO, "No provider found for " + pname + " " + pns);
                                            break;
                                        }
                                        payload.add((ExtensionElement)provider.parse(parser));
                                        break;
                                    }
                                    case 2: {
                                        break block10;
                                    }
                                }
                            }
                        }
                    }
                    ** GOTO lbl78
                }
                case 2: {
                    var8_8 = name;
                    var9_9 = -1;
                    switch (var8_8.hashCode()) {
                        case 94944622: {
                            if (!var8_8.equals("crypt")) break;
                            var9_9 = 0;
                            break;
                        }
                        case 1075375569: {
                            if (!var8_8.equals("signcrypt")) break;
                            var9_9 = 1;
                            break;
                        }
                        case 3530173: {
                            if (!var8_8.equals("sign")) break;
                            var9_9 = 2;
                        }
                    }
                    switch (var9_9) {
                        case 0: 
                        case 1: 
                        case 2: {
                            break block28;
                        }
                    }
                }
lbl78:
                // 3 sources

                default: {
                    continue block28;
                }
            }
            break;
        }
        return new OpenPgpContentElementData(to, timestamp, rpad, payload);
    }

    protected static final class OpenPgpContentElementData {
        final Set<Jid> to;
        final Date timestamp;
        final String rpad;
        final List<ExtensionElement> payload;

        private OpenPgpContentElementData(Set<Jid> to, Date timestamp, String rpad, List<ExtensionElement> payload) {
            this.to = to;
            this.timestamp = timestamp;
            this.rpad = rpad;
            this.payload = payload;
        }
    }
}

