/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.ox;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.test.util.SmackTestSuite;
import org.jivesoftware.smack.test.util.TestUtils;
import org.jivesoftware.smack.test.util.XmlAssertUtil;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.ox.element.CryptElement;
import org.jivesoftware.smackx.ox.element.OpenPgpElement;
import org.jivesoftware.smackx.ox.element.SignElement;
import org.jivesoftware.smackx.ox.element.SigncryptElement;
import org.jivesoftware.smackx.ox.provider.OpenPgpContentElementProvider;
import org.jivesoftware.smackx.ox.provider.OpenPgpElementProvider;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.jxmpp.jid.BareJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.stringprep.XmppStringprepException;

public class OpenPgpElementTest
extends SmackTestSuite {
    private final Set<Jid> recipients;
    private static final Date testDate = new Date(1405004760000L);

    public OpenPgpElementTest() throws XmppStringprepException {
        HashSet<BareJid> jids = new HashSet<BareJid>();
        jids.add(JidCreate.bareFrom((String)"alice@wonderland.lit"));
        jids.add(JidCreate.bareFrom((String)"bob@builder.lit"));
        this.recipients = Collections.unmodifiableSet(jids);
    }

    @Test
    public void providerTest() throws Exception {
        String expected = "<openpgp xmlns='urn:xmpp:openpgp:0'>BASE64_OPENPGP_MESSAGE</openpgp>";
        OpenPgpElement element = new OpenPgpElement("BASE64_OPENPGP_MESSAGE");
        XmlAssertUtil.assertXmlSimilar((CharSequence)expected, (CharSequence)element.toXML().toString());
        XmlPullParser parser = TestUtils.getParser((String)expected);
        OpenPgpElement parsed = (OpenPgpElement)OpenPgpElementProvider.TEST_INSTANCE.parse(parser);
        Assertions.assertEquals((Object)element.getEncryptedBase64MessageContent(), (Object)parsed.getEncryptedBase64MessageContent());
    }

    @Test
    public void simplifiedConstructorTest() {
        ArrayList<Message.Body> payload = new ArrayList<Message.Body>();
        payload.add(new Message.Body("de", "Hallo Welt!"));
        CryptElement element = new CryptElement(this.recipients, payload);
        Assertions.assertNotNull((Object)element.getTimestamp());
    }

    @Test
    public void signElementProviderTest() throws Exception {
        String expected = "<sign xmlns='urn:xmpp:openpgp:0'><to jid='alice@wonderland.lit'/><to jid='bob@builder.lit'/><time stamp='2014-07-10T15:06:00.000+00:00'/><payload><body xmlns='jabber:client' xml:lang='en'>Hello World!</body></payload></sign>";
        ArrayList<Message.Body> payload = new ArrayList<Message.Body>();
        payload.add(new Message.Body("en", "Hello World!"));
        SignElement element = new SignElement(this.recipients, testDate, payload);
        XmlAssertUtil.assertXmlSimilar((CharSequence)expected, (CharSequence)element.toXML().toString());
        XmlPullParser parser = TestUtils.getParser((String)expected);
        SignElement parsed = (SignElement)OpenPgpContentElementProvider.parseOpenPgpContentElement((XmlPullParser)parser);
        Assertions.assertEquals((Object)element.getTimestamp(), (Object)parsed.getTimestamp());
        Assertions.assertEquals((Object)element.getTo(), (Object)parsed.getTo());
        Assertions.assertEquals((Object)element.getExtensions(), (Object)parsed.getExtensions());
    }

    @Test
    public void cryptElementProviderTest() throws Exception {
        String expected = "<crypt xmlns='urn:xmpp:openpgp:0'><to jid='alice@wonderland.lit'/><time stamp='2014-07-10T15:06:00.000+00:00'/><payload><body xmlns='jabber:client' xml:lang='en'>The cake is a lie.</body></payload><rpad>f0rm1l4n4-mT8y33j!Y%fRSrcd^ZE4Q7VDt1L%WEgR!kv</rpad></crypt>";
        ArrayList<Message.Body> payload = new ArrayList<Message.Body>();
        payload.add(new Message.Body("en", "The cake is a lie."));
        HashSet<BareJid> to = new HashSet<BareJid>();
        to.add(JidCreate.bareFrom((String)"alice@wonderland.lit"));
        CryptElement element = new CryptElement(to, "f0rm1l4n4-mT8y33j!Y%fRSrcd^ZE4Q7VDt1L%WEgR!kv", testDate, payload);
        XmlAssertUtil.assertXmlSimilar((CharSequence)expected, (CharSequence)element.toXML().toString());
        XmlPullParser parser = TestUtils.getParser((String)expected);
        CryptElement parsed = (CryptElement)OpenPgpContentElementProvider.parseOpenPgpContentElement((XmlPullParser)parser);
        Assertions.assertEquals((Object)element.getTimestamp(), (Object)parsed.getTimestamp());
        Assertions.assertEquals((Object)element.getTo(), (Object)parsed.getTo());
        Assertions.assertEquals((Object)element.getExtensions(), (Object)parsed.getExtensions());
    }

    @Test
    public void signcryptElementProviderTest() throws Exception {
        String expected = "<signcrypt xmlns='urn:xmpp:openpgp:0'><to jid='juliet@example.org'/><time stamp='2014-07-10T15:06:00.000+00:00'/><payload><body xmlns='jabber:client' xml:lang='en'>This is a secret message.</body></payload><rpad>f0rm1l4n4-mT8y33j!Y%fRSrcd^ZE4Q7VDt1L%WEgR!kv</rpad></signcrypt>";
        ArrayList<Message.Body> payload = new ArrayList<Message.Body>();
        payload.add(new Message.Body("en", "This is a secret message."));
        HashSet<BareJid> jids = new HashSet<BareJid>();
        jids.add(JidCreate.bareFrom((String)"juliet@example.org"));
        SigncryptElement element = new SigncryptElement(jids, "f0rm1l4n4-mT8y33j!Y%fRSrcd^ZE4Q7VDt1L%WEgR!kv", testDate, payload);
        XmlAssertUtil.assertXmlSimilar((CharSequence)expected, (CharSequence)element.toXML().toString());
        XmlPullParser parser = TestUtils.getParser((String)expected);
        SigncryptElement parsed = (SigncryptElement)OpenPgpContentElementProvider.parseOpenPgpContentElement((XmlPullParser)parser);
        Assertions.assertEquals((Object)element.getTimestamp(), (Object)parsed.getTimestamp());
        Assertions.assertEquals((Object)element.getTo(), (Object)parsed.getTo());
        Assertions.assertEquals((Object)element.getExtensions(), (Object)parsed.getExtensions());
        Assertions.assertEquals(payload.get(0), (Object)element.getExtension("jabber:client"));
        Assertions.assertEquals(payload.get(0), (Object)element.getExtension("body", "jabber:client"));
    }

    @Test
    public void openPgpContentElementProvider_invalidElementTest() {
        String invalidElementXML = "<payload><body xmlns='jabber:client' xml:lang='en'>This is a secret message.</body></payload>";
        Assertions.assertThrows(XmlPullParserException.class, () -> OpenPgpContentElementProvider.parseOpenPgpContentElement((String)invalidElementXML));
    }
}

