/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.ox.element;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.XmlElement;
import org.jivesoftware.smack.util.MultiMap;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.PacketUtil;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jxmpp.jid.Jid;
import org.jxmpp.util.XmppDateTime;

public abstract class OpenPgpContentElement
implements ExtensionElement {
    public static final String ELEM_TO = "to";
    public static final String ATTR_JID = "jid";
    public static final String ELEM_TIME = "time";
    public static final String ATTR_STAMP = "stamp";
    public static final String ELEM_PAYLOAD = "payload";
    private final Set<? extends Jid> to;
    private final Date timestamp;
    private final MultiMap<QName, XmlElement> payload;
    private String timestampString;

    protected OpenPgpContentElement(Set<? extends Jid> to, Date timestamp, List<ExtensionElement> payload) {
        this.to = to;
        this.timestamp = (Date)Objects.requireNonNull((Object)timestamp);
        this.payload = new MultiMap();
        for (ExtensionElement e : payload) {
            this.payload.put((Object)e.getQName(), (Object)e);
        }
    }

    public final Set<? extends Jid> getTo() {
        return this.to;
    }

    public final Date getTimestamp() {
        return this.timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<XmlElement> getExtensions() {
        MultiMap<QName, XmlElement> multiMap = this.payload;
        synchronized (multiMap) {
            return this.payload.values();
        }
    }

    public List<XmlElement> getExtensions(String elementName, String namespace) {
        QName key = new QName(namespace, elementName);
        return this.payload.getAll((Object)key);
    }

    public ExtensionElement getExtension(String namespace) {
        return (ExtensionElement)PacketUtil.extensionElementFrom(this.getExtensions(), null, (String)namespace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <PE extends ExtensionElement> PE getExtension(String elementName, String namespace) {
        XmlElement packetExtension;
        if (namespace == null) {
            return null;
        }
        QName key = new QName(namespace, elementName);
        MultiMap<QName, XmlElement> multiMap = this.payload;
        synchronized (multiMap) {
            packetExtension = (XmlElement)this.payload.getFirst((Object)key);
        }
        if (packetExtension == null) {
            return null;
        }
        return (PE)((ExtensionElement)packetExtension);
    }

    public String getNamespace() {
        return "urn:xmpp:openpgp:0";
    }

    protected void ensureTimestampStringSet() {
        if (this.timestampString != null) {
            return;
        }
        this.timestampString = XmppDateTime.formatXEP0082Date((Date)this.timestamp);
    }

    protected void addCommonXml(XmlStringBuilder xml) {
        for (Jid jid : this.to != null ? this.to : Collections.emptySet()) {
            xml.halfOpenElement(ELEM_TO).attribute(ATTR_JID, (CharSequence)jid).closeEmptyElement();
        }
        this.ensureTimestampStringSet();
        xml.halfOpenElement(ELEM_TIME).attribute(ATTR_STAMP, this.timestampString).closeEmptyElement();
        xml.openElement(ELEM_PAYLOAD);
        for (XmlElement xmlElement : this.payload.values()) {
            xml.append(xmlElement.toXML(this.getNamespace()));
        }
        xml.closeElement(ELEM_PAYLOAD);
    }

    public InputStream toInputStream() {
        byte[] encoded = this.toXML().toString().getBytes(Charset.forName("UTF-8"));
        return new ByteArrayInputStream(encoded);
    }
}

