/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.ox.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smack.packet.XmlElement;
import org.jivesoftware.smackx.ox.OpenPgpManager;
import org.jivesoftware.smackx.ox.element.PubkeyElement;
import org.jivesoftware.smackx.ox.element.PublicKeysListElement;
import org.jivesoftware.smackx.ox.element.SecretkeyElement;
import org.jivesoftware.smackx.pep.PepManager;
import org.jivesoftware.smackx.pubsub.AccessModel;
import org.jivesoftware.smackx.pubsub.Item;
import org.jivesoftware.smackx.pubsub.LeafNode;
import org.jivesoftware.smackx.pubsub.Node;
import org.jivesoftware.smackx.pubsub.PayloadItem;
import org.jivesoftware.smackx.pubsub.PubSubException;
import org.jivesoftware.smackx.pubsub.PubSubManager;
import org.jivesoftware.smackx.pubsub.form.ConfigureForm;
import org.jivesoftware.smackx.pubsub.form.FillableConfigureForm;
import org.jxmpp.jid.BareJid;
import org.pgpainless.key.OpenPgpV4Fingerprint;

public class OpenPgpPubSubUtil {
    private static final Logger LOGGER = Logger.getLogger(OpenPgpPubSubUtil.class.getName());
    public static final String PEP_NODE_PUBLIC_KEYS = "urn:xmpp:openpgp:0:public-keys";
    public static final String PEP_NODE_SECRET_KEY = "urn:xmpp:openpgp:0:secret-key";
    public static final String PEP_NODE_PUBLIC_KEYS_NOTIFY = "urn:xmpp:openpgp:0:public-keys+notify";

    public static String PEP_NODE_PUBLIC_KEY(OpenPgpV4Fingerprint id) {
        return "urn:xmpp:openpgp:0:public-keys:" + String.valueOf(id);
    }

    public static void changeAccessModelIfNecessary(LeafNode node, AccessModel accessModel) throws XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, SmackException.NoResponseException {
        ConfigureForm current = node.getNodeConfiguration();
        if (current.getAccessModel() != accessModel) {
            FillableConfigureForm updateConfig = current.getFillableForm();
            updateConfig.setAccessModel(accessModel);
            node.sendConfigurationForm(updateConfig);
        }
    }

    public static void publishPublicKey(PepManager pepManager, PubkeyElement pubkeyElement, OpenPgpV4Fingerprint fingerprint) throws InterruptedException, PubSubException.NotALeafNodeException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, SmackException.NoResponseException {
        String keyNodeName = OpenPgpPubSubUtil.PEP_NODE_PUBLIC_KEY(fingerprint);
        PubSubManager pm = pepManager.getPepPubSubManager();
        LeafNode keyNode = pm.getOrCreateLeafNode(keyNodeName);
        OpenPgpPubSubUtil.changeAccessModelIfNecessary(keyNode, AccessModel.open);
        List items = keyNode.getItems(1);
        if (items.isEmpty()) {
            LOGGER.log(Level.FINE, "Node " + keyNodeName + " is empty. Publish.");
            keyNode.publish((Item)new PayloadItem((XmlElement)pubkeyElement));
        } else {
            LOGGER.log(Level.FINE, "Node " + keyNodeName + " already contains key. Skip.");
        }
        LeafNode metadataNode = pm.getOrCreateLeafNode(PEP_NODE_PUBLIC_KEYS);
        OpenPgpPubSubUtil.changeAccessModelIfNecessary(metadataNode, AccessModel.open);
        List metadataItems = metadataNode.getItems(1);
        PublicKeysListElement.Builder builder = PublicKeysListElement.builder();
        if (!metadataItems.isEmpty() && ((PayloadItem)metadataItems.get(0)).getPayload() != null) {
            PublicKeysListElement publishedList = (PublicKeysListElement)((PayloadItem)metadataItems.get(0)).getPayload();
            for (PublicKeysListElement.PubkeyMetadataElement meta : publishedList.getMetadata().values()) {
                builder.addMetadata(meta);
            }
        }
        builder.addMetadata(new PublicKeysListElement.PubkeyMetadataElement(fingerprint, new Date()));
        metadataNode.publish((Item)new PayloadItem((XmlElement)builder.build()));
    }

    public static PublicKeysListElement fetchPubkeysList(XMPPConnection connection) throws InterruptedException, XMPPException.XMPPErrorException, PubSubException.NotAPubSubNodeException, PubSubException.NotALeafNodeException, SmackException.NotConnectedException, SmackException.NoResponseException {
        return OpenPgpPubSubUtil.fetchPubkeysList(connection, null);
    }

    public static PublicKeysListElement fetchPubkeysList(XMPPConnection connection, BareJid contact) throws InterruptedException, XMPPException.XMPPErrorException, SmackException.NoResponseException, PubSubException.NotALeafNodeException, SmackException.NotConnectedException, PubSubException.NotAPubSubNodeException {
        PubSubManager pm = PubSubManager.getInstanceFor((XMPPConnection)connection, (BareJid)contact);
        LeafNode node = OpenPgpPubSubUtil.getLeafNode(pm, PEP_NODE_PUBLIC_KEYS);
        List list = node.getItems(1);
        if (list.isEmpty()) {
            return null;
        }
        return (PublicKeysListElement)((PayloadItem)list.get(0)).getPayload();
    }

    public static boolean deletePubkeysListNode(PepManager pepManager) throws XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, SmackException.NoResponseException {
        PubSubManager pm = pepManager.getPepPubSubManager();
        return pm.deleteNode(PEP_NODE_PUBLIC_KEYS);
    }

    public static boolean deletePublicKeyNode(PepManager pepManager, OpenPgpV4Fingerprint fingerprint) throws XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, SmackException.NoResponseException {
        PubSubManager pm = pepManager.getPepPubSubManager();
        return pm.deleteNode(OpenPgpPubSubUtil.PEP_NODE_PUBLIC_KEY(fingerprint));
    }

    public static PubkeyElement fetchPubkey(XMPPConnection connection, BareJid contact, OpenPgpV4Fingerprint v4_fingerprint) throws InterruptedException, XMPPException.XMPPErrorException, PubSubException.NotAPubSubNodeException, PubSubException.NotALeafNodeException, SmackException.NotConnectedException, SmackException.NoResponseException {
        String nodeName;
        PubSubManager pm = PubSubManager.getInstanceFor((XMPPConnection)connection, (BareJid)contact);
        LeafNode node = OpenPgpPubSubUtil.getLeafNode(pm, nodeName = OpenPgpPubSubUtil.PEP_NODE_PUBLIC_KEY(v4_fingerprint));
        List list = node.getItems(1);
        if (list.isEmpty()) {
            return null;
        }
        return (PubkeyElement)((PayloadItem)list.get(0)).getPayload();
    }

    static LeafNode getLeafNode(PubSubManager pm, String nodeName) throws XMPPException.XMPPErrorException, PubSubException.NotALeafNodeException, InterruptedException, PubSubException.NotAPubSubNodeException, SmackException.NotConnectedException, SmackException.NoResponseException {
        LeafNode node;
        try {
            node = pm.getLeafNode(nodeName);
        }
        catch (XMPPException.XMPPErrorException e) {
            if (e.getStanzaError().getCondition() == StanzaError.Condition.subscription_required) {
                node = OpenPgpPubSubUtil.getOpenLeafNode(pm, nodeName);
            }
            throw e;
        }
        return node;
    }

    public static void depositSecretKey(XMPPConnection connection, SecretkeyElement element) throws InterruptedException, PubSubException.NotALeafNodeException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, SmackException.NoResponseException, SmackException.FeatureNotSupportedException {
        if (!OpenPgpManager.serverSupportsSecretKeyBackups(connection)) {
            throw new SmackException.FeatureNotSupportedException("http://jabber.org/protocol/pubsub#access-whitelist");
        }
        PubSubManager pm = PepManager.getInstanceFor((XMPPConnection)connection).getPepPubSubManager();
        LeafNode secretKeyNode = pm.getOrCreateLeafNode(PEP_NODE_SECRET_KEY);
        OpenPgpPubSubUtil.changeAccessModelIfNecessary(secretKeyNode, AccessModel.whitelist);
        secretKeyNode.publish((Item)new PayloadItem((XmlElement)element));
    }

    public static SecretkeyElement fetchSecretKey(PepManager pepManager) throws InterruptedException, PubSubException.NotALeafNodeException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, SmackException.NoResponseException {
        PubSubManager pm = pepManager.getPepPubSubManager();
        LeafNode secretKeyNode = pm.getOrCreateLeafNode(PEP_NODE_SECRET_KEY);
        List list = secretKeyNode.getItems(1);
        if (list.size() == 0) {
            LOGGER.log(Level.INFO, "No secret key published!");
            return null;
        }
        SecretkeyElement secretkeyElement = (SecretkeyElement)((PayloadItem)list.get(0)).getPayload();
        return secretkeyElement;
    }

    public static boolean deleteSecretKeyNode(PepManager pepManager) throws XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, SmackException.NoResponseException {
        PubSubManager pm = pepManager.getPepPubSubManager();
        return pm.deleteNode(PEP_NODE_SECRET_KEY);
    }

    public static LeafNode getOpenLeafNode(PubSubManager pubSubManager, String nodeName) throws PubSubException.NotALeafNodeException {
        try {
            Field field = pubSubManager.getClass().getDeclaredField("nodeMap");
            field.setAccessible(true);
            Map nodeMap = (Map)field.get(pubSubManager);
            Node existingNode = (Node)nodeMap.get(nodeName);
            if (existingNode != null) {
                if (existingNode instanceof LeafNode) {
                    return (LeafNode)existingNode;
                }
                Constructor exceptionConstructor = PubSubException.NotALeafNodeException.class.getDeclaredConstructor(String.class, BareJid.class);
                exceptionConstructor.setAccessible(true);
                throw (PubSubException.NotALeafNodeException)((Object)exceptionConstructor.newInstance(nodeName, pubSubManager.getServiceJid()));
            }
            Constructor constructor = LeafNode.class.getDeclaredConstructor(PubSubManager.class, String.class);
            constructor.setAccessible(true);
            LeafNode node = (LeafNode)constructor.newInstance(pubSubManager, nodeName);
            nodeMap.put(nodeName, node);
            return node;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
            throw new LinkageError("Using reflections to create a LeafNode and put it into PubSubManagers nodeMap failed.", e);
        }
    }
}

