/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.ox.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Set;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.util.io.Streams;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.stringencoder.Base64;
import org.jivesoftware.smackx.ox.OpenPgpSecretKeyBackupPassphrase;
import org.jivesoftware.smackx.ox.crypto.OpenPgpProvider;
import org.jivesoftware.smackx.ox.element.SecretkeyElement;
import org.jivesoftware.smackx.ox.exception.InvalidBackupCodeException;
import org.jivesoftware.smackx.ox.exception.MissingOpenPgpKeyException;
import org.jxmpp.jid.BareJid;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.decryption_verification.ConsumerOptions;
import org.pgpainless.decryption_verification.DecryptionStream;
import org.pgpainless.encryption_signing.EncryptionOptions;
import org.pgpainless.encryption_signing.EncryptionStream;
import org.pgpainless.encryption_signing.ProducerOptions;
import org.pgpainless.exception.MissingDecryptionMethodException;
import org.pgpainless.key.OpenPgpV4Fingerprint;
import org.pgpainless.util.Passphrase;

public class SecretKeyBackupHelper {
    public static OpenPgpSecretKeyBackupPassphrase generateBackupPassword() {
        return new OpenPgpSecretKeyBackupPassphrase(StringUtils.secureOfflineAttackSafeRandomString());
    }

    public static SecretkeyElement createSecretkeyElement(OpenPgpProvider provider, BareJid owner, Set<OpenPgpV4Fingerprint> fingerprints, OpenPgpSecretKeyBackupPassphrase backupCode) throws PGPException, IOException, MissingOpenPgpKeyException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        for (OpenPgpV4Fingerprint fingerprint : fingerprints) {
            PGPSecretKeyRing key = provider.getStore().getSecretKeyRing(owner, fingerprint);
            if (key == null) {
                throw new MissingOpenPgpKeyException(owner, fingerprint);
            }
            byte[] bytes = key.getEncoded();
            buffer.write(bytes);
        }
        return SecretKeyBackupHelper.createSecretkeyElement(buffer.toByteArray(), backupCode);
    }

    public static SecretkeyElement createSecretkeyElement(byte[] keys, OpenPgpSecretKeyBackupPassphrase backupCode) throws PGPException, IOException {
        ByteArrayInputStream keyStream = new ByteArrayInputStream(keys);
        ByteArrayOutputStream cryptOut = new ByteArrayOutputStream();
        EncryptionOptions encOpts = new EncryptionOptions().addPassphrase(Passphrase.fromPassword((String)backupCode.toString()));
        encOpts.overrideEncryptionAlgorithm(SymmetricKeyAlgorithm.AES_256);
        EncryptionStream encryptionStream = PGPainless.encryptAndOrSign().onOutputStream((OutputStream)cryptOut).withOptions(ProducerOptions.encrypt((EncryptionOptions)encOpts).setAsciiArmor(false));
        Streams.pipeAll((InputStream)keyStream, (OutputStream)encryptionStream);
        encryptionStream.close();
        return new SecretkeyElement(Base64.encode((byte[])cryptOut.toByteArray()));
    }

    public static PGPSecretKeyRing restoreSecretKeyBackup(SecretkeyElement backup, OpenPgpSecretKeyBackupPassphrase backupCode) throws InvalidBackupCodeException, IOException, PGPException {
        byte[] encrypted = Base64.decode((byte[])backup.getB64Data());
        ByteArrayInputStream encryptedIn = new ByteArrayInputStream(encrypted);
        ByteArrayOutputStream plaintextOut = new ByteArrayOutputStream();
        try {
            DecryptionStream decryptionStream = PGPainless.decryptAndOrVerify().onInputStream((InputStream)encryptedIn).withOptions(new ConsumerOptions().addDecryptionPassphrase(Passphrase.fromPassword((String)backupCode.toString())));
            Streams.pipeAll((InputStream)decryptionStream, (OutputStream)plaintextOut);
            decryptionStream.close();
        }
        catch (MissingDecryptionMethodException e) {
            throw new InvalidBackupCodeException("Could not decrypt secret key backup. Possibly wrong passphrase?", e);
        }
        byte[] decrypted = plaintextOut.toByteArray();
        return PGPainless.readKeyRing().secretKeyRing(decrypted);
    }
}

