/*
 * Decompiled with CFR 0.152.
 */
package org.igniterealtime.smack.smackrepl;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.igniterealtime.smack.inttest.util.SimpleResultSyncPoint;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.roster.Roster;
import org.jivesoftware.smack.roster.RosterUtil;
import org.jivesoftware.smack.tcp.XMPPTCPConnection;
import org.jivesoftware.smack.tcp.XMPPTCPConnectionConfiguration;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.iot.IoTDiscoveryIntegrationTest;
import org.jivesoftware.smackx.iot.Thing;
import org.jivesoftware.smackx.iot.data.IoTDataManager;
import org.jivesoftware.smackx.iot.data.ThingMomentaryReadOutRequest;
import org.jivesoftware.smackx.iot.data.ThingMomentaryReadOutResult;
import org.jivesoftware.smackx.iot.data.element.IoTDataField;
import org.jivesoftware.smackx.iot.data.element.IoTFieldsExtension;
import org.jivesoftware.smackx.iot.discovery.AbstractThingStateChangeListener;
import org.jivesoftware.smackx.iot.discovery.IoTDiscoveryManager;
import org.jivesoftware.smackx.iot.discovery.ThingState;
import org.jivesoftware.smackx.iot.discovery.ThingStateChangeListener;
import org.jivesoftware.smackx.iot.provisioning.IoTProvisioningManager;
import org.jxmpp.jid.BareJid;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.impl.JidCreate;

public class IoT {
    private static final long TIMEOUT = 600000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void iotScenario(String dataThingJidString, String dataThingPassword, String readingThingJidString, String readingThingPassword) throws TimeoutException, Exception {
        EntityBareJid dataThingJid = JidCreate.entityBareFrom((String)dataThingJidString);
        EntityBareJid readingThingJid = JidCreate.entityBareFrom((String)readingThingJidString);
        XMPPTCPConnectionConfiguration dataThingConnectionConfiguration = ((XMPPTCPConnectionConfiguration.Builder)((XMPPTCPConnectionConfiguration.Builder)((XMPPTCPConnectionConfiguration.Builder)((XMPPTCPConnectionConfiguration.Builder)XMPPTCPConnectionConfiguration.builder().setUsernameAndPassword((CharSequence)dataThingJid.getLocalpart(), dataThingPassword)).setXmppDomain(dataThingJid.asDomainBareJid())).setSecurityMode(ConnectionConfiguration.SecurityMode.disabled)).setDebuggerEnabled(true)).build();
        XMPPTCPConnectionConfiguration readingThingConnectionConfiguration = ((XMPPTCPConnectionConfiguration.Builder)((XMPPTCPConnectionConfiguration.Builder)((XMPPTCPConnectionConfiguration.Builder)((XMPPTCPConnectionConfiguration.Builder)XMPPTCPConnectionConfiguration.builder().setUsernameAndPassword((CharSequence)readingThingJid.getLocalpart(), readingThingPassword)).setXmppDomain(readingThingJid.asDomainBareJid())).setSecurityMode(ConnectionConfiguration.SecurityMode.disabled)).setDebuggerEnabled(true)).build();
        XMPPTCPConnection dataThingConnection = new XMPPTCPConnection(dataThingConnectionConfiguration);
        XMPPTCPConnection readingThingConnection = new XMPPTCPConnection(readingThingConnectionConfiguration);
        dataThingConnection.setPacketReplyTimeout(600000L);
        readingThingConnection.setPacketReplyTimeout(600000L);
        try {
            IoT.iotScenario(dataThingConnection, readingThingConnection);
        }
        finally {
            dataThingConnection.disconnect();
            readingThingConnection.disconnect();
        }
    }

    public static void iotScenario(XMPPTCPConnection dataThingConnection, XMPPTCPConnection readingThingConnection) throws TimeoutException, Exception {
        dataThingConnection.connect().login();
        readingThingConnection.connect().login();
        ThingState dataThingState = IoT.actAsDataThing(dataThingConnection);
        final SimpleResultSyncPoint syncPoint = new SimpleResultSyncPoint();
        dataThingState.setThingStateChangeListener((ThingStateChangeListener)new AbstractThingStateChangeListener(){

            public void owned(BareJid jid) {
                syncPoint.signal();
            }
        });
        syncPoint.waitForResult(600000L);
        IoT.printStatus("OWNED - Thing now onwed by " + dataThingState.getOwner());
        IoTProvisioningManager readingThingProvisioningManager = IoTProvisioningManager.getInstanceFor((XMPPConnection)readingThingConnection);
        readingThingProvisioningManager.sendFriendshipRequestIfRequired(dataThingConnection.getUser().asBareJid());
        Roster dataThingRoster = Roster.getInstanceFor((XMPPConnection)dataThingConnection);
        RosterUtil.waitUntilOtherEntityIsSubscribed((Roster)dataThingRoster, (BareJid)readingThingConnection.getUser().asBareJid(), (long)600000L);
        IoT.printStatus("FRIENDSHIP ACCEPTED - Trying to read out data");
        IoTDataManager readingThingDataManager = IoTDataManager.getInstanceFor((XMPPConnection)readingThingConnection);
        List values = readingThingDataManager.requestMomentaryValuesReadOut(dataThingConnection.getUser());
        if (values.size() != 1) {
            throw new IllegalStateException("Unexpected number of values returned: " + values.size());
        }
        IoTFieldsExtension field = (IoTFieldsExtension)values.get(0);
        IoT.printStatus("DATA READ-OUT SUCCESS: " + field.toXML());
        IoT.printStatus("IoT SCENARIO FINISHED SUCCESSFULLY");
    }

    private static ThingState actAsDataThing(XMPPTCPConnection connection) throws XMPPException, SmackException, InterruptedException {
        String key = StringUtils.randomString((int)12);
        String sn = StringUtils.randomString((int)12);
        Thing dataThing = Thing.builder().setKey(key).setSerialNumber(sn).setManufacturer("Ignite Realtime").setModel("Smack").setVersion("0.1").setMomentaryReadOutRequestHandler(new ThingMomentaryReadOutRequest(){

            public void momentaryReadOutRequest(ThingMomentaryReadOutResult callback) {
                IoTDataField.IntField field = new IoTDataField.IntField("timestamp", (int)(System.currentTimeMillis() / 1000L));
                callback.momentaryReadOut(Collections.singletonList(field));
            }
        }).build();
        IoTDiscoveryManager iotDiscoveryManager = IoTDiscoveryManager.getInstanceFor((XMPPConnection)connection);
        ThingState state = IoTDiscoveryIntegrationTest.registerThing((IoTDiscoveryManager)iotDiscoveryManager, (Thing)dataThing);
        IoT.printStatus("SUCCESS: Thing registered:" + dataThing);
        return state;
    }

    private static void printStatus(CharSequence status) {
        System.out.println(status);
    }

    public static void main(String[] args) throws TimeoutException, Exception {
        if (args.length != 4) {
            throw new IllegalArgumentException();
        }
        IoT.iotScenario(args[0], args[1], args[2], args[3]);
    }
}

