/*
 * Decompiled with CFR 0.152.
 */
package org.igniterealtime.smack.smackrepl;

import java.io.IOException;
import java.util.Date;
import java.util.logging.Logger;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.compression.XMPPInputOutputStream;
import org.jivesoftware.smack.debugger.ConsoleDebugger;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.tcp.XMPPTCPConnectionConfiguration;
import org.jivesoftware.smack.tcp.XmppNioTcpConnection;
import org.jxmpp.util.XmppDateTime;

public class Nio {
    private static final Logger LOGGER = Logger.getLogger(Nio.class.getName());

    public static void main(String[] args) throws SmackException, IOException, XMPPException, InterruptedException {
        Nio.doNio(args[0], args[1], args[2]);
    }

    public static void doNio(String username, String password, String service) throws SmackException, IOException, XMPPException, InterruptedException {
        boolean useTls = true;
        boolean useCompression = true;
        boolean useFullFlush = true;
        boolean javaNetDebug = false;
        boolean smackDebug = false;
        if (useFullFlush) {
            XMPPInputOutputStream.setFlushMethod((XMPPInputOutputStream.FlushMethod)XMPPInputOutputStream.FlushMethod.FULL_FLUSH);
        }
        if (javaNetDebug) {
            System.setProperty("javax.net.debug", "all");
        }
        ConnectionConfiguration.SecurityMode securityMode = useTls ? ConnectionConfiguration.SecurityMode.required : ConnectionConfiguration.SecurityMode.disabled;
        Object smackDebuggerFactory = smackDebug ? ConsoleDebugger.Factory.INSTANCE : null;
        XMPPTCPConnectionConfiguration configuration = ((XMPPTCPConnectionConfiguration.Builder)((XMPPTCPConnectionConfiguration.Builder)((XMPPTCPConnectionConfiguration.Builder)((XMPPTCPConnectionConfiguration.Builder)((XMPPTCPConnectionConfiguration.Builder)XMPPTCPConnectionConfiguration.builder().setUsernameAndPassword((CharSequence)username, password)).setXmppDomain(service)).setDebuggerFactory(smackDebuggerFactory)).setCompressionEnabled(useCompression)).setSecurityMode(securityMode)).build();
        XmppNioTcpConnection connection = new XmppNioTcpConnection(configuration);
        connection.setReplyTimeout(300000L);
        connection.addConnectionStateMachineListener((event, c) -> LOGGER.info("Connection event: " + event));
        connection.connect();
        connection.login();
        Message message = new Message("flo@geekplace.eu", "It is alive! " + XmppDateTime.formatXEP0082Date((Date)new Date()));
        connection.sendStanza((Stanza)message);
        Thread.sleep(1000L);
        connection.disconnect();
        XmppNioTcpConnection.Stats connectionStats = connection.getStats();
        System.out.println("NIO successfully finished, yeah!\n" + connectionStats);
    }
}

