/*
 * Decompiled with CFR 0.152.
 */
package org.igniterealtime.smack.smackrepl;

import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.logging.Logger;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.c2s.ModularXmppClientToServerConnection;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.MessageBuilder;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.tcp.XMPPTCPConnection;
import org.jivesoftware.smack.tcp.XMPPTCPConnectionConfiguration;
import org.jivesoftware.smack.util.TLSUtils;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.iqregister.AccountManager;
import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.jid.parts.Localpart;
import org.jxmpp.stringprep.XmppStringprepException;
import org.jxmpp.util.XmppDateTime;

public class XmppTools {
    public static void main(String[] args) throws SmackException, IOException, XMPPException, InterruptedException, KeyManagementException, NoSuchAlgorithmException {
        boolean one = XmppTools.createAccount("xmpp.foobar.io", "smack1", "smack1");
        boolean two = XmppTools.createAccount("xmpp.foobar.io", "smack2", "smack2");
        System.out.println("Account created: " + one + " " + two);
    }

    public static boolean supportsIbr(String xmppDomain) throws SmackException, IOException, XMPPException, InterruptedException, KeyManagementException, NoSuchAlgorithmException {
        DomainBareJid xmppDomainJid = JidCreate.domainBareFrom((String)xmppDomain);
        return XmppTools.supportsIbr(xmppDomainJid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean supportsIbr(DomainBareJid xmppDomain) throws SmackException, IOException, XMPPException, InterruptedException, KeyManagementException, NoSuchAlgorithmException {
        XMPPTCPConnectionConfiguration.Builder configBuilder = (XMPPTCPConnectionConfiguration.Builder)XMPPTCPConnectionConfiguration.builder().setXmppDomain(xmppDomain);
        TLSUtils.acceptAllCertificates((ConnectionConfiguration.Builder)configBuilder);
        XMPPTCPConnectionConfiguration config = configBuilder.build();
        XMPPTCPConnection connection = new XMPPTCPConnection(config);
        connection.connect();
        try {
            boolean bl = XmppTools.supportsIbr((XMPPConnection)connection);
            return bl;
        }
        finally {
            connection.disconnect();
        }
    }

    public static boolean supportsIbr(XMPPConnection connection) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        AccountManager accountManager = AccountManager.getInstance((XMPPConnection)connection);
        return accountManager.supportsAccountCreation();
    }

    public static boolean createAccount(String xmppDomain, String username, String password) throws KeyManagementException, NoSuchAlgorithmException, SmackException, IOException, XMPPException, InterruptedException {
        DomainBareJid xmppDomainJid = JidCreate.domainBareFrom((String)xmppDomain);
        Localpart localpart = Localpart.from((String)username);
        return XmppTools.createAccount(xmppDomainJid, localpart, password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean createAccount(DomainBareJid xmppDomain, Localpart username, String password) throws KeyManagementException, NoSuchAlgorithmException, SmackException, IOException, XMPPException, InterruptedException {
        XMPPTCPConnectionConfiguration.Builder configBuilder = (XMPPTCPConnectionConfiguration.Builder)XMPPTCPConnectionConfiguration.builder().setXmppDomain(xmppDomain);
        TLSUtils.acceptAllCertificates((ConnectionConfiguration.Builder)configBuilder);
        XMPPTCPConnectionConfiguration config = configBuilder.build();
        XMPPTCPConnection connection = new XMPPTCPConnection(config);
        connection.connect();
        try {
            if (!XmppTools.supportsIbr((XMPPConnection)connection)) {
                boolean bl = false;
                return bl;
            }
            AccountManager accountManager = AccountManager.getInstance((XMPPConnection)connection);
            accountManager.createAccount(username, password);
            boolean bl = true;
            return bl;
        }
        finally {
            connection.disconnect();
        }
    }

    public static void modularConnectionTest(ModularXmppClientToServerConnection connection, String messageTo) throws XMPPException, SmackException, IOException, InterruptedException {
        connection.addConnectionStateMachineListener((event, c) -> Logger.getAnonymousLogger().info("Connection event: " + event));
        connection.connect();
        connection.login();
        XmppTools.sendItsAlive(messageTo, (XMPPConnection)connection);
        Thread.sleep(1000L);
        connection.disconnect();
        ModularXmppClientToServerConnection.Stats connectionStats = connection.getStats();
        ServiceDiscoveryManager.Stats serviceDiscoveryManagerStats = ServiceDiscoveryManager.getInstanceFor((XMPPConnection)connection).getStats();
        System.out.println("NIO successfully finished, yeah!\n" + connectionStats + "\n" + serviceDiscoveryManagerStats);
    }

    public static void sendItsAlive(String to, XMPPConnection connection) throws XmppStringprepException, SmackException.NotConnectedException, InterruptedException {
        if (to == null) {
            return;
        }
        Message message = ((MessageBuilder)connection.getStanzaFactory().buildMessageStanza().to((CharSequence)to)).setBody("It is alive! " + XmppDateTime.formatXEP0082Date((Date)new Date())).build();
        connection.sendStanza((Stanza)message);
    }
}

