/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util.dns.dnsjava;

import java.util.ArrayList;
import java.util.List;
import org.jivesoftware.smack.initializer.SmackInitializer;
import org.jivesoftware.smack.util.DNSUtil;
import org.jivesoftware.smack.util.dns.DNSResolver;
import org.jivesoftware.smack.util.dns.SRVRecord;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Record;
import org.xbill.DNS.TextParseException;

public class DNSJavaResolver
implements SmackInitializer,
DNSResolver {
    private static DNSJavaResolver instance = new DNSJavaResolver();

    public static DNSResolver getInstance() {
        return instance;
    }

    public List<SRVRecord> lookupSRVRecords(String name) throws TextParseException {
        ArrayList<SRVRecord> res = new ArrayList<SRVRecord>();
        Lookup lookup = new Lookup(name, 33);
        Record[] recs = lookup.run();
        if (recs == null) {
            return res;
        }
        for (Record record : recs) {
            org.xbill.DNS.SRVRecord srvRecord = (org.xbill.DNS.SRVRecord)record;
            if (srvRecord == null || srvRecord.getTarget() == null) continue;
            String host = srvRecord.getTarget().toString();
            int port = srvRecord.getPort();
            int priority = srvRecord.getPriority();
            int weight = srvRecord.getWeight();
            SRVRecord r = new SRVRecord(host, port, priority, weight);
            res.add(r);
        }
        return res;
    }

    public static void setup() {
        DNSUtil.setDNSResolver((DNSResolver)DNSJavaResolver.getInstance());
    }

    public List<Exception> initialize() {
        DNSJavaResolver.setup();
        return null;
    }
}

