/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util.dns.dnsjava;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.initializer.SmackInitializer;
import org.jivesoftware.smack.util.DNSUtil;
import org.jivesoftware.smack.util.dns.DNSResolver;
import org.jivesoftware.smack.util.dns.HostAddress;
import org.jivesoftware.smack.util.dns.SRVRecord;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Record;
import org.xbill.DNS.TextParseException;

public class DNSJavaResolver
extends DNSResolver
implements SmackInitializer {
    private static DNSJavaResolver instance = new DNSJavaResolver();

    public static DNSResolver getInstance() {
        return instance;
    }

    public DNSJavaResolver() {
        super(false);
    }

    protected List<SRVRecord> lookupSRVRecords0(String name, List<HostAddress> failedAddresses, ConnectionConfiguration.DnssecMode dnssecMode) {
        Lookup lookup;
        ArrayList<SRVRecord> res = new ArrayList<SRVRecord>();
        try {
            lookup = new Lookup(name, 33);
        }
        catch (TextParseException e) {
            throw new IllegalStateException(e);
        }
        Record[] recs = lookup.run();
        if (recs == null) {
            return res;
        }
        for (Record record : recs) {
            org.xbill.DNS.SRVRecord srvRecord = (org.xbill.DNS.SRVRecord)record;
            if (srvRecord == null || srvRecord.getTarget() == null) continue;
            String host = srvRecord.getTarget().toString();
            int port = srvRecord.getPort();
            int priority = srvRecord.getPriority();
            int weight = srvRecord.getWeight();
            List hostAddresses = this.lookupHostAddress0(host, failedAddresses, dnssecMode);
            if (hostAddresses == null || hostAddresses.isEmpty()) {
                if (!hostAddresses.isEmpty()) continue;
                LOGGER.log(Level.INFO, "The DNS name " + name + ", points to a hostname (" + host + ") which has neither A or AAAA resource records. This is an indication of a broken DNS setup.");
                continue;
            }
            SRVRecord r = new SRVRecord(host, port, priority, weight, hostAddresses);
            res.add(r);
        }
        return res;
    }

    public static void setup() {
        DNSUtil.setDNSResolver((DNSResolver)DNSJavaResolver.getInstance());
    }

    public List<Exception> initialize() {
        DNSJavaResolver.setup();
        return null;
    }
}

