/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util.dns.dnsjava;

import java.util.ArrayList;
import java.util.List;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.initializer.SmackInitializer;
import org.jivesoftware.smack.util.DNSUtil;
import org.jivesoftware.smack.util.dns.DNSResolver;
import org.jivesoftware.smack.util.rce.RemoteConnectionEndpointLookupFailure;
import org.minidns.dnsname.DnsName;
import org.minidns.record.SRV;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Record;
import org.xbill.DNS.SRVRecord;
import org.xbill.DNS.TextParseException;

public class DNSJavaResolver
extends DNSResolver
implements SmackInitializer {
    private static final DNSJavaResolver instance = new DNSJavaResolver();

    public static DNSResolver getInstance() {
        return instance;
    }

    public DNSJavaResolver() {
        super(false);
    }

    protected List<SRV> lookupSrvRecords0(DnsName name, List<RemoteConnectionEndpointLookupFailure> lookupFailures, ConnectionConfiguration.DnssecMode dnssecMode) {
        Lookup lookup;
        try {
            lookup = new Lookup(name.ace, 33);
        }
        catch (TextParseException e) {
            RemoteConnectionEndpointLookupFailure.DnsLookupFailure failure = new RemoteConnectionEndpointLookupFailure.DnsLookupFailure(name, (Exception)((Object)e));
            lookupFailures.add((RemoteConnectionEndpointLookupFailure)failure);
            return null;
        }
        Record[] recs = lookup.run();
        if (recs == null) {
            return null;
        }
        ArrayList<SRV> res = new ArrayList<SRV>();
        for (Record record : recs) {
            SRVRecord srvRecord = (SRVRecord)record;
            if (srvRecord == null || srvRecord.getTarget() == null) continue;
            DnsName host = DnsName.from((String)srvRecord.getTarget().toString());
            int port = srvRecord.getPort();
            int priority = srvRecord.getPriority();
            int weight = srvRecord.getWeight();
            SRV r = new SRV(priority, weight, port, host);
            res.add(r);
        }
        return res;
    }

    public static void setup() {
        DNSUtil.setDNSResolver((DNSResolver)DNSJavaResolver.getInstance());
    }

    public List<Exception> initialize() {
        DNSJavaResolver.setup();
        return null;
    }
}

