/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.dox.resolver.minidns;

import java.io.IOException;
import java.net.InetAddress;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jivesoftware.smackx.dox.resolver.minidns.DnsOverXmppMiniDnsResolver;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.minidns.DnsCache;
import org.minidns.DnsClient;
import org.minidns.MiniDnsFuture;
import org.minidns.dnsmessage.DnsMessage;
import org.minidns.dnsmessage.Question;
import org.minidns.dnsname.DnsName;
import org.minidns.dnsqueryresult.CachedDnsQueryResult;
import org.minidns.dnsqueryresult.DnsQueryResult;
import org.minidns.dnssec.DnssecClient;
import org.minidns.dnssec.DnssecValidationFailedException;
import org.minidns.record.Record;
import org.minidns.source.DnsDataSource;

public final class DnsOverXmppMiniDnsResolverTest {
    @Test
    public void dnsOverXmppMiniDnsResolverTest() throws IOException {
        TestDnsDataSource dnsSource = new TestDnsDataSource();
        TestDnsDataSource dnssecSource = new TestDnsDataSource();
        DnsClient dnsClient = new DnsClient((DnsCache)NoopDnsCache.INSTANCE);
        dnsClient.setDataSource((DnsDataSource)dnsSource);
        DnssecClient dnssecClient = new DnssecClient((DnsCache)NoopDnsCache.INSTANCE);
        dnssecClient.setDataSource((DnsDataSource)dnssecSource);
        DnsOverXmppMiniDnsResolver doxResolver = new DnsOverXmppMiniDnsResolver(dnsClient, dnssecClient);
        Question question = new Question((CharSequence)"example.org", Record.TYPE.A);
        DnsMessage nondnssecQuery = question.asQueryMessage();
        doxResolver.resolve(nondnssecQuery);
        Assertions.assertTrue((boolean)dnsSource.getAndResetWasQueried());
        Assertions.assertFalse((boolean)dnssecSource.getAndResetWasQueried());
        DnsMessage.Builder dnssecQueryBuilder = question.asMessageBuilder();
        dnssecQueryBuilder.getEdnsBuilder().setDnssecOk();
        DnsMessage dnssecQuery = dnssecQueryBuilder.build();
        DnssecValidationFailedException dnssecValidationFailedException = null;
        try {
            doxResolver.resolve(dnssecQuery);
        }
        catch (DnssecValidationFailedException e) {
            dnssecValidationFailedException = e;
        }
        Assertions.assertNotNull((Object)((Object)dnssecValidationFailedException));
        Assertions.assertFalse((boolean)dnsSource.getAndResetWasQueried());
        Assertions.assertTrue((boolean)dnssecSource.getAndResetWasQueried());
    }

    private static class NoopDnsCache
    extends DnsCache {
        private static final NoopDnsCache INSTANCE = new NoopDnsCache();

        private NoopDnsCache() {
        }

        protected void putNormalized(DnsMessage normalizedQuery, DnsQueryResult result) {
        }

        public void offer(DnsMessage query, DnsQueryResult result, DnsName authoritativeZone) {
        }

        protected CachedDnsQueryResult getNormalized(DnsMessage normalizedQuery) {
            return null;
        }
    }

    public static class TestDnsDataSource
    implements DnsDataSource {
        private final AtomicBoolean wasQueried = new AtomicBoolean();

        public boolean getAndResetWasQueried() {
            return this.wasQueried.getAndSet(false);
        }

        private void setWasQueried() {
            this.wasQueried.set(true);
        }

        public DnsQueryResult query(DnsMessage query, InetAddress address, int port) throws IOException {
            this.setWasQueried();
            return new TestDnsQueryResult(query);
        }

        public MiniDnsFuture<DnsQueryResult, IOException> queryAsync(DnsMessage query, InetAddress address, int port, DnsDataSource.OnResponseCallback onResponseCallback) {
            this.setWasQueried();
            TestDnsQueryResult result = new TestDnsQueryResult(query);
            return MiniDnsFuture.from((Object)((Object)result));
        }

        public int getUdpPayloadSize() {
            return 0;
        }

        public int getTimeout() {
            return 0;
        }

        public void setTimeout(int timeout) {
        }

        private static class TestDnsQueryResult
        extends DnsQueryResult {
            protected TestDnsQueryResult(DnsMessage query) {
                super(DnsQueryResult.QueryMethod.testWorld, query, TestDnsQueryResult.createNxDomainAnswerFor(query));
            }

            private static DnsMessage createNxDomainAnswerFor(DnsMessage query) {
                Question question = query.getQuestion();
                DnsMessage response = DnsMessage.builder().setQuestion(question).setRecursionAvailable(true).setResponseCode(DnsMessage.RESPONSE_CODE.NX_DOMAIN).build();
                return response;
            }
        }
    }
}

