/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util.dns.minidns;

import de.measite.minidns.Client;
import de.measite.minidns.DNSCache;
import de.measite.minidns.DNSMessage;
import de.measite.minidns.Question;
import de.measite.minidns.Record;
import de.measite.minidns.record.SRV;
import java.util.LinkedList;
import java.util.List;
import org.jivesoftware.smack.initializer.SmackAndOsgiInitializer;
import org.jivesoftware.smack.util.DNSUtil;
import org.jivesoftware.smack.util.dns.DNSResolver;
import org.jivesoftware.smack.util.dns.SRVRecord;
import org.jxmpp.util.cache.ExpirationCache;

public class MiniDnsResolver
extends SmackAndOsgiInitializer
implements DNSResolver {
    private static final long ONE_DAY = 86400000L;
    private static final MiniDnsResolver instance = new MiniDnsResolver();
    private static final ExpirationCache<Question, DNSMessage> cache = new ExpirationCache(10, 86400000L);
    private final Client client = new Client(new DNSCache(){

        public DNSMessage get(Question question) {
            return (DNSMessage)cache.get((Object)question);
        }

        public void put(Question question, DNSMessage message) {
            long expirationTime = 86400000L;
            for (Record record : message.getAnswers()) {
                if (!record.isAnswer(question)) continue;
                expirationTime = record.getTtl();
                break;
            }
            cache.put((Object)question, (Object)message, expirationTime);
        }
    });

    public static DNSResolver getInstance() {
        return instance;
    }

    public List<SRVRecord> lookupSRVRecords(String name) {
        LinkedList<SRVRecord> res = new LinkedList<SRVRecord>();
        DNSMessage message = this.client.query(name, Record.TYPE.SRV, Record.CLASS.IN);
        if (message == null) {
            return res;
        }
        for (Record record : message.getAnswers()) {
            SRV srv = (SRV)record.getPayload();
            res.add(new SRVRecord(srv.getName(), srv.getPort(), srv.getPriority(), srv.getWeight()));
        }
        return res;
    }

    public static void setup() {
        DNSUtil.setDNSResolver((DNSResolver)MiniDnsResolver.getInstance());
    }

    public List<Exception> initialize() {
        MiniDnsResolver.setup();
        return null;
    }
}

