/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util.dns.minidns;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.initializer.SmackInitializer;
import org.jivesoftware.smack.util.DNSUtil;
import org.jivesoftware.smack.util.dns.DNSResolver;
import org.jivesoftware.smack.util.dns.HostAddress;
import org.jivesoftware.smack.util.dns.SRVRecord;
import org.jivesoftware.smack.util.dns.minidns.MiniDnsDane;
import org.minidns.dnsmessage.DnsMessage;
import org.minidns.dnsmessage.Question;
import org.minidns.dnsname.DnsName;
import org.minidns.dnssec.UnverifiedReason;
import org.minidns.hla.DnssecResolverApi;
import org.minidns.hla.ResolutionUnsuccessfulException;
import org.minidns.hla.ResolverApi;
import org.minidns.hla.ResolverResult;
import org.minidns.hla.SrvResolverResult;
import org.minidns.record.A;
import org.minidns.record.AAAA;
import org.minidns.record.SRV;

public class MiniDnsResolver
extends DNSResolver
implements SmackInitializer {
    private static final MiniDnsResolver INSTANCE = new MiniDnsResolver();
    private static final ResolverApi DNSSEC_RESOLVER = DnssecResolverApi.INSTANCE;
    private static final ResolverApi NON_DNSSEC_RESOLVER = ResolverApi.INSTANCE;

    public static DNSResolver getInstance() {
        return INSTANCE;
    }

    public MiniDnsResolver() {
        super(true);
    }

    protected List<SRVRecord> lookupSRVRecords0(DnsName name, List<HostAddress> failedAddresses, ConnectionConfiguration.DnssecMode dnssecMode) {
        SrvResolverResult result;
        ResolverApi resolver = MiniDnsResolver.getResolver(dnssecMode);
        try {
            result = resolver.resolveSrv(name);
        }
        catch (IOException e) {
            failedAddresses.add(new HostAddress(name, (Exception)e));
            return null;
        }
        ResolutionUnsuccessfulException resolutionUnsuccessfulException = result.getResolutionUnsuccessfulException();
        if (resolutionUnsuccessfulException != null) {
            failedAddresses.add(new HostAddress(name, (Exception)resolutionUnsuccessfulException));
            return null;
        }
        if (MiniDnsResolver.shouldAbortIfNotAuthentic(name, dnssecMode, result, failedAddresses)) {
            return null;
        }
        LinkedList<SRVRecord> res = new LinkedList<SRVRecord>();
        for (SRV srv : result.getAnswers()) {
            DnsName hostname = srv.target;
            List<InetAddress> hostAddresses = this.lookupHostAddress0(hostname, failedAddresses, dnssecMode);
            if (this.shouldContinue((CharSequence)name, (CharSequence)hostname, hostAddresses)) continue;
            SRVRecord srvRecord = new SRVRecord(hostname, srv.port, srv.priority, srv.weight, hostAddresses);
            res.add(srvRecord);
        }
        return res;
    }

    protected List<InetAddress> lookupHostAddress0(DnsName name, List<HostAddress> failedAddresses, ConnectionConfiguration.DnssecMode dnssecMode) {
        InetAddress inetAddress;
        ResolverResult aaaaResult;
        ResolverResult aResult;
        ResolverApi resolver = MiniDnsResolver.getResolver(dnssecMode);
        try {
            aResult = resolver.resolve(name, A.class);
            aaaaResult = resolver.resolve(name, AAAA.class);
        }
        catch (IOException e) {
            failedAddresses.add(new HostAddress(name, (Exception)e));
            return null;
        }
        if (!aResult.wasSuccessful() && !aaaaResult.wasSuccessful()) {
            failedAddresses.add(new HostAddress(name, (Exception)MiniDnsResolver.getExceptionFrom(aResult)));
            failedAddresses.add(new HostAddress(name, (Exception)MiniDnsResolver.getExceptionFrom(aaaaResult)));
            return null;
        }
        if (MiniDnsResolver.shouldAbortIfNotAuthentic(name, dnssecMode, aResult, failedAddresses) || MiniDnsResolver.shouldAbortIfNotAuthentic(name, dnssecMode, aaaaResult, failedAddresses)) {
            return null;
        }
        Set aResults = aResult.wasSuccessful() ? aResult.getAnswers() : Collections.emptySet();
        Set aaaaResults = aaaaResult.wasSuccessful() ? aaaaResult.getAnswers() : Collections.emptySet();
        ArrayList<InetAddress> inetAddresses = new ArrayList<InetAddress>(aResults.size() + aaaaResults.size());
        for (A a : aResults) {
            try {
                inetAddress = InetAddress.getByAddress(a.getIp());
            }
            catch (UnknownHostException e) {
                continue;
            }
            inetAddresses.add(inetAddress);
        }
        for (AAAA aaaa : aaaaResults) {
            try {
                inetAddress = InetAddress.getByAddress(name.ace, aaaa.getIp());
            }
            catch (UnknownHostException e) {
                continue;
            }
            inetAddresses.add(inetAddress);
        }
        return inetAddresses;
    }

    public static void setup() {
        DNSUtil.setDNSResolver((DNSResolver)MiniDnsResolver.getInstance());
    }

    public List<Exception> initialize() {
        MiniDnsResolver.setup();
        MiniDnsDane.setup();
        return null;
    }

    private static ResolverApi getResolver(ConnectionConfiguration.DnssecMode dnssecMode) {
        if (dnssecMode == ConnectionConfiguration.DnssecMode.disabled) {
            return NON_DNSSEC_RESOLVER;
        }
        return DNSSEC_RESOLVER;
    }

    private static boolean shouldAbortIfNotAuthentic(DnsName name, ConnectionConfiguration.DnssecMode dnssecMode, ResolverResult<?> result, List<HostAddress> failedAddresses) {
        switch (dnssecMode) {
            case needsDnssec: 
            case needsDnssecAndDane: {
                if (result.isAuthenticData()) break;
                Exception exception = new Exception("DNSSEC verification failed: " + ((UnverifiedReason)result.getUnverifiedReasons().iterator().next()).getReasonString());
                failedAddresses.add(new HostAddress(name, exception));
                return true;
            }
            case disabled: {
                break;
            }
            default: {
                throw new IllegalStateException("Unknown DnssecMode: " + dnssecMode);
            }
        }
        return false;
    }

    private static ResolutionUnsuccessfulException getExceptionFrom(ResolverResult<?> result) {
        Question question = result.getQuestion();
        DnsMessage.RESPONSE_CODE responseCode = result.getResponseCode();
        ResolutionUnsuccessfulException resolutionUnsuccessfulException = new ResolutionUnsuccessfulException(question, responseCode);
        return resolutionUnsuccessfulException;
    }
}

