/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.sasl.javax;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.RealmChoiceCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.sasl.SASLMechanism;

public abstract class SASLJavaXMechanism
extends SASLMechanism {
    protected SaslClient sc;

    public abstract String getName();

    public final void checkIfSuccessfulOrThrow() throws SmackException {
        if (!this.sc.isComplete()) {
            throw new SmackException(this.getName() + " was not completed");
        }
    }

    protected void authenticateInternal() throws SmackException {
        String[] mechanisms = new String[]{this.getName()};
        Map<String, String> props = this.getSaslProps();
        try {
            this.sc = Sasl.createSaslClient(mechanisms, null, "xmpp", this.getServerName().toString(), props, new CallbackHandler(){

                @Override
                public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                    for (int i = 0; i < callbacks.length; ++i) {
                        if (callbacks[i] instanceof NameCallback) {
                            NameCallback ncb = (NameCallback)callbacks[i];
                            ncb.setName(SASLJavaXMechanism.this.authenticationId);
                            continue;
                        }
                        if (callbacks[i] instanceof PasswordCallback) {
                            PasswordCallback pcb = (PasswordCallback)callbacks[i];
                            pcb.setPassword(SASLJavaXMechanism.this.password.toCharArray());
                            continue;
                        }
                        if (callbacks[i] instanceof RealmCallback) {
                            RealmCallback rcb = (RealmCallback)callbacks[i];
                            String text = rcb.getDefaultText();
                            rcb.setText(text);
                            continue;
                        }
                        if (callbacks[i] instanceof RealmChoiceCallback) continue;
                        throw new UnsupportedCallbackException(callbacks[i]);
                    }
                }
            });
        }
        catch (SaslException e) {
            throw new SmackException((Throwable)e);
        }
    }

    protected void authenticateInternal(CallbackHandler cbh) throws SmackException {
        String[] mechanisms = new String[]{this.getName()};
        Map<String, String> props = this.getSaslProps();
        try {
            this.sc = Sasl.createSaslClient(mechanisms, null, "xmpp", this.host, props, cbh);
        }
        catch (SaslException e) {
            throw new SmackException((Throwable)e);
        }
    }

    protected byte[] getAuthenticationText() throws SmackException {
        if (this.sc.hasInitialResponse()) {
            try {
                return this.sc.evaluateChallenge(new byte[0]);
            }
            catch (SaslException e) {
                throw new SmackException((Throwable)e);
            }
        }
        return null;
    }

    protected byte[] evaluateChallenge(byte[] challenge) throws SmackException {
        try {
            if (challenge != null) {
                return this.sc.evaluateChallenge(challenge);
            }
            return this.sc.evaluateChallenge(new byte[0]);
        }
        catch (SaslException e) {
            throw new SmackException((Throwable)e);
        }
    }

    protected Map<String, String> getSaslProps() {
        return new HashMap<String, String>();
    }

    protected String getServerName() {
        return this.serviceName.toString();
    }
}

