/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.sasl.provided;

import java.nio.charset.StandardCharsets;
import javax.security.auth.callback.CallbackHandler;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.sasl.SASLMechanism;
import org.jivesoftware.smack.util.ByteUtils;
import org.jivesoftware.smack.util.MD5;
import org.jivesoftware.smack.util.StringUtils;

public class SASLDigestMD5Mechanism
extends SASLMechanism {
    public static final String NAME = "DIGEST-MD5";
    private static final String INITIAL_NONCE = "00000001";
    private static final String QOP_VALUE = "auth";
    private static boolean verifyServerResponse = true;
    private State state = State.INITIAL;
    private String nonce;
    private String cnonce;
    private String digestUri;
    private String hex_hashed_a1;

    public static void setVerifyServerResponse(boolean verifyServerResponse) {
        SASLDigestMD5Mechanism.verifyServerResponse = verifyServerResponse;
    }

    protected void authenticateInternal(CallbackHandler cbh) {
        throw new UnsupportedOperationException("CallbackHandler not (yet) supported");
    }

    protected byte[] getAuthenticationText() {
        return null;
    }

    public String getName() {
        return NAME;
    }

    public int getPriority() {
        return 210;
    }

    public SASLDigestMD5Mechanism newInstance() {
        return new SASLDigestMD5Mechanism();
    }

    public boolean authzidSupported() {
        return true;
    }

    public void checkIfSuccessfulOrThrow() throws SmackException.SmackSaslException {
        if (verifyServerResponse && this.state != State.VALID_SERVER_RESPONSE) {
            throw new SmackException.SmackSaslException("DIGEST-MD5 no valid server response");
        }
    }

    protected byte[] evaluateChallenge(byte[] challenge) throws SmackException.SmackSaslException {
        if (challenge.length == 0) {
            throw new SmackException.SmackSaslException("Initial challenge has zero length");
        }
        String challengeString = new String(challenge, StandardCharsets.UTF_8);
        String[] challengeParts = challengeString.split(",");
        byte[] response = null;
        switch (this.state.ordinal()) {
            case 0: {
                for (String part : challengeParts) {
                    String[] keyValue = part.split("=", 2);
                    String key = keyValue[0];
                    key = key.replaceFirst("^\\s+", "");
                    String value = keyValue[1];
                    if ("nonce".equals(key)) {
                        if (this.nonce != null) {
                            throw new SmackException.SmackSaslException("Nonce value present multiple times");
                        }
                        this.nonce = value.replace("\"", "");
                        continue;
                    }
                    if (!"qop".equals(key) || (value = value.replace("\"", "")).equals(QOP_VALUE)) continue;
                    throw new SmackException.SmackSaslException("Unsupported qop operation: " + value);
                }
                if (this.nonce == null) {
                    throw new SmackException.SmackSaslException("nonce value not present in initial challenge");
                }
                byte[] a1FirstPart = MD5.bytes((String)(this.authenticationId + ":" + String.valueOf(this.serviceName) + ":" + this.password));
                this.cnonce = StringUtils.randomString((int)32);
                byte[] a1 = ByteUtils.concat((byte[])a1FirstPart, (byte[])SASLDigestMD5Mechanism.toBytes((String)(":" + this.nonce + ":" + this.cnonce)));
                this.digestUri = "xmpp/" + String.valueOf(this.serviceName);
                this.hex_hashed_a1 = StringUtils.encodeHex((byte[])MD5.bytes((byte[])a1));
                String responseValue = this.calcResponse(DigestType.ClientResponse);
                Object authzid = this.authorizationId == null ? "" : ",authzid=\"" + String.valueOf(this.authorizationId) + "\"";
                String saslString = "username=\"" + SASLDigestMD5Mechanism.quoteBackslash(this.authenticationId) + "\"" + (String)authzid + ",realm=\"" + String.valueOf(this.serviceName) + "\",nonce=\"" + this.nonce + "\",cnonce=\"" + this.cnonce + "\",nc=00000001,qop=auth,digest-uri=\"" + this.digestUri + "\",response=" + responseValue + ",charset=utf-8";
                response = SASLDigestMD5Mechanism.toBytes((String)saslString);
                this.state = State.RESPONSE_SENT;
                break;
            }
            case 1: {
                if (verifyServerResponse) {
                    String serverResponse = null;
                    for (String part : challengeParts) {
                        String[] keyValue = part.split("=");
                        assert (keyValue.length == 2);
                        String key = keyValue[0];
                        String value = keyValue[1];
                        if (!"rspauth".equals(key)) continue;
                        serverResponse = value;
                        break;
                    }
                    if (serverResponse == null) {
                        throw new SmackException.SmackSaslException("No server response received while performing DIGEST-MD5 authentication");
                    }
                    String expectedServerResponse = this.calcResponse(DigestType.ServerResponse);
                    if (!serverResponse.equals(expectedServerResponse)) {
                        throw new SmackException.SmackSaslException("Invalid server response  while performing DIGEST-MD5 authentication");
                    }
                }
                this.state = State.VALID_SERVER_RESPONSE;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return response;
    }

    private String calcResponse(DigestType digestType) {
        StringBuilder a2 = new StringBuilder();
        if (digestType == DigestType.ClientResponse) {
            a2.append("AUTHENTICATE");
        }
        a2.append(':');
        a2.append(this.digestUri);
        String hex_hashed_a2 = StringUtils.encodeHex((byte[])MD5.bytes((String)a2.toString()));
        StringBuilder kd_argument = new StringBuilder();
        kd_argument.append(this.hex_hashed_a1);
        kd_argument.append(':');
        kd_argument.append(this.nonce);
        kd_argument.append(':');
        kd_argument.append(INITIAL_NONCE);
        kd_argument.append(':');
        kd_argument.append(this.cnonce);
        kd_argument.append(':');
        kd_argument.append(QOP_VALUE);
        kd_argument.append(':');
        kd_argument.append(hex_hashed_a2);
        byte[] kd = MD5.bytes((String)kd_argument.toString());
        String responseValue = StringUtils.encodeHex((byte[])kd);
        return responseValue;
    }

    public static String quoteBackslash(String string) {
        return string.replace("\\", "\\\\");
    }

    private static enum State {
        INITIAL,
        RESPONSE_SENT,
        VALID_SERVER_RESPONSE;

    }

    private static enum DigestType {
        ClientResponse,
        ServerResponse;

    }
}

