/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.sm.provider;

import com.jamesmurty.utils.XMLBuilder;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smack.packet.StanzaErrorTextElement;
import org.jivesoftware.smack.sm.packet.StreamManagement;
import org.jivesoftware.smack.sm.provider.ParseStreamManagement;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ParseStreamManagementTest {
    private static final Properties outputProperties = ParseStreamManagementTest.initOutputProperties();

    @Test
    public void testParseEnabled() throws Exception {
        String stanzaID = "zid615d9";
        boolean resume = true;
        String location = "test";
        int max = 42;
        String enabledStanza = XMLBuilder.create((String)"enabled").a("xmlns", "urn:xmpp:sm:3").a("id", "zid615d9").a("resume", String.valueOf(resume)).a("location", location).a("max", String.valueOf(max)).asString(outputProperties);
        StreamManagement.Enabled enabledPacket = ParseStreamManagement.enabled((XmlPullParser)PacketParserUtils.getParserFor((String)enabledStanza));
        Assertions.assertNotNull((Object)enabledPacket);
        Assertions.assertEquals((Object)enabledPacket.getId(), (Object)stanzaID);
        Assertions.assertEquals((Object)location, (Object)enabledPacket.getLocation());
        Assertions.assertEquals((Object)resume, (Object)enabledPacket.isResumeSet());
        Assertions.assertEquals((int)max, (int)enabledPacket.getMaxResumptionTime());
    }

    @Test
    public void testParseEnabledInvariant() throws XmlPullParserException, IOException {
        String enabledString = new StreamManagement.Enabled("stream-id", false).toXML().toString();
        XmlPullParser parser = PacketParserUtils.getParserFor((String)enabledString);
        StreamManagement.Enabled enabled = ParseStreamManagement.enabled((XmlPullParser)parser);
        Assertions.assertEquals((Object)enabledString, (Object)enabled.toXML().toString());
    }

    @Test
    public void testParseFailed() throws Exception {
        String failedStanza = XMLBuilder.create((String)"failed").a("xmlns", "urn:xmpp:sm:3").asString(outputProperties);
        StreamManagement.Failed failedPacket = ParseStreamManagement.failed((XmlPullParser)PacketParserUtils.getParserFor((String)failedStanza));
        Assertions.assertNotNull((Object)failedPacket);
        Assertions.assertTrue((failedPacket.getStanzaErrorCondition() == null ? 1 : 0) != 0);
    }

    @Test
    public void testParseFailedError() throws Exception {
        StanzaError.Condition errorCondition = StanzaError.Condition.unexpected_request;
        String failedStanza = XMLBuilder.create((String)"failed").a("xmlns", "urn:xmpp:sm:3").element(errorCondition.toString(), "urn:ietf:params:xml:ns:xmpp-stanzas").asString(outputProperties);
        StreamManagement.Failed failedPacket = ParseStreamManagement.failed((XmlPullParser)PacketParserUtils.getParserFor((String)failedStanza));
        Assertions.assertNotNull((Object)failedPacket);
        Assertions.assertTrue((failedPacket.getStanzaErrorCondition() == errorCondition ? 1 : 0) != 0);
    }

    @Test
    public void testParseFailedWithTExt() throws XmlPullParserException, IOException {
        String failedNonza = "<failed h='20' xmlns='urn:xmpp:sm:3'><item-not-found xmlns='urn:ietf:params:xml:ns:xmpp-stanzas'/><text xml:lang='en' xmlns='urn:ietf:params:xml:ns:xmpp-stanzas'>Previous session timed out</text></failed>";
        XmlPullParser parser = PacketParserUtils.getParserFor((String)"<failed h='20' xmlns='urn:xmpp:sm:3'><item-not-found xmlns='urn:ietf:params:xml:ns:xmpp-stanzas'/><text xml:lang='en' xmlns='urn:ietf:params:xml:ns:xmpp-stanzas'>Previous session timed out</text></failed>");
        StreamManagement.Failed failed = ParseStreamManagement.failed((XmlPullParser)parser);
        Assertions.assertEquals((Object)StanzaError.Condition.item_not_found, (Object)failed.getStanzaErrorCondition());
        List textElements = failed.getTextElements();
        Assertions.assertEquals((int)1, (int)textElements.size());
        StanzaErrorTextElement textElement = (StanzaErrorTextElement)textElements.get(0);
        Assertions.assertEquals((Object)"Previous session timed out", (Object)textElement.getText());
        Assertions.assertEquals((Object)"en", (Object)textElement.getLanguage());
    }

    @Test
    public void testParseResumed() throws Exception {
        long handledPackets = 42L;
        String previousID = "zid615d9";
        String resumedStanza = XMLBuilder.create((String)"resumed").a("xmlns", "urn:xmpp:sm:3").a("h", String.valueOf(handledPackets)).a("previd", previousID).asString(outputProperties);
        StreamManagement.Resumed resumedPacket = ParseStreamManagement.resumed((XmlPullParser)PacketParserUtils.getParserFor((String)resumedStanza));
        Assertions.assertNotNull((Object)resumedPacket);
        Assertions.assertEquals((long)handledPackets, (long)resumedPacket.getHandledCount());
        Assertions.assertEquals((Object)previousID, (Object)resumedPacket.getPrevId());
    }

    @Test
    public void testParseAckAnswer() throws Exception {
        long handledPackets = 84L;
        String ackStanza = XMLBuilder.create((String)"a").a("xmlns", "urn:xmpp:sm:3").a("h", String.valueOf(handledPackets)).asString(outputProperties);
        StreamManagement.AckAnswer acknowledgementPacket = ParseStreamManagement.ackAnswer((XmlPullParser)PacketParserUtils.getParserFor((String)ackStanza));
        Assertions.assertNotNull((Object)acknowledgementPacket);
        Assertions.assertEquals((long)handledPackets, (long)acknowledgementPacket.getHandledCount());
    }

    private static Properties initOutputProperties() {
        Properties properties = new Properties();
        properties.put("omit-xml-declaration", "yes");
        return properties;
    }
}

